/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.util;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;

public class PlutusOps {
    private static ObjectMapper objectMapper = new ObjectMapper();
    private static List<String> V1_OPS;
    private static List<String> V2_OPS;
    private static List<String> V3_OPS;
    private static String PLUTUS_V1_COSTS;
    private static String PLUTUS_V2_COSTS;
    private static String PLUTUS_V3_COSTS;

    public static List<String> getOperations(int version) {
        if (V1_OPS == null || V2_OPS == null || V3_OPS == null) {
            PlutusOps.initOps();
        }
        if (version == 1) {
            return V1_OPS;
        }
        if (version == 2) {
            return V2_OPS;
        }
        if (version == 3) {
            return V3_OPS;
        }
        throw new IllegalArgumentException("Invalid version: " + version);
    }

    private static void initOps() {
        try {
            LinkedHashMap map1 = (LinkedHashMap)objectMapper.readValue(PLUTUS_V1_COSTS, (TypeReference)new TypeReference<LinkedHashMap<String, Long>>(){});
            V1_OPS = map1.keySet().stream().collect(Collectors.toList());
            LinkedHashMap map2 = (LinkedHashMap)objectMapper.readValue(PLUTUS_V2_COSTS, (TypeReference)new TypeReference<LinkedHashMap<String, Long>>(){});
            V2_OPS = map2.keySet().stream().collect(Collectors.toList());
            LinkedHashMap map3 = (LinkedHashMap)objectMapper.readValue(PLUTUS_V3_COSTS, (TypeReference)new TypeReference<LinkedHashMap<String, Long>>(){});
            V3_OPS = map3.keySet().stream().collect(Collectors.toList());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    static {
        PLUTUS_V1_COSTS = "{\n  \"addInteger-cpu-arguments-intercept\" : 100788,\n  \"addInteger-cpu-arguments-slope\" : 420,\n  \"addInteger-memory-arguments-intercept\" : 1,\n  \"addInteger-memory-arguments-slope\" : 1,\n  \"appendByteString-cpu-arguments-intercept\" : 1000,\n  \"appendByteString-cpu-arguments-slope\" : 173,\n  \"appendByteString-memory-arguments-intercept\" : 0,\n  \"appendByteString-memory-arguments-slope\" : 1,\n  \"appendString-cpu-arguments-intercept\" : 1000,\n  \"appendString-cpu-arguments-slope\" : 59957,\n  \"appendString-memory-arguments-intercept\" : 4,\n  \"appendString-memory-arguments-slope\" : 1,\n  \"bData-cpu-arguments\" : 11183,\n  \"bData-memory-arguments\" : 32,\n  \"blake2b_256-cpu-arguments-intercept\" : 201305,\n  \"blake2b_256-cpu-arguments-slope\" : 8356,\n  \"blake2b_256-memory-arguments\" : 4,\n  \"cekApplyCost-exBudgetCPU\" : 16000,\n  \"cekApplyCost-exBudgetMemory\" : 100,\n  \"cekBuiltinCost-exBudgetCPU\" : 16000,\n  \"cekBuiltinCost-exBudgetMemory\" : 100,\n  \"cekConstCost-exBudgetCPU\" : 16000,\n  \"cekConstCost-exBudgetMemory\" : 100,\n  \"cekDelayCost-exBudgetCPU\" : 16000,\n  \"cekDelayCost-exBudgetMemory\" : 100,\n  \"cekForceCost-exBudgetCPU\" : 16000,\n  \"cekForceCost-exBudgetMemory\" : 100,\n  \"cekLamCost-exBudgetCPU\" : 16000,\n  \"cekLamCost-exBudgetMemory\" : 100,\n  \"cekStartupCost-exBudgetCPU\" : 100,\n  \"cekStartupCost-exBudgetMemory\" : 100,\n  \"cekVarCost-exBudgetCPU\" : 16000,\n  \"cekVarCost-exBudgetMemory\" : 100,\n  \"chooseData-cpu-arguments\" : 94375,\n  \"chooseData-memory-arguments\" : 32,\n  \"chooseList-cpu-arguments\" : 132994,\n  \"chooseList-memory-arguments\" : 32,\n  \"chooseUnit-cpu-arguments\" : 61462,\n  \"chooseUnit-memory-arguments\" : 4,\n  \"consByteString-cpu-arguments-intercept\" : 72010,\n  \"consByteString-cpu-arguments-slope\" : 178,\n  \"consByteString-memory-arguments-intercept\" : 0,\n  \"consByteString-memory-arguments-slope\" : 1,\n  \"constrData-cpu-arguments\" : 22151,\n  \"constrData-memory-arguments\" : 32,\n  \"decodeUtf8-cpu-arguments-intercept\" : 91189,\n  \"decodeUtf8-cpu-arguments-slope\" : 769,\n  \"decodeUtf8-memory-arguments-intercept\" : 4,\n  \"decodeUtf8-memory-arguments-slope\" : 2,\n  \"divideInteger-cpu-arguments-constant\" : 85848,\n  \"divideInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"divideInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"divideInteger-memory-arguments-intercept\" : 0,\n  \"divideInteger-memory-arguments-minimum\" : 1,\n  \"divideInteger-memory-arguments-slope\" : 1,\n  \"encodeUtf8-cpu-arguments-intercept\" : 1000,\n  \"encodeUtf8-cpu-arguments-slope\" : 42921,\n  \"encodeUtf8-memory-arguments-intercept\" : 4,\n  \"encodeUtf8-memory-arguments-slope\" : 2,\n  \"equalsByteString-cpu-arguments-constant\" : 24548,\n  \"equalsByteString-cpu-arguments-intercept\" : 29498,\n  \"equalsByteString-cpu-arguments-slope\" : 38,\n  \"equalsByteString-memory-arguments\" : 1,\n  \"equalsData-cpu-arguments-intercept\" : 898148,\n  \"equalsData-cpu-arguments-slope\" : 27279,\n  \"equalsData-memory-arguments\" : 1,\n  \"equalsInteger-cpu-arguments-intercept\" : 51775,\n  \"equalsInteger-cpu-arguments-slope\" : 558,\n  \"equalsInteger-memory-arguments\" : 1,\n  \"equalsString-cpu-arguments-constant\" : 39184,\n  \"equalsString-cpu-arguments-intercept\" : 1000,\n  \"equalsString-cpu-arguments-slope\" : 60594,\n  \"equalsString-memory-arguments\" : 1,\n  \"fstPair-cpu-arguments\" : 141895,\n  \"fstPair-memory-arguments\" : 32,\n  \"headList-cpu-arguments\" : 83150,\n  \"headList-memory-arguments\" : 32,\n  \"iData-cpu-arguments\" : 15299,\n  \"iData-memory-arguments\" : 32,\n  \"ifThenElse-cpu-arguments\" : 76049,\n  \"ifThenElse-memory-arguments\" : 1,\n  \"indexByteString-cpu-arguments\" : 13169,\n  \"indexByteString-memory-arguments\" : 4,\n  \"lengthOfByteString-cpu-arguments\" : 22100,\n  \"lengthOfByteString-memory-arguments\" : 10,\n  \"lessThanByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanByteString-cpu-arguments-slope\" : 74,\n  \"lessThanByteString-memory-arguments\" : 1,\n  \"lessThanEqualsByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanEqualsByteString-cpu-arguments-slope\" : 74,\n  \"lessThanEqualsByteString-memory-arguments\" : 1,\n  \"lessThanEqualsInteger-cpu-arguments-intercept\" : 43285,\n  \"lessThanEqualsInteger-cpu-arguments-slope\" : 552,\n  \"lessThanEqualsInteger-memory-arguments\" : 1,\n  \"lessThanInteger-cpu-arguments-intercept\" : 44749,\n  \"lessThanInteger-cpu-arguments-slope\" : 541,\n  \"lessThanInteger-memory-arguments\" : 1,\n  \"listData-cpu-arguments\" : 33852,\n  \"listData-memory-arguments\" : 32,\n  \"mapData-cpu-arguments\" : 68246,\n  \"mapData-memory-arguments\" : 32,\n  \"mkCons-cpu-arguments\" : 72362,\n  \"mkCons-memory-arguments\" : 32,\n  \"mkNilData-cpu-arguments\" : 7243,\n  \"mkNilData-memory-arguments\" : 32,\n  \"mkNilPairData-cpu-arguments\" : 7391,\n  \"mkNilPairData-memory-arguments\" : 32,\n  \"mkPairData-cpu-arguments\" : 11546,\n  \"mkPairData-memory-arguments\" : 32,\n  \"modInteger-cpu-arguments-constant\" : 85848,\n  \"modInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"modInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"modInteger-memory-arguments-intercept\" : 0,\n  \"modInteger-memory-arguments-minimum\" : 1,\n  \"modInteger-memory-arguments-slope\" : 1,\n  \"multiplyInteger-cpu-arguments-intercept\" : 90434,\n  \"multiplyInteger-cpu-arguments-slope\" : 519,\n  \"multiplyInteger-memory-arguments-intercept\" : 0,\n  \"multiplyInteger-memory-arguments-slope\" : 1,\n  \"nullList-cpu-arguments\" : 74433,\n  \"nullList-memory-arguments\" : 32,\n  \"quotientInteger-cpu-arguments-constant\" : 85848,\n  \"quotientInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"quotientInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"quotientInteger-memory-arguments-intercept\" : 0,\n  \"quotientInteger-memory-arguments-minimum\" : 1,\n  \"quotientInteger-memory-arguments-slope\" : 1,\n  \"remainderInteger-cpu-arguments-constant\" : 85848,\n  \"remainderInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"remainderInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"remainderInteger-memory-arguments-intercept\" : 0,\n  \"remainderInteger-memory-arguments-minimum\" : 1,\n  \"remainderInteger-memory-arguments-slope\" : 1,\n  \"sha2_256-cpu-arguments-intercept\" : 270652,\n  \"sha2_256-cpu-arguments-slope\" : 22588,\n  \"sha2_256-memory-arguments\" : 4,\n  \"sha3_256-cpu-arguments-intercept\" : 1457325,\n  \"sha3_256-cpu-arguments-slope\" : 64566,\n  \"sha3_256-memory-arguments\" : 4,\n  \"sliceByteString-cpu-arguments-intercept\" : 20467,\n  \"sliceByteString-cpu-arguments-slope\" : 1,\n  \"sliceByteString-memory-arguments-intercept\" : 4,\n  \"sliceByteString-memory-arguments-slope\" : 0,\n  \"sndPair-cpu-arguments\" : 141992,\n  \"sndPair-memory-arguments\" : 32,\n  \"subtractInteger-cpu-arguments-intercept\" : 100788,\n  \"subtractInteger-cpu-arguments-slope\" : 420,\n  \"subtractInteger-memory-arguments-intercept\" : 1,\n  \"subtractInteger-memory-arguments-slope\" : 1,\n  \"tailList-cpu-arguments\" : 81663,\n  \"tailList-memory-arguments\" : 32,\n  \"trace-cpu-arguments\" : 59498,\n  \"trace-memory-arguments\" : 32,\n  \"unBData-cpu-arguments\" : 20142,\n  \"unBData-memory-arguments\" : 32,\n  \"unConstrData-cpu-arguments\" : 24588,\n  \"unConstrData-memory-arguments\" : 32,\n  \"unIData-cpu-arguments\" : 20744,\n  \"unIData-memory-arguments\" : 32,\n  \"unListData-cpu-arguments\" : 25933,\n  \"unListData-memory-arguments\" : 32,\n  \"unMapData-cpu-arguments\" : 24623,\n  \"unMapData-memory-arguments\" : 32,\n  \"verifyEd25519Signature-cpu-arguments-intercept\" : 53384111,\n  \"verifyEd25519Signature-cpu-arguments-slope\" : 14333,\n  \"verifyEd25519Signature-memory-arguments\" : 10\n}";
        PLUTUS_V2_COSTS = "{\n  \"addInteger-cpu-arguments-intercept\" : 100788,\n  \"addInteger-cpu-arguments-slope\" : 420,\n  \"addInteger-memory-arguments-intercept\" : 1,\n  \"addInteger-memory-arguments-slope\" : 1,\n  \"appendByteString-cpu-arguments-intercept\" : 1000,\n  \"appendByteString-cpu-arguments-slope\" : 173,\n  \"appendByteString-memory-arguments-intercept\" : 0,\n  \"appendByteString-memory-arguments-slope\" : 1,\n  \"appendString-cpu-arguments-intercept\" : 1000,\n  \"appendString-cpu-arguments-slope\" : 59957,\n  \"appendString-memory-arguments-intercept\" : 4,\n  \"appendString-memory-arguments-slope\" : 1,\n  \"bData-cpu-arguments\" : 11183,\n  \"bData-memory-arguments\" : 32,\n  \"blake2b_256-cpu-arguments-intercept\" : 201305,\n  \"blake2b_256-cpu-arguments-slope\" : 8356,\n  \"blake2b_256-memory-arguments\" : 4,\n  \"cekApplyCost-exBudgetCPU\" : 16000,\n  \"cekApplyCost-exBudgetMemory\" : 100,\n  \"cekBuiltinCost-exBudgetCPU\" : 16000,\n  \"cekBuiltinCost-exBudgetMemory\" : 100,\n  \"cekConstCost-exBudgetCPU\" : 16000,\n  \"cekConstCost-exBudgetMemory\" : 100,\n  \"cekDelayCost-exBudgetCPU\" : 16000,\n  \"cekDelayCost-exBudgetMemory\" : 100,\n  \"cekForceCost-exBudgetCPU\" : 16000,\n  \"cekForceCost-exBudgetMemory\" : 100,\n  \"cekLamCost-exBudgetCPU\" : 16000,\n  \"cekLamCost-exBudgetMemory\" : 100,\n  \"cekStartupCost-exBudgetCPU\" : 100,\n  \"cekStartupCost-exBudgetMemory\" : 100,\n  \"cekVarCost-exBudgetCPU\" : 16000,\n  \"cekVarCost-exBudgetMemory\" : 100,\n  \"chooseData-cpu-arguments\" : 94375,\n  \"chooseData-memory-arguments\" : 32,\n  \"chooseList-cpu-arguments\" : 132994,\n  \"chooseList-memory-arguments\" : 32,\n  \"chooseUnit-cpu-arguments\" : 61462,\n  \"chooseUnit-memory-arguments\" : 4,\n  \"consByteString-cpu-arguments-intercept\" : 72010,\n  \"consByteString-cpu-arguments-slope\" : 178,\n  \"consByteString-memory-arguments-intercept\" : 0,\n  \"consByteString-memory-arguments-slope\" : 1,\n  \"constrData-cpu-arguments\" : 22151,\n  \"constrData-memory-arguments\" : 32,\n  \"decodeUtf8-cpu-arguments-intercept\" : 91189,\n  \"decodeUtf8-cpu-arguments-slope\" : 769,\n  \"decodeUtf8-memory-arguments-intercept\" : 4,\n  \"decodeUtf8-memory-arguments-slope\" : 2,\n  \"divideInteger-cpu-arguments-constant\" : 85848,\n  \"divideInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"divideInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"divideInteger-memory-arguments-intercept\" : 0,\n  \"divideInteger-memory-arguments-minimum\" : 1,\n  \"divideInteger-memory-arguments-slope\" : 1,\n  \"encodeUtf8-cpu-arguments-intercept\" : 1000,\n  \"encodeUtf8-cpu-arguments-slope\" : 42921,\n  \"encodeUtf8-memory-arguments-intercept\" : 4,\n  \"encodeUtf8-memory-arguments-slope\" : 2,\n  \"equalsByteString-cpu-arguments-constant\" : 24548,\n  \"equalsByteString-cpu-arguments-intercept\" : 29498,\n  \"equalsByteString-cpu-arguments-slope\" : 38,\n  \"equalsByteString-memory-arguments\" : 1,\n  \"equalsData-cpu-arguments-intercept\" : 898148,\n  \"equalsData-cpu-arguments-slope\" : 27279,\n  \"equalsData-memory-arguments\" : 1,\n  \"equalsInteger-cpu-arguments-intercept\" : 51775,\n  \"equalsInteger-cpu-arguments-slope\" : 558,\n  \"equalsInteger-memory-arguments\" : 1,\n  \"equalsString-cpu-arguments-constant\" : 39184,\n  \"equalsString-cpu-arguments-intercept\" : 1000,\n  \"equalsString-cpu-arguments-slope\" : 60594,\n  \"equalsString-memory-arguments\" : 1,\n  \"fstPair-cpu-arguments\" : 141895,\n  \"fstPair-memory-arguments\" : 32,\n  \"headList-cpu-arguments\" : 83150,\n  \"headList-memory-arguments\" : 32,\n  \"iData-cpu-arguments\" : 15299,\n  \"iData-memory-arguments\" : 32,\n  \"ifThenElse-cpu-arguments\" : 76049,\n  \"ifThenElse-memory-arguments\" : 1,\n  \"indexByteString-cpu-arguments\" : 13169,\n  \"indexByteString-memory-arguments\" : 4,\n  \"lengthOfByteString-cpu-arguments\" : 22100,\n  \"lengthOfByteString-memory-arguments\" : 10,\n  \"lessThanByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanByteString-cpu-arguments-slope\" : 74,\n  \"lessThanByteString-memory-arguments\" : 1,\n  \"lessThanEqualsByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanEqualsByteString-cpu-arguments-slope\" : 74,\n  \"lessThanEqualsByteString-memory-arguments\" : 1,\n  \"lessThanEqualsInteger-cpu-arguments-intercept\" : 43285,\n  \"lessThanEqualsInteger-cpu-arguments-slope\" : 552,\n  \"lessThanEqualsInteger-memory-arguments\" : 1,\n  \"lessThanInteger-cpu-arguments-intercept\" : 44749,\n  \"lessThanInteger-cpu-arguments-slope\" : 541,\n  \"lessThanInteger-memory-arguments\" : 1,\n  \"listData-cpu-arguments\" : 33852,\n  \"listData-memory-arguments\" : 32,\n  \"mapData-cpu-arguments\" : 68246,\n  \"mapData-memory-arguments\" : 32,\n  \"mkCons-cpu-arguments\" : 72362,\n  \"mkCons-memory-arguments\" : 32,\n  \"mkNilData-cpu-arguments\" : 7243,\n  \"mkNilData-memory-arguments\" : 32,\n  \"mkNilPairData-cpu-arguments\" : 7391,\n  \"mkNilPairData-memory-arguments\" : 32,\n  \"mkPairData-cpu-arguments\" : 11546,\n  \"mkPairData-memory-arguments\" : 32,\n  \"modInteger-cpu-arguments-constant\" : 85848,\n  \"modInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"modInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"modInteger-memory-arguments-intercept\" : 0,\n  \"modInteger-memory-arguments-minimum\" : 1,\n  \"modInteger-memory-arguments-slope\" : 1,\n  \"multiplyInteger-cpu-arguments-intercept\" : 90434,\n  \"multiplyInteger-cpu-arguments-slope\" : 519,\n  \"multiplyInteger-memory-arguments-intercept\" : 0,\n  \"multiplyInteger-memory-arguments-slope\" : 1,\n  \"nullList-cpu-arguments\" : 74433,\n  \"nullList-memory-arguments\" : 32,\n  \"quotientInteger-cpu-arguments-constant\" : 85848,\n  \"quotientInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"quotientInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"quotientInteger-memory-arguments-intercept\" : 0,\n  \"quotientInteger-memory-arguments-minimum\" : 1,\n  \"quotientInteger-memory-arguments-slope\" : 1,\n  \"remainderInteger-cpu-arguments-constant\" : 85848,\n  \"remainderInteger-cpu-arguments-model-arguments-intercept\" : 228465,\n  \"remainderInteger-cpu-arguments-model-arguments-slope\" : 122,\n  \"remainderInteger-memory-arguments-intercept\" : 0,\n  \"remainderInteger-memory-arguments-minimum\" : 1,\n  \"remainderInteger-memory-arguments-slope\" : 1,\n  \"serialiseData-cpu-arguments-intercept\" : 955506,\n  \"serialiseData-cpu-arguments-slope\" : 213312,\n  \"serialiseData-memory-arguments-intercept\" : 0,\n  \"serialiseData-memory-arguments-slope\" : 2,\n  \"sha2_256-cpu-arguments-intercept\" : 270652,\n  \"sha2_256-cpu-arguments-slope\" : 22588,\n  \"sha2_256-memory-arguments\" : 4,\n  \"sha3_256-cpu-arguments-intercept\" : 1457325,\n  \"sha3_256-cpu-arguments-slope\" : 64566,\n  \"sha3_256-memory-arguments\" : 4,\n  \"sliceByteString-cpu-arguments-intercept\" : 20467,\n  \"sliceByteString-cpu-arguments-slope\" : 1,\n  \"sliceByteString-memory-arguments-intercept\" : 4,\n  \"sliceByteString-memory-arguments-slope\" : 0,\n  \"sndPair-cpu-arguments\" : 141992,\n  \"sndPair-memory-arguments\" : 32,\n  \"subtractInteger-cpu-arguments-intercept\" : 100788,\n  \"subtractInteger-cpu-arguments-slope\" : 420,\n  \"subtractInteger-memory-arguments-intercept\" : 1,\n  \"subtractInteger-memory-arguments-slope\" : 1,\n  \"tailList-cpu-arguments\" : 81663,\n  \"tailList-memory-arguments\" : 32,\n  \"trace-cpu-arguments\" : 59498,\n  \"trace-memory-arguments\" : 32,\n  \"unBData-cpu-arguments\" : 20142,\n  \"unBData-memory-arguments\" : 32,\n  \"unConstrData-cpu-arguments\" : 24588,\n  \"unConstrData-memory-arguments\" : 32,\n  \"unIData-cpu-arguments\" : 20744,\n  \"unIData-memory-arguments\" : 32,\n  \"unListData-cpu-arguments\" : 25933,\n  \"unListData-memory-arguments\" : 32,\n  \"unMapData-cpu-arguments\" : 24623,\n  \"unMapData-memory-arguments\" : 32,\n  \"verifyEcdsaSecp256k1Signature-cpu-arguments\" : 43053543,\n  \"verifyEcdsaSecp256k1Signature-memory-arguments\" : 10,\n  \"verifyEd25519Signature-cpu-arguments-intercept\" : 53384111,\n  \"verifyEd25519Signature-cpu-arguments-slope\" : 14333,\n  \"verifyEd25519Signature-memory-arguments\" : 10,\n  \"verifySchnorrSecp256k1Signature-cpu-arguments-intercept\" : 43574283,\n  \"verifySchnorrSecp256k1Signature-cpu-arguments-slope\" : 26308,\n  \"verifySchnorrSecp256k1Signature-memory-arguments\" : 10\n}";
        PLUTUS_V3_COSTS = "{\n  \"addInteger-cpu-arguments-intercept\" : 100788,\n  \"addInteger-cpu-arguments-slope\" : 420,\n  \"addInteger-memory-arguments-intercept\" : 1,\n  \"addInteger-memory-arguments-slope\" : 1,\n  \"appendByteString-cpu-arguments-intercept\" : 1000,\n  \"appendByteString-cpu-arguments-slope\" : 173,\n  \"appendByteString-memory-arguments-intercept\" : 0,\n  \"appendByteString-memory-arguments-slope\" : 1,\n  \"appendString-cpu-arguments-intercept\" : 1000,\n  \"appendString-cpu-arguments-slope\" : 59957,\n  \"appendString-memory-arguments-intercept\" : 4,\n  \"appendString-memory-arguments-slope\" : 1,\n  \"bData-cpu-arguments\" : 11183,\n  \"bData-memory-arguments\" : 32,\n  \"blake2b_256-cpu-arguments-intercept\" : 201305,\n  \"blake2b_256-cpu-arguments-slope\" : 8356,\n  \"blake2b_256-memory-arguments\" : 4,\n  \"cekApplyCost-exBudgetCPU\" : 16000,\n  \"cekApplyCost-exBudgetMemory\" : 100,\n  \"cekBuiltinCost-exBudgetCPU\" : 16000,\n  \"cekBuiltinCost-exBudgetMemory\" : 100,\n  \"cekConstCost-exBudgetCPU\" : 16000,\n  \"cekConstCost-exBudgetMemory\" : 100,\n  \"cekDelayCost-exBudgetCPU\" : 16000,\n  \"cekDelayCost-exBudgetMemory\" : 100,\n  \"cekForceCost-exBudgetCPU\" : 16000,\n  \"cekForceCost-exBudgetMemory\" : 100,\n  \"cekLamCost-exBudgetCPU\" : 16000,\n  \"cekLamCost-exBudgetMemory\" : 100,\n  \"cekStartupCost-exBudgetCPU\" : 100,\n  \"cekStartupCost-exBudgetMemory\" : 100,\n  \"cekVarCost-exBudgetCPU\" : 16000,\n  \"cekVarCost-exBudgetMemory\" : 100,\n  \"chooseData-cpu-arguments\" : 94375,\n  \"chooseData-memory-arguments\" : 32,\n  \"chooseList-cpu-arguments\" : 132994,\n  \"chooseList-memory-arguments\" : 32,\n  \"chooseUnit-cpu-arguments\" : 61462,\n  \"chooseUnit-memory-arguments\" : 4,\n  \"consByteString-cpu-arguments-intercept\" : 72010,\n  \"consByteString-cpu-arguments-slope\" : 178,\n  \"consByteString-memory-arguments-intercept\" : 0,\n  \"consByteString-memory-arguments-slope\" : 1,\n  \"constrData-cpu-arguments\" : 22151,\n  \"constrData-memory-arguments\" : 32,\n  \"decodeUtf8-cpu-arguments-intercept\" : 91189,\n  \"decodeUtf8-cpu-arguments-slope\" : 769,\n  \"decodeUtf8-memory-arguments-intercept\" : 4,\n  \"decodeUtf8-memory-arguments-slope\" : 2,\n  \"divideInteger-cpu-arguments-constant\" : 85848,\n  \"divideInteger-cpu-arguments-model-arguments-c00\" : 123203,\n  \"divideInteger-cpu-arguments-model-arguments-c01\" : 7305,\n  \"divideInteger-cpu-arguments-model-arguments-c02\" : -900,\n  \"divideInteger-cpu-arguments-model-arguments-c10\" : 1716,\n  \"divideInteger-cpu-arguments-model-arguments-c11\" : 549,\n  \"divideInteger-cpu-arguments-model-arguments-c20\" : 57,\n  \"divideInteger-cpu-arguments-model-arguments-minimum\" : 85848,\n  \"divideInteger-memory-arguments-intercept\" : 0,\n  \"divideInteger-memory-arguments-minimum\" : 1,\n  \"divideInteger-memory-arguments-slope\" : 1,\n  \"encodeUtf8-cpu-arguments-intercept\" : 1000,\n  \"encodeUtf8-cpu-arguments-slope\" : 42921,\n  \"encodeUtf8-memory-arguments-intercept\" : 4,\n  \"encodeUtf8-memory-arguments-slope\" : 2,\n  \"equalsByteString-cpu-arguments-constant\" : 24548,\n  \"equalsByteString-cpu-arguments-intercept\" : 29498,\n  \"equalsByteString-cpu-arguments-slope\" : 38,\n  \"equalsByteString-memory-arguments\" : 1,\n  \"equalsData-cpu-arguments-intercept\" : 898148,\n  \"equalsData-cpu-arguments-slope\" : 27279,\n  \"equalsData-memory-arguments\" : 1,\n  \"equalsInteger-cpu-arguments-intercept\" : 51775,\n  \"equalsInteger-cpu-arguments-slope\" : 558,\n  \"equalsInteger-memory-arguments\" : 1,\n  \"equalsString-cpu-arguments-constant\" : 39184,\n  \"equalsString-cpu-arguments-intercept\" : 1000,\n  \"equalsString-cpu-arguments-slope\" : 60594,\n  \"equalsString-memory-arguments\" : 1,\n  \"fstPair-cpu-arguments\" : 141895,\n  \"fstPair-memory-arguments\" : 32,\n  \"headList-cpu-arguments\" : 83150,\n  \"headList-memory-arguments\" : 32,\n  \"iData-cpu-arguments\" : 15299,\n  \"iData-memory-arguments\" : 32,\n  \"ifThenElse-cpu-arguments\" : 76049,\n  \"ifThenElse-memory-arguments\" : 1,\n  \"indexByteString-cpu-arguments\" : 13169,\n  \"indexByteString-memory-arguments\" : 4,\n  \"lengthOfByteString-cpu-arguments\" : 22100,\n  \"lengthOfByteString-memory-arguments\" : 10,\n  \"lessThanByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanByteString-cpu-arguments-slope\" : 74,\n  \"lessThanByteString-memory-arguments\" : 1,\n  \"lessThanEqualsByteString-cpu-arguments-intercept\" : 28999,\n  \"lessThanEqualsByteString-cpu-arguments-slope\" : 74,\n  \"lessThanEqualsByteString-memory-arguments\" : 1,\n  \"lessThanEqualsInteger-cpu-arguments-intercept\" : 43285,\n  \"lessThanEqualsInteger-cpu-arguments-slope\" : 552,\n  \"lessThanEqualsInteger-memory-arguments\" : 1,\n  \"lessThanInteger-cpu-arguments-intercept\" : 44749,\n  \"lessThanInteger-cpu-arguments-slope\" : 541,\n  \"lessThanInteger-memory-arguments\" : 1,\n  \"listData-cpu-arguments\" : 33852,\n  \"listData-memory-arguments\" : 32,\n  \"mapData-cpu-arguments\" : 68246,\n  \"mapData-memory-arguments\" : 32,\n  \"mkCons-cpu-arguments\" : 72362,\n  \"mkCons-memory-arguments\" : 32,\n  \"mkNilData-cpu-arguments\" : 7243,\n  \"mkNilData-memory-arguments\" : 32,\n  \"mkNilPairData-cpu-arguments\" : 7391,\n  \"mkNilPairData-memory-arguments\" : 32,\n  \"mkPairData-cpu-arguments\" : 11546,\n  \"mkPairData-memory-arguments\" : 32,\n  \"modInteger-cpu-arguments-constant\" : 85848,\n  \"modInteger-cpu-arguments-model-arguments-c00\" : 123203,\n  \"modInteger-cpu-arguments-model-arguments-c01\" : 7305,\n  \"modInteger-cpu-arguments-model-arguments-c02\" : -900,\n  \"modInteger-cpu-arguments-model-arguments-c10\" : 1716,\n  \"modInteger-cpu-arguments-model-arguments-c11\" : 549,\n  \"modInteger-cpu-arguments-model-arguments-c20\" : 57,\n  \"modInteger-cpu-arguments-model-arguments-minimum\" : 85848,\n  \"modInteger-memory-arguments-intercept\" : 0,\n  \"modInteger-memory-arguments-slope\" : 1,\n  \"multiplyInteger-cpu-arguments-intercept\" : 90434,\n  \"multiplyInteger-cpu-arguments-slope\" : 519,\n  \"multiplyInteger-memory-arguments-intercept\" : 0,\n  \"multiplyInteger-memory-arguments-slope\" : 1,\n  \"nullList-cpu-arguments\" : 74433,\n  \"nullList-memory-arguments\" : 32,\n  \"quotientInteger-cpu-arguments-constant\" : 85848,\n  \"quotientInteger-cpu-arguments-model-arguments-c00\" : 123203,\n  \"quotientInteger-cpu-arguments-model-arguments-c01\" : 7305,\n  \"quotientInteger-cpu-arguments-model-arguments-c02\" : -900,\n  \"quotientInteger-cpu-arguments-model-arguments-c10\" : 1716,\n  \"quotientInteger-cpu-arguments-model-arguments-c11\" : 549,\n  \"quotientInteger-cpu-arguments-model-arguments-c20\" : 57,\n  \"quotientInteger-cpu-arguments-model-arguments-minimum\" : 85848,\n  \"quotientInteger-memory-arguments-intercept\" : 0,\n  \"quotientInteger-memory-arguments-slope\" : 1,\n  \"remainderInteger-cpu-arguments-constant\" : 1,\n  \"remainderInteger-cpu-arguments-model-arguments-c00\" : 85848,\n  \"remainderInteger-cpu-arguments-model-arguments-c01\" : 123203,\n  \"remainderInteger-cpu-arguments-model-arguments-c02\" : 7305,\n  \"remainderInteger-cpu-arguments-model-arguments-c10\" : -900,\n  \"remainderInteger-cpu-arguments-model-arguments-c11\" : 1716,\n  \"remainderInteger-cpu-arguments-model-arguments-c20\" : 549,\n  \"remainderInteger-cpu-arguments-model-arguments-minimum\" : 57,\n  \"remainderInteger-memory-arguments-intercept\" : 85848,\n  \"remainderInteger-memory-arguments-minimum\" : 0,\n  \"remainderInteger-memory-arguments-slope\" : 1,\n  \"serialiseData-cpu-arguments-intercept\" : 955506,\n  \"serialiseData-cpu-arguments-slope\" : 213312,\n  \"serialiseData-memory-arguments-intercept\" : 0,\n  \"serialiseData-memory-arguments-slope\" : 2,\n  \"sha2_256-cpu-arguments-intercept\" : 270652,\n  \"sha2_256-cpu-arguments-slope\" : 22588,\n  \"sha2_256-memory-arguments\" : 4,\n  \"sha3_256-cpu-arguments-intercept\" : 1457325,\n  \"sha3_256-cpu-arguments-slope\" : 64566,\n  \"sha3_256-memory-arguments\" : 4,\n  \"sliceByteString-cpu-arguments-intercept\" : 20467,\n  \"sliceByteString-cpu-arguments-slope\" : 1,\n  \"sliceByteString-memory-arguments-intercept\" : 4,\n  \"sliceByteString-memory-arguments-slope\" : 0,\n  \"sndPair-cpu-arguments\" : 141992,\n  \"sndPair-memory-arguments\" : 32,\n  \"subtractInteger-cpu-arguments-intercept\" : 100788,\n  \"subtractInteger-cpu-arguments-slope\" : 420,\n  \"subtractInteger-memory-arguments-intercept\" : 1,\n  \"subtractInteger-memory-arguments-slope\" : 1,\n  \"tailList-cpu-arguments\" : 81663,\n  \"tailList-memory-arguments\" : 32,\n  \"trace-cpu-arguments\" : 59498,\n  \"trace-memory-arguments\" : 32,\n  \"unBData-cpu-arguments\" : 20142,\n  \"unBData-memory-arguments\" : 32,\n  \"unConstrData-cpu-arguments\" : 24588,\n  \"unConstrData-memory-arguments\" : 32,\n  \"unIData-cpu-arguments\" : 20744,\n  \"unIData-memory-arguments\" : 32,\n  \"unListData-cpu-arguments\" : 25933,\n  \"unListData-memory-arguments\" : 32,\n  \"unMapData-cpu-arguments\" : 24623,\n  \"unMapData-memory-arguments\" : 32,\n  \"verifyEcdsaSecp256k1Signature-cpu-arguments\" : 43053543,\n  \"verifyEcdsaSecp256k1Signature-memory-arguments\" : 10,\n  \"verifyEd25519Signature-cpu-arguments-intercept\" : 53384111,\n  \"verifyEd25519Signature-cpu-arguments-slope\" : 14333,\n  \"verifyEd25519Signature-memory-arguments\" : 10,\n  \"verifySchnorrSecp256k1Signature-cpu-arguments-intercept\" : 43574283,\n  \"verifySchnorrSecp256k1Signature-cpu-arguments-slope\" : 26308,\n  \"verifySchnorrSecp256k1Signature-memory-arguments\" : 10,\n  \"cekConstrCost-exBudgetCPU\" : 16000,\n  \"cekConstrCost-exBudgetMemory\" : 100,\n  \"cekCaseCost-exBudgetCPU\" : 16000,\n  \"cekCaseCost-exBudgetMemory\" : 100,\n  \"bls12_381_G1_add-cpu-arguments\" : 962335,\n  \"bls12_381_G1_add-memory-arguments\" : 18,\n  \"bls12_381_G1_compress-cpu-arguments\" : 2780678,\n  \"bls12_381_G1_compress-memory-arguments\" : 6,\n  \"bls12_381_G1_equal-cpu-arguments\" : 442008,\n  \"bls12_381_G1_equal-memory-arguments\" : 1,\n  \"bls12_381_G1_hashToGroup-cpu-arguments-intercept\" : 52538055,\n  \"bls12_381_G1_hashToGroup-cpu-arguments-slope\" : 3756,\n  \"bls12_381_G1_hashToGroup-memory-arguments\" : 18,\n  \"bls12_381_G1_neg-cpu-arguments\" : 267929,\n  \"bls12_381_G1_neg-memory-arguments\" : 18,\n  \"bls12_381_G1_scalarMul-cpu-arguments-intercept\" : 76433006,\n  \"bls12_381_G1_scalarMul-cpu-arguments-slope\" : 8868,\n  \"bls12_381_G1_scalarMul-memory-arguments\" : 18,\n  \"bls12_381_G1_uncompress-cpu-arguments\" : 52948122,\n  \"bls12_381_G1_uncompress-memory-arguments\" : 18,\n  \"bls12_381_G2_add-cpu-arguments\" : 1995836,\n  \"bls12_381_G2_add-memory-arguments\" : 36,\n  \"bls12_381_G2_compress-cpu-arguments\" : 3227919,\n  \"bls12_381_G2_compress-memory-arguments\" : 12,\n  \"bls12_381_G2_equal-cpu-arguments\" : 901022,\n  \"bls12_381_G2_equal-memory-arguments\" : 1,\n  \"bls12_381_G2_hashToGroup-cpu-arguments-intercept\" : 166917843,\n  \"bls12_381_G2_hashToGroup-cpu-arguments-slope\" : 4307,\n  \"bls12_381_G2_hashToGroup-memory-arguments\" : 36,\n  \"bls12_381_G2_neg-cpu-arguments\" : 284546,\n  \"bls12_381_G2_neg-memory-arguments\" : 36,\n  \"bls12_381_G2_scalarMul-cpu-arguments-intercept\" : 158221314,\n  \"bls12_381_G2_scalarMul-cpu-arguments-slope\" : 26549,\n  \"bls12_381_G2_scalarMul-memory-arguments\" : 36,\n  \"bls12_381_G2_uncompress-cpu-arguments\" : 74698472,\n  \"bls12_381_G2_uncompress-memory-arguments\" : 36,\n  \"bls12_381_finalVerify-cpu-arguments\" : 333849714,\n  \"bls12_381_finalVerify-memory-arguments\" : 1,\n  \"bls12_381_millerLoop-cpu-arguments\" : 254006273,\n  \"bls12_381_millerLoop-memory-arguments\" : 72,\n  \"bls12_381_mulMlResult-cpu-arguments\" : 2174038,\n  \"bls12_381_mulMlResult-memory-arguments\" : 72,\n  \"keccak_256-cpu-arguments-intercept\" : 2261318,\n  \"keccak_256-cpu-arguments-slope\" : 64571,\n  \"keccak_256-memory-arguments\" : 4,\n  \"blake2b_224-cpu-arguments-intercept\" : 207616,\n  \"blake2b_224-cpu-arguments-slope\" : 8310,\n  \"blake2b_224-memory-arguments\" : 4,\n  \"integerToByteString-cpu-arguments-c0\" : 1293828,\n  \"integerToByteString-cpu-arguments-c1\" : 28716,\n  \"integerToByteString-cpu-arguments-c2\" : 63,\n  \"integerToByteString-memory-arguments-intercept\" : 0,\n  \"integerToByteString-memory-arguments-slope\" : 1,\n  \"byteStringToInteger-cpu-arguments-c0\" : 1006041,\n  \"byteStringToInteger-cpu-arguments-c1\" : 43623,\n  \"byteStringToInteger-cpu-arguments-c2\" : 251,\n  \"byteStringToInteger-memory-arguments-intercept\" : 0,\n  \"byteStringToInteger-memory-arguments-slope\" : 1\n}";
    }
}

