/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.plutus.util;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.spec.CostMdls;
import com.bloxbean.cardano.client.plutus.spec.Language;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.util.Bytes;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.spec.EraSerializationConfig;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import java.util.List;

public class ScriptDataHashGenerator {
    public static byte[] generate(List<Redeemer> redeemers, List<PlutusData> datums, CostMdls costMdls) throws CborSerializationException, CborException {
        return ScriptDataHashGenerator.generate(null, redeemers, datums, costMdls);
    }

    public static byte[] generate(Era era, List<Redeemer> redeemers, List<PlutusData> datums, CostMdls costMdls) throws CborSerializationException, CborException {
        byte[] encodedBytes;
        boolean plutusV1Exists;
        boolean bl = plutusV1Exists = costMdls.get(Language.PLUTUS_V1) != null;
        if (era == null && plutusV1Exists) {
            era = Era.Babbage;
        } else if (era == null) {
            era = EraSerializationConfig.INSTANCE.getEra();
        }
        Array datumArray = new Array();
        if (datums != null && datums.size() > 0) {
            for (PlutusData datum : datums) {
                datumArray.add(datum.serialize());
            }
        }
        byte[] plutusDataBytes = datumArray.getDataItems().size() != 0 ? CborSerializationUtil.serialize((DataItem)datumArray) : new byte[]{};
        if (redeemers != null && redeemers.size() > 0) {
            byte[] redeemerBytes;
            if (era.value >= Era.Conway.value) {
                Map redeemerMap = new Map();
                for (Redeemer redeemer : redeemers) {
                    Tuple<Array, Array> tuple = redeemer.serialize();
                    redeemerMap.put((DataItem)tuple._1, (DataItem)tuple._2);
                }
                redeemerBytes = CborSerializationUtil.serialize((DataItem)redeemerMap);
            } else {
                Array redeemerArray = new Array();
                for (Redeemer redeemer : redeemers) {
                    redeemerArray.add((DataItem)redeemer.serializePreConway());
                }
                redeemerBytes = CborSerializationUtil.serialize((DataItem)redeemerArray);
            }
            encodedBytes = Bytes.concat(redeemerBytes, plutusDataBytes, costMdls.getLanguageViewEncoding());
        } else {
            encodedBytes = era.value >= Era.Conway.value ? Bytes.concat(HexUtil.decodeHexString((String)"0xA0"), plutusDataBytes, costMdls.getLanguageViewEncoding()) : Bytes.concat(HexUtil.decodeHexString((String)"0x80"), plutusDataBytes, HexUtil.decodeHexString((String)"0xA0"));
        }
        return Blake2bUtil.blake2bHash256((byte[])encodedBytes);
    }
}

