/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.TransactionProcessor;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.DefaultProtocolParamsSupplier;
import com.bloxbean.cardano.client.backend.api.DefaultTransactionProcessor;
import com.bloxbean.cardano.client.backend.api.DefaultUtxoSupplier;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelectionStrategyImpl;
import com.bloxbean.cardano.client.coinselection.impl.LargestFirstUtxoSelectionStrategy;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.CollateralBuilders;
import com.bloxbean.cardano.client.function.helper.ScriptBalanceTxProviders;
import com.bloxbean.cardano.client.function.helper.ScriptCostEvaluators;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.ScriptTx;
import com.bloxbean.cardano.client.quicktx.Verifier;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import java.time.Duration;
import java.time.Instant;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickTxBuilder {
    private static final Logger log = LoggerFactory.getLogger(QuickTxBuilder.class);
    private static final int MAX_COLLATERAL_INPUTS = 3;
    private static final Amount DEFAULT_COLLATERAL_AMT = Amount.ada((Double)5.0);
    private UtxoSupplier utxoSupplier;
    private ProtocolParamsSupplier protocolParamsSupplier;
    private TransactionProcessor transactionProcessor;
    private Consumer<Transaction> txInspector;

    public QuickTxBuilder(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier, TransactionProcessor transactionProcessor) {
        this.utxoSupplier = utxoSupplier;
        this.protocolParamsSupplier = protocolParamsSupplier;
        this.transactionProcessor = transactionProcessor;
    }

    public QuickTxBuilder(BackendService backendService) {
        this((UtxoSupplier)new DefaultUtxoSupplier(backendService.getUtxoService()), (ProtocolParamsSupplier)new DefaultProtocolParamsSupplier(backendService.getEpochService()), (TransactionProcessor)new DefaultTransactionProcessor(backendService.getTransactionService()));
    }

    public TxContext compose(AbstractTx ... txs) {
        if (txs == null || txs.length == 0) {
            throw new TxBuildException("No txs provided to build transaction");
        }
        return new TxContext(txs);
    }

    public class TxContext {
        private AbstractTx[] txList;
        private String feePayer;
        private String collateralPayer;
        private TxBuilder preBalanceTrasformer;
        private TxBuilder postBalanceTrasformer;
        private int additionalSignerCount = 0;
        private int signersCount = 0;
        private TxSigner signers;
        private long validFrom;
        private long validTo;
        private boolean mergeOutputs = true;
        private TransactionEvaluator txnEvaluator;
        private UtxoSelectionStrategy utxoSelectionStrategy;
        private Verifier txVerifier;

        TxContext(AbstractTx ... txs) {
            this.txList = txs;
        }

        public TxContext feePayer(String address) {
            this.feePayer = address;
            return this;
        }

        public TxContext collateralPayer(String address) {
            this.collateralPayer = address;
            return this;
        }

        public TxContext preBalanceTx(TxBuilder txBuilder) {
            this.preBalanceTrasformer = txBuilder;
            return this;
        }

        public TxContext postBalanceTx(TxBuilder txBuilder) {
            this.postBalanceTrasformer = txBuilder;
            return this;
        }

        public TxContext additionalSignersCount(int additionalSigners) {
            this.additionalSignerCount = additionalSigners;
            return this;
        }

        public Transaction build() {
            TxBuilder txBuilder = (context, txn) -> {};
            boolean containsScriptTx = false;
            HashSet<String> fromAddresses = new HashSet<String>();
            for (AbstractTx tx : this.txList) {
                tx.verifyData();
                if (tx.getFromAddress() != null && fromAddresses.contains(tx.getFromAddress())) {
                    throw new TxBuildException("Duplicate from address found in Txs. Please use unique from addresses for each Tx.");
                }
                if (tx.getFromAddress() != null) {
                    fromAddresses.add(tx.getFromAddress());
                }
                if (tx.getChangeAddress() == null && tx instanceof ScriptTx) {
                    ((ScriptTx)tx).withChangeAddress(this.feePayer);
                }
                if (tx.getFromAddress() == null && tx instanceof ScriptTx) {
                    ((ScriptTx)tx).from(this.feePayer);
                }
                txBuilder = txBuilder.andThen(tx.complete());
                if (!(tx instanceof ScriptTx)) continue;
                containsScriptTx = true;
            }
            int totalSigners = this.getTotalSigners();
            TxBuilderContext txBuilderContext = TxBuilderContext.init((UtxoSupplier)QuickTxBuilder.this.utxoSupplier, (ProtocolParamsSupplier)QuickTxBuilder.this.protocolParamsSupplier);
            txBuilderContext.mergeOutputs(this.mergeOutputs);
            if (this.txnEvaluator != null) {
                txBuilderContext.withTxnEvaluator(this.txnEvaluator);
            } else {
                txBuilderContext.withTxnEvaluator((TransactionEvaluator)QuickTxBuilder.this.transactionProcessor);
            }
            if (this.utxoSelectionStrategy != null) {
                txBuilderContext.setUtxoSelectionStrategy(this.utxoSelectionStrategy);
            }
            if (this.preBalanceTrasformer != null) {
                txBuilder = txBuilder.andThen(this.preBalanceTrasformer);
            }
            if (this.feePayer == null) {
                if (this.txList.length == 1) {
                    this.feePayer = this.txList[0].getFeePayer();
                    if (this.feePayer == null) {
                        throw new TxBuildException("No fee payer set. Please set fee payer address using feePayer() method");
                    }
                } else {
                    throw new TxBuildException("Fee Payer address is not set. It's mandatory when there are more than one txs");
                }
            }
            txBuilder = this.buildValidityIntervalTxBuilder(txBuilder);
            if (containsScriptTx) {
                if (this.collateralPayer == null) {
                    this.collateralPayer = this.feePayer;
                }
                txBuilder = txBuilder.andThen(this.buildCollateralOutput(this.collateralPayer));
            }
            if (containsScriptTx) {
                txBuilder = txBuilder.andThen((context, transaction) -> {
                    try {
                        ScriptCostEvaluators.evaluateScriptCost().apply(context, transaction);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                });
            }
            txBuilder = txBuilder.andThen(ScriptBalanceTxProviders.balanceTx((String)this.feePayer, (int)totalSigners, (boolean)containsScriptTx));
            if (this.postBalanceTrasformer != null) {
                txBuilder = txBuilder.andThen(this.postBalanceTrasformer);
            }
            for (AbstractTx tx : this.txList) {
                txBuilder = txBuilder.andThen((context, transaction) -> tx.postBalanceTx(transaction));
            }
            return txBuilderContext.build(txBuilder);
        }

        private int getTotalSigners() {
            int totalSigners = this.signersCount;
            if (this.additionalSignerCount != 0) {
                totalSigners += this.additionalSignerCount;
            }
            return totalSigners;
        }

        public Transaction buildAndSign() {
            Transaction transaction = this.build();
            if (this.signers != null) {
                transaction = this.signers.sign(transaction);
            }
            return transaction;
        }

        private TxBuilder buildCollateralOutput(String feePayer) {
            DefaultUtxoSelectionStrategyImpl utxoSelectionStrategy = new DefaultUtxoSelectionStrategyImpl(QuickTxBuilder.this.utxoSupplier);
            Set collateralUtxos = utxoSelectionStrategy.select(feePayer, DEFAULT_COLLATERAL_AMT, null);
            if (collateralUtxos.size() > 3) {
                utxoSelectionStrategy = new LargestFirstUtxoSelectionStrategy(QuickTxBuilder.this.utxoSupplier);
                collateralUtxos = utxoSelectionStrategy.select(feePayer, DEFAULT_COLLATERAL_AMT, null);
            }
            return CollateralBuilders.collateralOutputs((String)feePayer, List.copyOf(collateralUtxos));
        }

        public Result<String> complete() {
            if (this.txList.length == 0) {
                throw new TxBuildException("At least one tx is required");
            }
            Transaction transaction = this.buildAndSign();
            if (QuickTxBuilder.this.txInspector != null) {
                QuickTxBuilder.this.txInspector.accept(transaction);
            }
            if (this.txVerifier != null) {
                this.txVerifier.verify(transaction);
            }
            try {
                Result result = QuickTxBuilder.this.transactionProcessor.submitTransaction(transaction.serialize());
                if (!result.isSuccessful()) {
                    log.error("Transaction : " + transaction);
                }
                return result;
            }
            catch (Exception e) {
                throw new ApiRuntimeException(e);
            }
        }

        public Result<String> completeAndWait() {
            return this.completeAndWait(Duration.ofSeconds(60L), msg -> log.info(msg));
        }

        public Result<String> completeAndWait(Consumer<String> logConsumer) {
            return this.completeAndWait(Duration.ofSeconds(60L), logConsumer);
        }

        public Result<String> completeAndWait(Duration timeout) {
            return this.completeAndWait(timeout, Duration.ofSeconds(2L), msg -> log.info(msg));
        }

        public Result<String> completeAndWait(Duration timeout, Consumer<String> logConsumer) {
            return this.completeAndWait(timeout, Duration.ofSeconds(2L), logConsumer);
        }

        public Result<String> completeAndWait(@NonNull Duration timeout, @NonNull Duration checkInterval, @NonNull Consumer<String> logConsumer) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            if (checkInterval == null) {
                throw new NullPointerException("checkInterval is marked non-null but is null");
            }
            if (logConsumer == null) {
                throw new NullPointerException("logConsumer is marked non-null but is null");
            }
            Result<String> result = this.complete();
            if (!result.isSuccessful()) {
                return result;
            }
            Instant startInstant = Instant.now();
            long millisToTimeout = timeout.toMillis();
            logConsumer.accept(this.showStatus("Submitted", (String)result.getValue()));
            String txHash = (String)result.getValue();
            try {
                if (result.isSuccessful()) {
                    int count = 0;
                    while (count < 60) {
                        Optional utxoOptional = QuickTxBuilder.this.utxoSupplier.getTxOutput(txHash, 0);
                        if (utxoOptional.isPresent()) {
                            logConsumer.accept(this.showStatus("Confirmed", txHash));
                            return result;
                        }
                        logConsumer.accept(this.showStatus("Pending", txHash));
                        Instant now = Instant.now();
                        if (now.isAfter(startInstant.plusMillis(millisToTimeout))) {
                            logConsumer.accept(this.showStatus("Timeout", txHash));
                            return result;
                        }
                        Thread.sleep(checkInterval.toMillis());
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while waiting for transaction to be included in the block. TxHash : " + txHash, (Throwable)e);
                logConsumer.accept("Error while waiting for transaction to be included in the block. TxHash : " + txHash);
            }
            logConsumer.accept(this.showStatus("Timeout", txHash));
            return result;
        }

        private String showStatus(String status, String txHash) {
            return String.format("[%s] Tx: %s", status, txHash);
        }

        public TxContext withSigner(@NonNull TxSigner signer) {
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            ++this.signersCount;
            this.signers = this.signers == null ? signer : this.signers.andThen(signer);
            return this;
        }

        public TxContext validFrom(long slot) {
            this.validFrom = slot;
            return this;
        }

        public TxContext validTo(long slot) {
            this.validTo = slot;
            return this;
        }

        public TxContext mergeOutputs(boolean merge) {
            this.mergeOutputs = merge;
            return this;
        }

        public TxContext withTxEvaluator(TransactionEvaluator txEvaluator) {
            this.txnEvaluator = txEvaluator;
            return this;
        }

        public TxContext withTxInspector(Consumer<Transaction> txInspector) {
            QuickTxBuilder.this.txInspector = txInspector;
            return this;
        }

        public TxContext withUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy) {
            this.utxoSelectionStrategy = utxoSelectionStrategy;
            return this;
        }

        public TxContext withVerifier(Verifier txVerifier) {
            this.txVerifier = this.txVerifier == null ? txVerifier : this.txVerifier.andThen(txVerifier);
            return this;
        }

        private TxBuilder buildValidityIntervalTxBuilder(TxBuilder txBuilder) {
            if (this.validFrom != 0L || this.validTo != 0L) {
                return txBuilder.andThen((context, txn) -> {
                    if (this.validFrom != 0L) {
                        txn.getBody().setValidityStartInterval(this.validFrom);
                    }
                    if (this.validTo != 0L) {
                        txn.getBody().setTtl(this.validTo);
                    }
                });
            }
            return txBuilder;
        }
    }
}

