/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.common.ADAConversionUtil;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.spec.cert.RegDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.cert.UnregDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.UpdateDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.VoteDelegCert;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.ProposalProcedure;
import com.bloxbean.cardano.client.transaction.spec.governance.Vote;
import com.bloxbean.cardano.client.transaction.spec.governance.Voter;
import com.bloxbean.cardano.client.transaction.spec.governance.VotingProcedure;
import com.bloxbean.cardano.client.transaction.spec.governance.VotingProcedures;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovTx {
    private static final Logger log = LoggerFactory.getLogger(GovTx.class);
    public static final BigInteger DREP_REG_DEPOSIT = ADAConversionUtil.adaToLovelace((double)2.0);
    public static final Amount DUMMY_MIN_OUTPUT_VAL = Amount.ada((Double)1.0);
    protected List<RegDRepCert> dRepRegistrations;
    protected List<DRepDeregestrationContext> dRepDeregestrationContexts;
    protected List<UpdateDRepCert> updateDrepCerts;
    protected List<CreateProposalContext> createProposalContexts;
    protected List<VotingProcedureContext> votingProcedureContexts;
    protected List<VoteDelegCert> voteDelegCerts;

    public GovTx registerDRep(@NonNull Credential drepCredential, Anchor anchor) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        RegDRepCert regDRepCert = RegDRepCert.builder().drepCredential(drepCredential).anchor(anchor).coin(DREP_REG_DEPOSIT).build();
        if (this.dRepRegistrations == null) {
            this.dRepRegistrations = new ArrayList<RegDRepCert>();
        }
        this.dRepRegistrations.add(regDRepCert);
        return this;
    }

    public GovTx unregisterDRep(@NonNull Credential drepCredential, String refundAddress, BigInteger refundAmount) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        if (refundAmount == null) {
            refundAmount = DREP_REG_DEPOSIT;
        }
        UnregDRepCert unregDRepCert = UnregDRepCert.builder().drepCredential(drepCredential).coin(refundAmount).build();
        if (this.dRepDeregestrationContexts == null) {
            this.dRepDeregestrationContexts = new ArrayList<DRepDeregestrationContext>();
        }
        this.dRepDeregestrationContexts.add(new DRepDeregestrationContext(unregDRepCert, refundAddress, refundAmount));
        return this;
    }

    public GovTx updateDRep(@NonNull Credential drepCredential, Anchor anchor) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        UpdateDRepCert updateDRepCert = UpdateDRepCert.builder().drepCredential(drepCredential).anchor(anchor).build();
        if (this.updateDrepCerts == null) {
            this.updateDrepCerts = new ArrayList<UpdateDRepCert>();
        }
        this.updateDrepCerts.add(updateDRepCert);
        return this;
    }

    public GovTx createProposal(@NonNull GovAction govAction, @NonNull BigInteger deposit, @NonNull String returnAddress, Anchor anchor) {
        if (govAction == null) {
            throw new NullPointerException("govAction is marked non-null but is null");
        }
        if (deposit == null) {
            throw new NullPointerException("deposit is marked non-null but is null");
        }
        if (returnAddress == null) {
            throw new NullPointerException("returnAddress is marked non-null but is null");
        }
        CreateProposalContext createProposalContext = new CreateProposalContext(deposit, returnAddress, govAction, anchor);
        if (this.createProposalContexts == null) {
            this.createProposalContexts = new ArrayList<CreateProposalContext>();
        }
        this.createProposalContexts.add(createProposalContext);
        return this;
    }

    public GovTx createVote(@NonNull Voter voter, @NonNull GovActionId govActionId, @NonNull Vote vote, Anchor anchor) {
        if (voter == null) {
            throw new NullPointerException("voter is marked non-null but is null");
        }
        if (govActionId == null) {
            throw new NullPointerException("govActionId is marked non-null but is null");
        }
        if (vote == null) {
            throw new NullPointerException("vote is marked non-null but is null");
        }
        if (this.votingProcedureContexts == null) {
            this.votingProcedureContexts = new ArrayList<VotingProcedureContext>();
        }
        this.votingProcedureContexts.add(new VotingProcedureContext(voter, govActionId, new VotingProcedure(vote, anchor)));
        return this;
    }

    public GovTx delegateVotingPowerTo(@NonNull Address address, @NonNull DRep drep) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (drep == null) {
            throw new NullPointerException("drep is marked non-null but is null");
        }
        byte[] delegationHash = (byte[])address.getDelegationCredentialHash().orElseThrow(() -> new TxBuildException("Invalid stake address. Address does not have delegation credential"));
        StakeCredential stakeCredential = null;
        if (address.isStakeKeyHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromKeyHash((byte[])delegationHash);
        } else if (address.isScriptHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromScriptHash((byte[])delegationHash);
        }
        VoteDelegCert voteDelegation = VoteDelegCert.builder().stakeCredential(stakeCredential).drep(drep).build();
        if (this.voteDelegCerts == null) {
            this.voteDelegCerts = new ArrayList<VoteDelegCert>();
        }
        this.voteDelegCerts.add(voteDelegation);
        return this;
    }

    Tuple<List<PaymentContext>, TxBuilder> build(String fromAddress, String changeAddress) {
        List<PaymentContext> paymentContexts = this.buildGovernancePayments(fromAddress, changeAddress);
        TxBuilder txBuilder = (context, txn) -> {};
        txBuilder = this.buildDRepRegistration(txBuilder, fromAddress);
        txBuilder = this.buildDRepDeRegistration(txBuilder, fromAddress);
        txBuilder = this.buildDRepUpdate(txBuilder, fromAddress);
        txBuilder = this.buildCreateProposal(txBuilder, fromAddress);
        txBuilder = this.buildCreateVotingProcedures(txBuilder);
        txBuilder = this.buildVoteDelegations(txBuilder);
        return new Tuple(paymentContexts, (Object)txBuilder);
    }

    private List<PaymentContext> buildGovernancePayments(String fromAddress, String changeAddress) {
        Optional<BigInteger> totalDeposit;
        ArrayList<PaymentContext> paymentContexts = new ArrayList<PaymentContext>();
        if (!(this.dRepRegistrations != null && this.dRepRegistrations.size() != 0 || this.dRepDeregestrationContexts != null && this.dRepDeregestrationContexts.size() != 0 || this.createProposalContexts != null && this.createProposalContexts.size() != 0)) {
            return paymentContexts;
        }
        if (this.dRepRegistrations != null && this.dRepRegistrations.size() > 0) {
            Amount totalDRepRegistrationDepositAmount = Amount.lovelace((BigInteger)DREP_REG_DEPOSIT.multiply(BigInteger.valueOf(this.dRepRegistrations.size())));
            paymentContexts.add(new PaymentContext(fromAddress, totalDRepRegistrationDepositAmount));
        }
        if (this.dRepDeregestrationContexts != null && this.dRepDeregestrationContexts.size() > 0) {
            paymentContexts.add(new PaymentContext(fromAddress, DUMMY_MIN_OUTPUT_VAL));
        }
        if (this.createProposalContexts != null && this.createProposalContexts.size() > 0 && (totalDeposit = this.createProposalContexts.stream().map(c -> c.deposit).reduce(BigInteger::add)).isPresent()) {
            paymentContexts.add(new PaymentContext(fromAddress, Amount.lovelace((BigInteger)totalDeposit.get())));
        }
        return paymentContexts;
    }

    private TxBuilder buildDRepRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.dRepRegistrations == null || this.dRepRegistrations.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.dRepRegistrations == null || this.dRepRegistrations.size() == 0) {
                return;
            }
            ArrayList<RegDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<RegDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            certificates.addAll(this.dRepRegistrations);
            String drepRegDepositParam = DREP_REG_DEPOSIT.toString();
            BigInteger drepRegDeposit = new BigInteger(drepRegDepositParam);
            BigInteger totalDRepRegDeposit = drepRegDeposit.multiply(BigInteger.valueOf(this.dRepRegistrations.size()));
            log.debug("Total stakekey registration deposit: " + totalDRepRegDeposit);
            txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalDRepRegDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                to.getValue().setCoin(to.getValue().getCoin().subtract(totalDRepRegDeposit));
                if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                    txn.getBody().getOutputs().remove(to);
                }
            }, () -> {
                throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
            });
        });
        return txBuilder;
    }

    private TxBuilder buildDRepDeRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.dRepDeregestrationContexts == null || this.dRepDeregestrationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.dRepDeregestrationContexts == null || this.dRepDeregestrationContexts.size() == 0) {
                return;
            }
            ArrayList<UnregDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<UnregDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            if (txn.getWitnessSet() == null) {
                txn.setWitnessSet(new TransactionWitnessSet());
            }
            for (DRepDeregestrationContext dRepDeregestrationContext : this.dRepDeregestrationContexts) {
                certificates.add(dRepDeregestrationContext.getUnregDrepCert());
                if (dRepDeregestrationContext.refundAddress == null) {
                    dRepDeregestrationContext.refundAddress = fromAddress;
                }
                txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(dRepDeregestrationContext.refundAddress)).findFirst().ifPresentOrElse(to -> to.getValue().setCoin(to.getValue().getCoin().add(dRepDeregestrationContext.refundAmount)), () -> {
                    TransactionOutput transactionOutput = new TransactionOutput(dRepDeregestrationContext.refundAddress, Value.builder().coin(dRepDeregestrationContext.refundAmount).build());
                    txn.getBody().getOutputs().add(transactionOutput);
                });
            }
        });
        return txBuilder;
    }

    private TxBuilder buildDRepUpdate(TxBuilder txBuilder, String fromAddress) {
        if (this.updateDrepCerts == null || this.updateDrepCerts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.updateDrepCerts == null || this.updateDrepCerts.size() == 0) {
                return;
            }
            ArrayList<UpdateDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<UpdateDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            certificates.addAll(this.updateDrepCerts);
        });
        return txBuilder;
    }

    private TxBuilder buildCreateProposal(TxBuilder txBuilder, String fromAddress) {
        if (this.createProposalContexts == null || this.createProposalContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.createProposalContexts == null || this.createProposalContexts.size() == 0) {
                return;
            }
            ArrayList<ProposalProcedure> proposalProcedures = txn.getBody().getProposalProcedures();
            if (proposalProcedures == null) {
                proposalProcedures = new ArrayList<ProposalProcedure>();
                txn.getBody().setProposalProcedures(proposalProcedures);
            }
            for (CreateProposalContext proposal : this.createProposalContexts) {
                proposalProcedures.add(ProposalProcedure.builder().govAction(proposal.govAction).deposit(proposal.deposit).rewardAccount(proposal.returnAddress).anchor(proposal.anchor).build());
            }
            BigInteger totalDeposit = this.createProposalContexts.stream().map(c -> c.deposit).reduce(BigInteger::add).orElse(BigInteger.ZERO);
            txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                to.getValue().setCoin(to.getValue().getCoin().subtract(totalDeposit));
                if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                    txn.getBody().getOutputs().remove(to);
                }
            }, () -> {
                throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
            });
        });
        return txBuilder;
    }

    private TxBuilder buildCreateVotingProcedures(TxBuilder txBuilder) {
        if (this.votingProcedureContexts == null || this.votingProcedureContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.votingProcedureContexts == null || this.votingProcedureContexts.size() == 0) {
                return;
            }
            VotingProcedures votingProcedures = txn.getBody().getVotingProcedures();
            if (votingProcedures == null) {
                votingProcedures = new VotingProcedures();
                txn.getBody().setVotingProcedures(votingProcedures);
            }
            for (VotingProcedureContext votingProcedureContext : this.votingProcedureContexts) {
                votingProcedures.add(votingProcedureContext.voter, votingProcedureContext.govActionId, votingProcedureContext.votingProcedure);
            }
        });
        return txBuilder;
    }

    private TxBuilder buildVoteDelegations(TxBuilder txBuilder) {
        if (this.voteDelegCerts == null || this.voteDelegCerts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.voteDelegCerts == null || this.voteDelegCerts.size() == 0) {
                return;
            }
            ArrayList<VoteDelegCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<VoteDelegCert>();
                txn.getBody().setCerts(certificates);
            }
            for (VoteDelegCert voteDelegCert : this.voteDelegCerts) {
                certificates.add(voteDelegCert);
            }
        });
        return txBuilder;
    }

    static class VotingProcedureContext {
        private Voter voter;
        private GovActionId govActionId;
        private VotingProcedure votingProcedure;

        public Voter getVoter() {
            return this.voter;
        }

        public GovActionId getGovActionId() {
            return this.govActionId;
        }

        public VotingProcedure getVotingProcedure() {
            return this.votingProcedure;
        }

        public void setVoter(Voter voter) {
            this.voter = voter;
        }

        public void setGovActionId(GovActionId govActionId) {
            this.govActionId = govActionId;
        }

        public void setVotingProcedure(VotingProcedure votingProcedure) {
            this.votingProcedure = votingProcedure;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VotingProcedureContext)) {
                return false;
            }
            VotingProcedureContext other = (VotingProcedureContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Voter this$voter = this.getVoter();
            Voter other$voter = other.getVoter();
            if (this$voter == null ? other$voter != null : !this$voter.equals(other$voter)) {
                return false;
            }
            GovActionId this$govActionId = this.getGovActionId();
            GovActionId other$govActionId = other.getGovActionId();
            if (this$govActionId == null ? other$govActionId != null : !this$govActionId.equals(other$govActionId)) {
                return false;
            }
            VotingProcedure this$votingProcedure = this.getVotingProcedure();
            VotingProcedure other$votingProcedure = other.getVotingProcedure();
            return !(this$votingProcedure == null ? other$votingProcedure != null : !this$votingProcedure.equals(other$votingProcedure));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VotingProcedureContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Voter $voter = this.getVoter();
            result = result * 59 + ($voter == null ? 43 : $voter.hashCode());
            GovActionId $govActionId = this.getGovActionId();
            result = result * 59 + ($govActionId == null ? 43 : $govActionId.hashCode());
            VotingProcedure $votingProcedure = this.getVotingProcedure();
            result = result * 59 + ($votingProcedure == null ? 43 : $votingProcedure.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.VotingProcedureContext(voter=" + this.getVoter() + ", govActionId=" + this.getGovActionId() + ", votingProcedure=" + this.getVotingProcedure() + ")";
        }

        public VotingProcedureContext(Voter voter, GovActionId govActionId, VotingProcedure votingProcedure) {
            this.voter = voter;
            this.govActionId = govActionId;
            this.votingProcedure = votingProcedure;
        }
    }

    static class CreateProposalContext {
        private BigInteger deposit;
        private String returnAddress;
        private GovAction govAction;
        private Anchor anchor;

        public BigInteger getDeposit() {
            return this.deposit;
        }

        public String getReturnAddress() {
            return this.returnAddress;
        }

        public GovAction getGovAction() {
            return this.govAction;
        }

        public Anchor getAnchor() {
            return this.anchor;
        }

        public void setDeposit(BigInteger deposit) {
            this.deposit = deposit;
        }

        public void setReturnAddress(String returnAddress) {
            this.returnAddress = returnAddress;
        }

        public void setGovAction(GovAction govAction) {
            this.govAction = govAction;
        }

        public void setAnchor(Anchor anchor) {
            this.anchor = anchor;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateProposalContext)) {
                return false;
            }
            CreateProposalContext other = (CreateProposalContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$deposit = this.getDeposit();
            BigInteger other$deposit = other.getDeposit();
            if (this$deposit == null ? other$deposit != null : !((Object)this$deposit).equals(other$deposit)) {
                return false;
            }
            String this$returnAddress = this.getReturnAddress();
            String other$returnAddress = other.getReturnAddress();
            if (this$returnAddress == null ? other$returnAddress != null : !this$returnAddress.equals(other$returnAddress)) {
                return false;
            }
            GovAction this$govAction = this.getGovAction();
            GovAction other$govAction = other.getGovAction();
            if (this$govAction == null ? other$govAction != null : !this$govAction.equals(other$govAction)) {
                return false;
            }
            Anchor this$anchor = this.getAnchor();
            Anchor other$anchor = other.getAnchor();
            return !(this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateProposalContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $deposit = this.getDeposit();
            result = result * 59 + ($deposit == null ? 43 : ((Object)$deposit).hashCode());
            String $returnAddress = this.getReturnAddress();
            result = result * 59 + ($returnAddress == null ? 43 : $returnAddress.hashCode());
            GovAction $govAction = this.getGovAction();
            result = result * 59 + ($govAction == null ? 43 : $govAction.hashCode());
            Anchor $anchor = this.getAnchor();
            result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.CreateProposalContext(deposit=" + this.getDeposit() + ", returnAddress=" + this.getReturnAddress() + ", govAction=" + this.getGovAction() + ", anchor=" + this.getAnchor() + ")";
        }

        public CreateProposalContext(BigInteger deposit, String returnAddress, GovAction govAction, Anchor anchor) {
            this.deposit = deposit;
            this.returnAddress = returnAddress;
            this.govAction = govAction;
            this.anchor = anchor;
        }
    }

    static class PaymentContext {
        private String address;
        private Amount amount;

        public String getAddress() {
            return this.address;
        }

        public Amount getAmount() {
            return this.amount;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentContext)) {
                return false;
            }
            PaymentContext other = (PaymentContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            Amount this$amount = this.getAmount();
            Amount other$amount = other.getAmount();
            return !(this$amount == null ? other$amount != null : !this$amount.equals(other$amount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaymentContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            Amount $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.PaymentContext(address=" + this.getAddress() + ", amount=" + this.getAmount() + ")";
        }

        public PaymentContext(String address, Amount amount) {
            this.address = address;
            this.amount = amount;
        }
    }

    static class DRepDeregestrationContext {
        private UnregDRepCert unregDrepCert;
        private String refundAddress;
        private BigInteger refundAmount;

        public UnregDRepCert getUnregDrepCert() {
            return this.unregDrepCert;
        }

        public String getRefundAddress() {
            return this.refundAddress;
        }

        public BigInteger getRefundAmount() {
            return this.refundAmount;
        }

        public void setUnregDrepCert(UnregDRepCert unregDrepCert) {
            this.unregDrepCert = unregDrepCert;
        }

        public void setRefundAddress(String refundAddress) {
            this.refundAddress = refundAddress;
        }

        public void setRefundAmount(BigInteger refundAmount) {
            this.refundAmount = refundAmount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DRepDeregestrationContext)) {
                return false;
            }
            DRepDeregestrationContext other = (DRepDeregestrationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UnregDRepCert this$unregDrepCert = this.getUnregDrepCert();
            UnregDRepCert other$unregDrepCert = other.getUnregDrepCert();
            if (this$unregDrepCert == null ? other$unregDrepCert != null : !this$unregDrepCert.equals(other$unregDrepCert)) {
                return false;
            }
            String this$refundAddress = this.getRefundAddress();
            String other$refundAddress = other.getRefundAddress();
            if (this$refundAddress == null ? other$refundAddress != null : !this$refundAddress.equals(other$refundAddress)) {
                return false;
            }
            BigInteger this$refundAmount = this.getRefundAmount();
            BigInteger other$refundAmount = other.getRefundAmount();
            return !(this$refundAmount == null ? other$refundAmount != null : !((Object)this$refundAmount).equals(other$refundAmount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DRepDeregestrationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UnregDRepCert $unregDrepCert = this.getUnregDrepCert();
            result = result * 59 + ($unregDrepCert == null ? 43 : $unregDrepCert.hashCode());
            String $refundAddress = this.getRefundAddress();
            result = result * 59 + ($refundAddress == null ? 43 : $refundAddress.hashCode());
            BigInteger $refundAmount = this.getRefundAmount();
            result = result * 59 + ($refundAmount == null ? 43 : ((Object)$refundAmount).hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.DRepDeregestrationContext(unregDrepCert=" + this.getUnregDrepCert() + ", refundAddress=" + this.getRefundAddress() + ", refundAmount=" + this.getRefundAmount() + ")";
        }

        public DRepDeregestrationContext(UnregDRepCert unregDrepCert, String refundAddress, BigInteger refundAmount) {
            this.unregDrepCert = unregDrepCert;
            this.refundAddress = refundAddress;
            this.refundAmount = refundAmount;
        }
    }
}

