/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.plutus.spec.ExUnits;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.quicktx.DepositRefundContext;
import com.bloxbean.cardano.client.quicktx.DepositRefundType;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.spec.cert.RegDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.cert.UnregDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.UpdateDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.VoteDelegCert;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.ProposalProcedure;
import com.bloxbean.cardano.client.transaction.spec.governance.Vote;
import com.bloxbean.cardano.client.transaction.spec.governance.Voter;
import com.bloxbean.cardano.client.transaction.spec.governance.VotingProcedure;
import com.bloxbean.cardano.client.transaction.spec.governance.VotingProcedures;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.util.UniqueList;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GovTx {
    private static final Logger log = LoggerFactory.getLogger(GovTx.class);
    protected List<DRepRegestrationContext> dRepRegistrationContexts;
    protected List<DRepDeregestrationContext> dRepDeregestrationContexts;
    protected List<UpdateDRepContext> updateDRepContexts;
    protected List<CreateProposalContext> createProposalContexts;
    protected List<VotingProcedureContext> votingProcedureContexts;
    protected List<VotingDelegationContext> votingDelegationContexts;

    public GovTx registerDRep(@NonNull Credential drepCredential, Anchor anchor, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        RegDRepCert regDRepCert = RegDRepCert.builder().drepCredential(drepCredential).anchor(anchor).coin(null).build();
        if (this.dRepRegistrationContexts == null) {
            this.dRepRegistrationContexts = new ArrayList<DRepRegestrationContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        DRepRegestrationContext drepRegistrationContext = new DRepRegestrationContext(regDRepCert, _redeemer);
        this.dRepRegistrationContexts.add(drepRegistrationContext);
        return this;
    }

    public GovTx unregisterDRep(@NonNull Credential drepCredential, String refundAddress, BigInteger refundAmount, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        UnregDRepCert unregDRepCert = UnregDRepCert.builder().drepCredential(drepCredential).coin(refundAmount).build();
        if (this.dRepDeregestrationContexts == null) {
            this.dRepDeregestrationContexts = new ArrayList<DRepDeregestrationContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        this.dRepDeregestrationContexts.add(new DRepDeregestrationContext(unregDRepCert, refundAddress, _redeemer));
        return this;
    }

    public GovTx updateDRep(@NonNull Credential drepCredential, Anchor anchor, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        UpdateDRepCert updateDRepCert = UpdateDRepCert.builder().drepCredential(drepCredential).anchor(anchor).build();
        if (this.updateDRepContexts == null) {
            this.updateDRepContexts = new ArrayList<UpdateDRepContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        this.updateDRepContexts.add(new UpdateDRepContext(updateDRepCert, _redeemer));
        return this;
    }

    public GovTx createProposal(@NonNull GovAction govAction, @NonNull String returnAddress, Anchor anchor, PlutusData redeemer) {
        if (govAction == null) {
            throw new NullPointerException("govAction is marked non-null but is null");
        }
        if (returnAddress == null) {
            throw new NullPointerException("returnAddress is marked non-null but is null");
        }
        if (this.createProposalContexts == null) {
            this.createProposalContexts = new ArrayList<CreateProposalContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Proposing).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        CreateProposalContext createProposalContext = new CreateProposalContext(null, returnAddress, govAction, anchor, _redeemer);
        this.createProposalContexts.add(createProposalContext);
        return this;
    }

    public GovTx createVote(@NonNull Voter voter, @NonNull GovActionId govActionId, @NonNull Vote vote, Anchor anchor, PlutusData redeemer) {
        if (voter == null) {
            throw new NullPointerException("voter is marked non-null but is null");
        }
        if (govActionId == null) {
            throw new NullPointerException("govActionId is marked non-null but is null");
        }
        if (vote == null) {
            throw new NullPointerException("vote is marked non-null but is null");
        }
        if (this.votingProcedureContexts == null) {
            this.votingProcedureContexts = new ArrayList<VotingProcedureContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Voting).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        this.votingProcedureContexts.add(new VotingProcedureContext(voter, govActionId, new VotingProcedure(vote, anchor), _redeemer));
        return this;
    }

    public GovTx delegateVotingPowerTo(@NonNull Address address, @NonNull DRep drep, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (drep == null) {
            throw new NullPointerException("drep is marked non-null but is null");
        }
        byte[] delegationHash = (byte[])address.getDelegationCredentialHash().orElseThrow(() -> new TxBuildException("Invalid stake address. Address does not have delegation credential"));
        StakeCredential stakeCredential = null;
        if (address.isStakeKeyHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromKeyHash((byte[])delegationHash);
        } else if (address.isScriptHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromScriptHash((byte[])delegationHash);
        }
        VoteDelegCert voteDelegation = VoteDelegCert.builder().stakeCredential(stakeCredential).drep(drep).build();
        if (this.votingDelegationContexts == null) {
            this.votingDelegationContexts = new ArrayList<VotingDelegationContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        this.votingDelegationContexts.add(new VotingDelegationContext(voteDelegation, _redeemer));
        return this;
    }

    Tuple<List<DepositRefundContext>, TxBuilder> build(String fromAddress, String changeAddress) {
        List<DepositRefundContext> depositRefundContexts = this.buildGovernancePayments(fromAddress, changeAddress);
        TxBuilder txBuilder = (context, txn) -> {};
        txBuilder = this.buildDRepRegistration(txBuilder, fromAddress);
        txBuilder = this.buildDRepDeRegistration(txBuilder, fromAddress);
        txBuilder = this.buildDRepUpdate(txBuilder, fromAddress);
        txBuilder = this.buildCreateProposal(txBuilder, fromAddress);
        txBuilder = this.buildCreateVotingProcedures(txBuilder);
        txBuilder = this.buildVoteDelegations(txBuilder);
        return new Tuple(depositRefundContexts, (Object)txBuilder);
    }

    private List<DepositRefundContext> buildGovernancePayments(String fromAddress, String changeAddress) {
        ArrayList<DepositRefundContext> depositRefundContexts = new ArrayList<DepositRefundContext>();
        if (!(this.dRepRegistrationContexts != null && this.dRepRegistrationContexts.size() != 0 || this.dRepDeregestrationContexts != null && this.dRepDeregestrationContexts.size() != 0 || this.createProposalContexts != null && this.createProposalContexts.size() != 0)) {
            return depositRefundContexts;
        }
        if (this.dRepRegistrationContexts != null && this.dRepRegistrationContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.DREP_REGISTRATION, this.dRepRegistrationContexts.size()));
        }
        if (this.dRepDeregestrationContexts != null && this.dRepDeregestrationContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.DREP_DEREGISTRATION));
        }
        if (this.createProposalContexts != null && this.createProposalContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.GOV_ACTION, this.createProposalContexts.size()));
        }
        return depositRefundContexts;
    }

    private TxBuilder buildDRepRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.dRepRegistrationContexts == null || this.dRepRegistrationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.dRepRegistrationContexts == null || this.dRepRegistrationContexts.size() == 0) {
                return;
            }
            ArrayList<RegDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<RegDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            for (DRepRegestrationContext dRepRegestrationContext : this.dRepRegistrationContexts) {
                if (dRepRegestrationContext.getRegDrepCert().getCoin() == null) {
                    RegDRepCert updatedDRepRegCert = RegDRepCert.builder().drepCredential(dRepRegestrationContext.getRegDrepCert().getDrepCredential()).anchor(dRepRegestrationContext.getRegDrepCert().getAnchor()).coin(context.getProtocolParams().getDrepDeposit()).build();
                    dRepRegestrationContext.setRegDrepCert(updatedDRepRegCert);
                    certificates.add(updatedDRepRegCert);
                } else {
                    certificates.add(dRepRegestrationContext.getRegDrepCert());
                }
                if (dRepRegestrationContext.redeemer == null) continue;
                Redeemer redeemer = dRepRegestrationContext.redeemer;
                redeemer.setIndex(certificates.size() - 1);
                txn.getWitnessSet().getRedeemers().add(redeemer);
            }
            BigInteger totalDRepRegDeposit = this.dRepRegistrationContexts.stream().map(c -> c.getRegDrepCert().getCoin()).reduce(BigInteger::add).orElse(BigInteger.ZERO);
            log.debug("Total drep registration deposit: " + totalDRepRegDeposit);
            txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalDRepRegDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                to.getValue().setCoin(to.getValue().getCoin().subtract(totalDRepRegDeposit));
                if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                    txn.getBody().getOutputs().remove(to);
                }
            }, () -> {
                throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
            });
        });
        return txBuilder;
    }

    private TxBuilder buildDRepDeRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.dRepDeregestrationContexts == null || this.dRepDeregestrationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.dRepDeregestrationContexts == null || this.dRepDeregestrationContexts.size() == 0) {
                return;
            }
            ArrayList<UnregDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<UnregDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            if (txn.getWitnessSet() == null) {
                txn.setWitnessSet(new TransactionWitnessSet());
            }
            for (DRepDeregestrationContext dRepDeregestrationContext : this.dRepDeregestrationContexts) {
                if (dRepDeregestrationContext.getUnregDrepCert().getCoin() == null) {
                    UnregDRepCert unRegDrepCert = UnregDRepCert.builder().drepCredential(dRepDeregestrationContext.getUnregDrepCert().getDrepCredential()).coin(context.getProtocolParams().getDrepDeposit()).build();
                    dRepDeregestrationContext.setUnregDrepCert(unRegDrepCert);
                    certificates.add(unRegDrepCert);
                } else {
                    certificates.add(dRepDeregestrationContext.getUnregDrepCert());
                }
                if (dRepDeregestrationContext.refundAddress == null) {
                    dRepDeregestrationContext.refundAddress = fromAddress;
                }
                if (dRepDeregestrationContext.redeemer != null) {
                    Redeemer redeemer = dRepDeregestrationContext.redeemer;
                    redeemer.setIndex(certificates.size() - 1);
                    txn.getWitnessSet().getRedeemers().add(redeemer);
                }
                txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(dRepDeregestrationContext.refundAddress)).findFirst().ifPresentOrElse(to -> to.getValue().setCoin(to.getValue().getCoin().add(dRepDeregestrationContext.getUnregDrepCert().getCoin())), () -> {
                    TransactionOutput transactionOutput = new TransactionOutput(dRepDeregestrationContext.refundAddress, Value.builder().coin(dRepDeregestrationContext.getUnregDrepCert().getCoin()).build());
                    txn.getBody().getOutputs().add(transactionOutput);
                });
            }
        });
        return txBuilder;
    }

    private TxBuilder buildDRepUpdate(TxBuilder txBuilder, String fromAddress) {
        if (this.updateDRepContexts == null || this.updateDRepContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.updateDRepContexts == null || this.updateDRepContexts.size() == 0) {
                return;
            }
            ArrayList<UpdateDRepCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<UpdateDRepCert>();
                txn.getBody().setCerts(certificates);
            }
            for (UpdateDRepContext updateDRepContext : this.updateDRepContexts) {
                certificates.add(updateDRepContext.getUpdateDRepCert());
                if (updateDRepContext.redeemer == null) continue;
                Redeemer redeemer = updateDRepContext.redeemer;
                redeemer.setIndex(certificates.size() - 1);
                txn.getWitnessSet().getRedeemers().add(redeemer);
            }
        });
        return txBuilder;
    }

    private TxBuilder buildCreateProposal(TxBuilder txBuilder, String fromAddress) {
        if (this.createProposalContexts == null || this.createProposalContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.createProposalContexts == null || this.createProposalContexts.size() == 0) {
                return;
            }
            List proposalProcedures = txn.getBody().getProposalProcedures();
            if (proposalProcedures == null) {
                proposalProcedures = new UniqueList();
                txn.getBody().setProposalProcedures(proposalProcedures);
            }
            for (CreateProposalContext proposal : this.createProposalContexts) {
                if (proposal.deposit == null) {
                    proposal.setDeposit(context.getProtocolParams().getGovActionDeposit());
                }
                proposalProcedures.add(ProposalProcedure.builder().govAction(proposal.govAction).deposit(proposal.deposit).rewardAccount(proposal.returnAddress).anchor(proposal.anchor).build());
                if (proposal.redeemer == null) continue;
                Redeemer redeemer = proposal.redeemer;
                redeemer.setIndex(proposalProcedures.size() - 1);
                txn.getWitnessSet().getRedeemers().add(redeemer);
            }
            BigInteger totalDeposit = this.createProposalContexts.stream().map(c -> c.deposit).reduce(BigInteger::add).orElse(BigInteger.ZERO);
            txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                to.getValue().setCoin(to.getValue().getCoin().subtract(totalDeposit));
                if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                    txn.getBody().getOutputs().remove(to);
                }
            }, () -> {
                throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
            });
        });
        return txBuilder;
    }

    private TxBuilder buildCreateVotingProcedures(TxBuilder txBuilder) {
        if (this.votingProcedureContexts == null || this.votingProcedureContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.votingProcedureContexts == null || this.votingProcedureContexts.size() == 0) {
                return;
            }
            VotingProcedures votingProcedures = txn.getBody().getVotingProcedures();
            if (votingProcedures == null) {
                votingProcedures = new VotingProcedures();
                txn.getBody().setVotingProcedures(votingProcedures);
            }
            int index = 0;
            for (VotingProcedureContext votingProcedureContext : this.votingProcedureContexts) {
                votingProcedures.add(votingProcedureContext.voter, votingProcedureContext.govActionId, votingProcedureContext.votingProcedure);
                if (votingProcedureContext.redeemer != null) {
                    Redeemer redeemer = votingProcedureContext.redeemer;
                    redeemer.setIndex(votingProcedures.getVoting().size() - 1);
                    txn.getWitnessSet().getRedeemers().add(redeemer);
                }
                ++index;
            }
        });
        return txBuilder;
    }

    private TxBuilder buildVoteDelegations(TxBuilder txBuilder) {
        if (this.votingDelegationContexts == null || this.votingDelegationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.votingDelegationContexts == null || this.votingDelegationContexts.size() == 0) {
                return;
            }
            ArrayList<VoteDelegCert> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<VoteDelegCert>();
                txn.getBody().setCerts(certificates);
            }
            for (VotingDelegationContext votingDelegationContext : this.votingDelegationContexts) {
                certificates.add(votingDelegationContext.getVoteDelegCert());
                if (votingDelegationContext.redeemer == null) continue;
                Redeemer redeemer = votingDelegationContext.redeemer;
                redeemer.setIndex(certificates.size() - 1);
                txn.getWitnessSet().getRedeemers().add(redeemer);
            }
        });
        return txBuilder;
    }

    static class VotingDelegationContext {
        private VoteDelegCert voteDelegCert;
        private Redeemer redeemer;

        public VoteDelegCert getVoteDelegCert() {
            return this.voteDelegCert;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setVoteDelegCert(VoteDelegCert voteDelegCert) {
            this.voteDelegCert = voteDelegCert;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VotingDelegationContext)) {
                return false;
            }
            VotingDelegationContext other = (VotingDelegationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            VoteDelegCert this$voteDelegCert = this.getVoteDelegCert();
            VoteDelegCert other$voteDelegCert = other.getVoteDelegCert();
            if (this$voteDelegCert == null ? other$voteDelegCert != null : !this$voteDelegCert.equals(other$voteDelegCert)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VotingDelegationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            VoteDelegCert $voteDelegCert = this.getVoteDelegCert();
            result = result * 59 + ($voteDelegCert == null ? 43 : $voteDelegCert.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.VotingDelegationContext(voteDelegCert=" + this.getVoteDelegCert() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public VotingDelegationContext(VoteDelegCert voteDelegCert, Redeemer redeemer) {
            this.voteDelegCert = voteDelegCert;
            this.redeemer = redeemer;
        }
    }

    static class VotingProcedureContext {
        private Voter voter;
        private GovActionId govActionId;
        private VotingProcedure votingProcedure;
        private Redeemer redeemer;

        public Voter getVoter() {
            return this.voter;
        }

        public GovActionId getGovActionId() {
            return this.govActionId;
        }

        public VotingProcedure getVotingProcedure() {
            return this.votingProcedure;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setVoter(Voter voter) {
            this.voter = voter;
        }

        public void setGovActionId(GovActionId govActionId) {
            this.govActionId = govActionId;
        }

        public void setVotingProcedure(VotingProcedure votingProcedure) {
            this.votingProcedure = votingProcedure;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof VotingProcedureContext)) {
                return false;
            }
            VotingProcedureContext other = (VotingProcedureContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Voter this$voter = this.getVoter();
            Voter other$voter = other.getVoter();
            if (this$voter == null ? other$voter != null : !this$voter.equals(other$voter)) {
                return false;
            }
            GovActionId this$govActionId = this.getGovActionId();
            GovActionId other$govActionId = other.getGovActionId();
            if (this$govActionId == null ? other$govActionId != null : !this$govActionId.equals(other$govActionId)) {
                return false;
            }
            VotingProcedure this$votingProcedure = this.getVotingProcedure();
            VotingProcedure other$votingProcedure = other.getVotingProcedure();
            if (this$votingProcedure == null ? other$votingProcedure != null : !this$votingProcedure.equals(other$votingProcedure)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof VotingProcedureContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Voter $voter = this.getVoter();
            result = result * 59 + ($voter == null ? 43 : $voter.hashCode());
            GovActionId $govActionId = this.getGovActionId();
            result = result * 59 + ($govActionId == null ? 43 : $govActionId.hashCode());
            VotingProcedure $votingProcedure = this.getVotingProcedure();
            result = result * 59 + ($votingProcedure == null ? 43 : $votingProcedure.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.VotingProcedureContext(voter=" + this.getVoter() + ", govActionId=" + this.getGovActionId() + ", votingProcedure=" + this.getVotingProcedure() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public VotingProcedureContext(Voter voter, GovActionId govActionId, VotingProcedure votingProcedure, Redeemer redeemer) {
            this.voter = voter;
            this.govActionId = govActionId;
            this.votingProcedure = votingProcedure;
            this.redeemer = redeemer;
        }
    }

    static class CreateProposalContext {
        private BigInteger deposit;
        private String returnAddress;
        private GovAction govAction;
        private Anchor anchor;
        private Redeemer redeemer;

        public BigInteger getDeposit() {
            return this.deposit;
        }

        public String getReturnAddress() {
            return this.returnAddress;
        }

        public GovAction getGovAction() {
            return this.govAction;
        }

        public Anchor getAnchor() {
            return this.anchor;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setDeposit(BigInteger deposit) {
            this.deposit = deposit;
        }

        public void setReturnAddress(String returnAddress) {
            this.returnAddress = returnAddress;
        }

        public void setGovAction(GovAction govAction) {
            this.govAction = govAction;
        }

        public void setAnchor(Anchor anchor) {
            this.anchor = anchor;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof CreateProposalContext)) {
                return false;
            }
            CreateProposalContext other = (CreateProposalContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            BigInteger this$deposit = this.getDeposit();
            BigInteger other$deposit = other.getDeposit();
            if (this$deposit == null ? other$deposit != null : !((Object)this$deposit).equals(other$deposit)) {
                return false;
            }
            String this$returnAddress = this.getReturnAddress();
            String other$returnAddress = other.getReturnAddress();
            if (this$returnAddress == null ? other$returnAddress != null : !this$returnAddress.equals(other$returnAddress)) {
                return false;
            }
            GovAction this$govAction = this.getGovAction();
            GovAction other$govAction = other.getGovAction();
            if (this$govAction == null ? other$govAction != null : !this$govAction.equals(other$govAction)) {
                return false;
            }
            Anchor this$anchor = this.getAnchor();
            Anchor other$anchor = other.getAnchor();
            if (this$anchor == null ? other$anchor != null : !this$anchor.equals(other$anchor)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof CreateProposalContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            BigInteger $deposit = this.getDeposit();
            result = result * 59 + ($deposit == null ? 43 : ((Object)$deposit).hashCode());
            String $returnAddress = this.getReturnAddress();
            result = result * 59 + ($returnAddress == null ? 43 : $returnAddress.hashCode());
            GovAction $govAction = this.getGovAction();
            result = result * 59 + ($govAction == null ? 43 : $govAction.hashCode());
            Anchor $anchor = this.getAnchor();
            result = result * 59 + ($anchor == null ? 43 : $anchor.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.CreateProposalContext(deposit=" + this.getDeposit() + ", returnAddress=" + this.getReturnAddress() + ", govAction=" + this.getGovAction() + ", anchor=" + this.getAnchor() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public CreateProposalContext(BigInteger deposit, String returnAddress, GovAction govAction, Anchor anchor, Redeemer redeemer) {
            this.deposit = deposit;
            this.returnAddress = returnAddress;
            this.govAction = govAction;
            this.anchor = anchor;
            this.redeemer = redeemer;
        }
    }

    static class UpdateDRepContext {
        private UpdateDRepCert updateDRepCert;
        private Redeemer redeemer;

        public UpdateDRepCert getUpdateDRepCert() {
            return this.updateDRepCert;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setUpdateDRepCert(UpdateDRepCert updateDRepCert) {
            this.updateDRepCert = updateDRepCert;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof UpdateDRepContext)) {
                return false;
            }
            UpdateDRepContext other = (UpdateDRepContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UpdateDRepCert this$updateDRepCert = this.getUpdateDRepCert();
            UpdateDRepCert other$updateDRepCert = other.getUpdateDRepCert();
            if (this$updateDRepCert == null ? other$updateDRepCert != null : !this$updateDRepCert.equals(other$updateDRepCert)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof UpdateDRepContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UpdateDRepCert $updateDRepCert = this.getUpdateDRepCert();
            result = result * 59 + ($updateDRepCert == null ? 43 : $updateDRepCert.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.UpdateDRepContext(updateDRepCert=" + this.getUpdateDRepCert() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public UpdateDRepContext(UpdateDRepCert updateDRepCert, Redeemer redeemer) {
            this.updateDRepCert = updateDRepCert;
            this.redeemer = redeemer;
        }
    }

    static class DRepDeregestrationContext {
        private UnregDRepCert unregDrepCert;
        private String refundAddress;
        private Redeemer redeemer;

        public UnregDRepCert getUnregDrepCert() {
            return this.unregDrepCert;
        }

        public String getRefundAddress() {
            return this.refundAddress;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setUnregDrepCert(UnregDRepCert unregDrepCert) {
            this.unregDrepCert = unregDrepCert;
        }

        public void setRefundAddress(String refundAddress) {
            this.refundAddress = refundAddress;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DRepDeregestrationContext)) {
                return false;
            }
            DRepDeregestrationContext other = (DRepDeregestrationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            UnregDRepCert this$unregDrepCert = this.getUnregDrepCert();
            UnregDRepCert other$unregDrepCert = other.getUnregDrepCert();
            if (this$unregDrepCert == null ? other$unregDrepCert != null : !this$unregDrepCert.equals(other$unregDrepCert)) {
                return false;
            }
            String this$refundAddress = this.getRefundAddress();
            String other$refundAddress = other.getRefundAddress();
            if (this$refundAddress == null ? other$refundAddress != null : !this$refundAddress.equals(other$refundAddress)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DRepDeregestrationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            UnregDRepCert $unregDrepCert = this.getUnregDrepCert();
            result = result * 59 + ($unregDrepCert == null ? 43 : $unregDrepCert.hashCode());
            String $refundAddress = this.getRefundAddress();
            result = result * 59 + ($refundAddress == null ? 43 : $refundAddress.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.DRepDeregestrationContext(unregDrepCert=" + this.getUnregDrepCert() + ", refundAddress=" + this.getRefundAddress() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public DRepDeregestrationContext(UnregDRepCert unregDrepCert, String refundAddress, Redeemer redeemer) {
            this.unregDrepCert = unregDrepCert;
            this.refundAddress = refundAddress;
            this.redeemer = redeemer;
        }
    }

    static class DRepRegestrationContext {
        private RegDRepCert regDrepCert;
        private Redeemer redeemer;

        public RegDRepCert getRegDrepCert() {
            return this.regDrepCert;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setRegDrepCert(RegDRepCert regDrepCert) {
            this.regDrepCert = regDrepCert;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DRepRegestrationContext)) {
                return false;
            }
            DRepRegestrationContext other = (DRepRegestrationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            RegDRepCert this$regDrepCert = this.getRegDrepCert();
            RegDRepCert other$regDrepCert = other.getRegDrepCert();
            if (this$regDrepCert == null ? other$regDrepCert != null : !this$regDrepCert.equals(other$regDrepCert)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof DRepRegestrationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            RegDRepCert $regDrepCert = this.getRegDrepCert();
            result = result * 59 + ($regDrepCert == null ? 43 : $regDrepCert.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "GovTx.DRepRegestrationContext(regDrepCert=" + this.getRegDrepCert() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public DRepRegestrationContext(RegDRepCert regDrepCert, Redeemer redeemer) {
            this.regDrepCert = regDrepCert;
            this.redeemer = redeemer;
        }
    }
}

