/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.ScriptSupplier;
import com.bloxbean.cardano.client.api.TransactionEvaluator;
import com.bloxbean.cardano.client.api.TransactionProcessor;
import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.exception.ApiRuntimeException;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.backend.api.BackendService;
import com.bloxbean.cardano.client.backend.api.DefaultProtocolParamsSupplier;
import com.bloxbean.cardano.client.backend.api.DefaultScriptSupplier;
import com.bloxbean.cardano.client.backend.api.DefaultTransactionProcessor;
import com.bloxbean.cardano.client.backend.api.DefaultUtxoSupplier;
import com.bloxbean.cardano.client.coinselection.UtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.UtxoSelector;
import com.bloxbean.cardano.client.coinselection.impl.DefaultUtxoSelectionStrategyImpl;
import com.bloxbean.cardano.client.coinselection.impl.ExcludeUtxoSelectionStrategy;
import com.bloxbean.cardano.client.coinselection.impl.ExcludeUtxoSelector;
import com.bloxbean.cardano.client.coinselection.impl.LargestFirstUtxoSelectionStrategy;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxBuilderContext;
import com.bloxbean.cardano.client.function.TxSigner;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.CollateralBuilders;
import com.bloxbean.cardano.client.function.helper.ReferenceScriptResolver;
import com.bloxbean.cardano.client.function.helper.ScriptBalanceTxProviders;
import com.bloxbean.cardano.client.function.helper.ScriptCostEvaluators;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.ScriptTx;
import com.bloxbean.cardano.client.quicktx.Verifier;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.util.JsonUtil;
import java.math.BigInteger;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QuickTxBuilder {
    private static final Logger log = LoggerFactory.getLogger(QuickTxBuilder.class);
    private static final int MAX_COLLATERAL_INPUTS = 3;
    private static final Amount DEFAULT_COLLATERAL_AMT = Amount.ada((Double)5.0);
    private UtxoSupplier utxoSupplier;
    private ProtocolParamsSupplier protocolParamsSupplier;
    private TransactionProcessor transactionProcessor;
    private Consumer<Transaction> txInspector;
    private ScriptSupplier backendScriptSupplier;

    public QuickTxBuilder(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier, TransactionProcessor transactionProcessor) {
        this.utxoSupplier = utxoSupplier;
        this.protocolParamsSupplier = protocolParamsSupplier;
        this.transactionProcessor = transactionProcessor;
    }

    public QuickTxBuilder(UtxoSupplier utxoSupplier, ProtocolParamsSupplier protocolParamsSupplier, ScriptSupplier scriptSupplier, TransactionProcessor transactionProcessor) {
        this.utxoSupplier = utxoSupplier;
        this.protocolParamsSupplier = protocolParamsSupplier;
        this.backendScriptSupplier = scriptSupplier;
        this.transactionProcessor = transactionProcessor;
    }

    public QuickTxBuilder(BackendService backendService) {
        this.utxoSupplier = new DefaultUtxoSupplier(backendService.getUtxoService());
        this.protocolParamsSupplier = new DefaultProtocolParamsSupplier(backendService.getEpochService());
        this.transactionProcessor = new DefaultTransactionProcessor(backendService.getTransactionService());
        try {
            this.backendScriptSupplier = new DefaultScriptSupplier(backendService.getScriptService());
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            // empty catch block
        }
    }

    public TxContext compose(AbstractTx ... txs) {
        if (txs == null || txs.length == 0) {
            throw new TxBuildException("No txs provided to build transaction");
        }
        return new TxContext(txs);
    }

    public class TxContext {
        private AbstractTx[] txList;
        private String feePayer;
        private String collateralPayer;
        private Set<byte[]> requiredSigners;
        private Set<TransactionInput> collateralInputs;
        private TxBuilder preBalanceTrasformer;
        private TxBuilder postBalanceTrasformer;
        private int additionalSignerCount = 0;
        private int signersCount = 0;
        private TxSigner signers;
        private long validFrom;
        private long validTo;
        private boolean mergeOutputs = true;
        private TransactionEvaluator txnEvaluator;
        private UtxoSelectionStrategy utxoSelectionStrategy;
        private ScriptSupplier scriptSupplier;
        private Verifier txVerifier;
        private List<PlutusScript> referenceScripts;
        private boolean ignoreScriptCostEvaluationError = true;
        private Era serializationEra;

        TxContext(AbstractTx ... txs) {
            this.txList = txs;
        }

        public TxContext feePayer(String address) {
            this.feePayer = address;
            return this;
        }

        public TxContext collateralPayer(String address) {
            this.collateralPayer = address;
            return this;
        }

        public TxContext preBalanceTx(TxBuilder txBuilder) {
            this.preBalanceTrasformer = txBuilder;
            return this;
        }

        public TxContext postBalanceTx(TxBuilder txBuilder) {
            this.postBalanceTrasformer = txBuilder;
            return this;
        }

        public TxContext additionalSignersCount(int additionalSigners) {
            this.additionalSignerCount = additionalSigners;
            return this;
        }

        public Transaction build() {
            TxBuilder txBuilder = (context, txn) -> {};
            boolean containsScriptTx = false;
            HashSet<String> fromAddresses = new HashSet<String>();
            for (AbstractTx tx : this.txList) {
                tx.verifyData();
                if (tx.getFromAddress() != null && fromAddresses.contains(tx.getFromAddress())) {
                    throw new TxBuildException("Duplicate from address found in Txs. Please use unique from addresses for each Tx.");
                }
                if (tx.getFromAddress() != null) {
                    fromAddresses.add(tx.getFromAddress());
                }
                if (tx.getChangeAddress() == null && tx instanceof ScriptTx) {
                    ((ScriptTx)tx).withChangeAddress(this.feePayer);
                }
                if (tx.getFromAddress() == null && tx instanceof ScriptTx) {
                    ((ScriptTx)tx).from(this.feePayer);
                }
                txBuilder = txBuilder.andThen(tx.complete());
                if (!(tx instanceof ScriptTx)) continue;
                containsScriptTx = true;
            }
            int totalSigners = this.getTotalSigners();
            TxBuilderContext txBuilderContext = TxBuilderContext.init((UtxoSupplier)QuickTxBuilder.this.utxoSupplier, (ProtocolParamsSupplier)QuickTxBuilder.this.protocolParamsSupplier);
            if (QuickTxBuilder.this.backendScriptSupplier != null) {
                txBuilderContext.setScriptSupplier(QuickTxBuilder.this.backendScriptSupplier);
            }
            txBuilderContext.mergeOutputs(this.mergeOutputs);
            if (this.txnEvaluator != null) {
                txBuilderContext.withTxnEvaluator(this.txnEvaluator);
            } else {
                txBuilderContext.withTxnEvaluator((TransactionEvaluator)QuickTxBuilder.this.transactionProcessor);
            }
            if (this.utxoSelectionStrategy != null) {
                txBuilderContext.setUtxoSelectionStrategy(this.utxoSelectionStrategy);
            }
            if (this.scriptSupplier != null) {
                txBuilderContext.setScriptSupplier(this.scriptSupplier);
            }
            if (this.serializationEra != null) {
                txBuilderContext.withSerializationEra(this.serializationEra);
            }
            if (this.collateralInputs != null && !this.collateralInputs.isEmpty()) {
                txBuilderContext.setUtxoSelectionStrategy((UtxoSelectionStrategy)new ExcludeUtxoSelectionStrategy(txBuilderContext.getUtxoSelectionStrategy(), this.collateralInputs));
                txBuilderContext.setUtxoSelector((UtxoSelector)new ExcludeUtxoSelector(txBuilderContext.getUtxoSelector(), this.collateralInputs));
            }
            if (this.requiredSigners != null && !this.requiredSigners.isEmpty()) {
                txBuilder = txBuilder.andThen(this.addRequiredSignersBuilder());
            }
            if (this.referenceScripts != null && !this.referenceScripts.isEmpty()) {
                this.referenceScripts.forEach(script -> txBuilderContext.addRefScripts(script));
            }
            if (this.preBalanceTrasformer != null) {
                txBuilder = txBuilder.andThen(this.preBalanceTrasformer);
            }
            if (this.feePayer == null) {
                if (this.txList.length == 1) {
                    this.feePayer = this.txList[0].getFeePayer();
                    if (this.feePayer == null) {
                        throw new TxBuildException("No fee payer set. Please set fee payer address using feePayer() method");
                    }
                } else {
                    throw new TxBuildException("Fee Payer address is not set. It's mandatory when there are more than one txs");
                }
            }
            txBuilder = this.buildValidityIntervalTxBuilder(txBuilder);
            if (containsScriptTx) {
                if (this.collateralPayer == null) {
                    this.collateralPayer = this.feePayer;
                }
                txBuilder = txBuilder.andThen(this.buildCollateralOutput(this.collateralPayer));
            }
            if (containsScriptTx) {
                if (this.referenceScripts == null || this.referenceScripts.isEmpty()) {
                    txBuilder = txBuilder.andThen(ReferenceScriptResolver.resolveReferenceScript());
                }
                txBuilder = txBuilder.andThen((context, transaction) -> {
                    block5: {
                        boolean negativeAmt;
                        boolean bl = negativeAmt = transaction.getBody().getOutputs().stream().filter(output -> output.getValue().getCoin().compareTo(BigInteger.ZERO) < 0).collect(Collectors.toList()).size() > 0;
                        if (negativeAmt) {
                            log.debug("Negative amount found in transaction output. Script cost evaluation will be done after balancing the transaction.");
                            return;
                        }
                        for (AbstractTx tx : this.txList) {
                            tx.preTxEvaluation(transaction);
                        }
                        try {
                            ScriptCostEvaluators.evaluateScriptCost().apply(context, transaction);
                        }
                        catch (Exception e) {
                            log.warn("Error while evaluating script cost", (Throwable)e);
                            if (log.isDebugEnabled()) {
                                log.debug("Transaction : " + JsonUtil.getPrettyJson((Object)transaction));
                            }
                            if (this.ignoreScriptCostEvaluationError) break block5;
                            throw new TxBuildException("Error while evaluating script cost", e);
                        }
                    }
                });
            }
            txBuilder = txBuilder.andThen(ScriptBalanceTxProviders.balanceTx((String)this.feePayer, (int)totalSigners, (boolean)containsScriptTx));
            if (this.postBalanceTrasformer != null) {
                txBuilder = txBuilder.andThen(this.postBalanceTrasformer);
            }
            for (AbstractTx tx : this.txList) {
                txBuilder = txBuilder.andThen((context, transaction) -> tx.postBalanceTx(transaction));
            }
            return txBuilderContext.build(txBuilder);
        }

        private int getTotalSigners() {
            int totalSigners = this.signersCount;
            if (this.additionalSignerCount != 0) {
                totalSigners += this.additionalSignerCount;
            }
            return totalSigners;
        }

        public Transaction buildAndSign() {
            Transaction transaction = this.build();
            if (this.signers != null) {
                transaction = this.signers.sign(transaction);
            }
            return transaction;
        }

        private TxBuilder buildCollateralOutput(String feePayer) {
            if (this.collateralInputs != null && !this.collateralInputs.isEmpty()) {
                List collateralUtxos = this.collateralInputs.stream().map(input -> QuickTxBuilder.this.utxoSupplier.getTxOutput(input.getTransactionId(), input.getIndex())).map(optionalUtxo -> (Utxo)optionalUtxo.get()).collect(Collectors.toList());
                return CollateralBuilders.collateralOutputs((String)feePayer, List.copyOf(collateralUtxos));
            }
            DefaultUtxoSelectionStrategyImpl utxoSelectionStrategy = new DefaultUtxoSelectionStrategyImpl(QuickTxBuilder.this.utxoSupplier);
            Set collateralUtxos = utxoSelectionStrategy.select(feePayer, DEFAULT_COLLATERAL_AMT, null);
            if (collateralUtxos.size() > 3) {
                utxoSelectionStrategy = new LargestFirstUtxoSelectionStrategy(QuickTxBuilder.this.utxoSupplier);
                collateralUtxos = utxoSelectionStrategy.select(feePayer, DEFAULT_COLLATERAL_AMT, null);
            }
            return CollateralBuilders.collateralOutputs((String)feePayer, List.copyOf(collateralUtxos));
        }

        private TxBuilder addRequiredSignersBuilder() {
            return (context, txn) -> {
                ArrayList<byte[]> txRequiredSigners = txn.getBody().getRequiredSigners();
                if (txRequiredSigners == null) {
                    txRequiredSigners = new ArrayList<byte[]>();
                    txn.getBody().setRequiredSigners(txRequiredSigners);
                }
                txRequiredSigners.addAll(this.requiredSigners);
            };
        }

        public Result<String> complete() {
            if (this.txList.length == 0) {
                throw new TxBuildException("At least one tx is required");
            }
            Transaction transaction = this.buildAndSign();
            if (QuickTxBuilder.this.txInspector != null) {
                QuickTxBuilder.this.txInspector.accept(transaction);
            }
            if (this.txVerifier != null) {
                this.txVerifier.verify(transaction);
            }
            try {
                Result result = QuickTxBuilder.this.transactionProcessor.submitTransaction(transaction.serialize());
                if (!result.isSuccessful()) {
                    log.error("Transaction : " + transaction);
                }
                return result;
            }
            catch (Exception e) {
                throw new ApiRuntimeException(e);
            }
        }

        public Result<String> completeAndWait() {
            return this.completeAndWait(Duration.ofSeconds(60L), msg -> log.info(msg));
        }

        public Result<String> completeAndWait(Consumer<String> logConsumer) {
            return this.completeAndWait(Duration.ofSeconds(60L), logConsumer);
        }

        public Result<String> completeAndWait(Duration timeout) {
            return this.completeAndWait(timeout, Duration.ofSeconds(2L), msg -> log.info(msg));
        }

        public Result<String> completeAndWait(Duration timeout, Consumer<String> logConsumer) {
            return this.completeAndWait(timeout, Duration.ofSeconds(2L), logConsumer);
        }

        public Result<String> completeAndWait(@NonNull Duration timeout, @NonNull Duration checkInterval, @NonNull Consumer<String> logConsumer) {
            if (timeout == null) {
                throw new NullPointerException("timeout is marked non-null but is null");
            }
            if (checkInterval == null) {
                throw new NullPointerException("checkInterval is marked non-null but is null");
            }
            if (logConsumer == null) {
                throw new NullPointerException("logConsumer is marked non-null but is null");
            }
            Result<String> result = this.complete();
            if (!result.isSuccessful()) {
                return result;
            }
            Instant startInstant = Instant.now();
            long millisToTimeout = timeout.toMillis();
            logConsumer.accept(this.showStatus("Submitted", (String)result.getValue()));
            String txHash = (String)result.getValue();
            try {
                if (result.isSuccessful()) {
                    int count = 0;
                    while (count < 60) {
                        Optional utxoOptional = QuickTxBuilder.this.utxoSupplier.getTxOutput(txHash, 0);
                        if (utxoOptional.isPresent()) {
                            logConsumer.accept(this.showStatus("Confirmed", txHash));
                            return result;
                        }
                        logConsumer.accept(this.showStatus("Pending", txHash));
                        Instant now = Instant.now();
                        if (now.isAfter(startInstant.plusMillis(millisToTimeout))) {
                            logConsumer.accept(this.showStatus("Timeout", txHash));
                            return result;
                        }
                        Thread.sleep(checkInterval.toMillis());
                    }
                }
            }
            catch (Exception e) {
                log.error("Error while waiting for transaction to be included in the block. TxHash : " + txHash, (Throwable)e);
                logConsumer.accept("Error while waiting for transaction to be included in the block. TxHash : " + txHash);
            }
            logConsumer.accept(this.showStatus("Timeout", txHash));
            return result;
        }

        private String showStatus(String status, String txHash) {
            return String.format("[%s] Tx: %s", status, txHash);
        }

        public TxContext withSigner(@NonNull TxSigner signer) {
            if (signer == null) {
                throw new NullPointerException("signer is marked non-null but is null");
            }
            ++this.signersCount;
            this.signers = this.signers == null ? signer : this.signers.andThen(signer);
            return this;
        }

        public TxContext validFrom(long slot) {
            this.validFrom = slot;
            return this;
        }

        public TxContext validTo(long slot) {
            this.validTo = slot;
            return this;
        }

        public TxContext mergeOutputs(boolean merge) {
            this.mergeOutputs = merge;
            return this;
        }

        public TxContext withTxEvaluator(TransactionEvaluator txEvaluator) {
            this.txnEvaluator = txEvaluator;
            return this;
        }

        public TxContext withTxInspector(Consumer<Transaction> txInspector) {
            QuickTxBuilder.this.txInspector = txInspector;
            return this;
        }

        public TxContext withUtxoSelectionStrategy(UtxoSelectionStrategy utxoSelectionStrategy) {
            this.utxoSelectionStrategy = utxoSelectionStrategy;
            return this;
        }

        public TxContext withScriptSupplier(ScriptSupplier scriptSupplier) {
            this.scriptSupplier = scriptSupplier;
            return this;
        }

        public TxContext withVerifier(Verifier txVerifier) {
            this.txVerifier = this.txVerifier == null ? txVerifier : this.txVerifier.andThen(txVerifier);
            return this;
        }

        public TxContext withRequiredSigners(Address ... addresses) {
            if (addresses == null || addresses.length == 0) {
                throw new TxBuildException("Address is required");
            }
            if (this.requiredSigners == null) {
                this.requiredSigners = new HashSet<byte[]>();
            }
            for (Address address : addresses) {
                if (address.getPaymentCredential().isPresent()) {
                    address.getPaymentCredential().map(credential -> this.requiredSigners.add(credential.getBytes())).orElseThrow(() -> new TxBuildException("Address is not a payment address : " + address));
                    continue;
                }
                if (address.getDelegationCredential().isPresent()) {
                    address.getDelegationCredential().map(credential -> this.requiredSigners.add(credential.getBytes())).orElseThrow(() -> new TxBuildException("Address is not a stake address : " + address));
                    continue;
                }
                throw new TxBuildException("Address is not a payment or stake address");
            }
            return this;
        }

        public TxContext withRequiredSigners(byte[] ... credentials) {
            if (credentials == null || credentials.length == 0) {
                throw new TxBuildException("Credential is required");
            }
            if (this.requiredSigners == null) {
                this.requiredSigners = new HashSet<byte[]>();
            }
            for (byte[] credential : credentials) {
                this.requiredSigners.add(credential);
            }
            return this;
        }

        public TxContext withCollateralInputs(TransactionInput ... inputs) {
            if (inputs == null || inputs.length == 0) {
                throw new TxBuildException("Collateral inputs can't be null or empty");
            }
            if (this.collateralInputs == null) {
                this.collateralInputs = new HashSet<TransactionInput>();
            }
            for (TransactionInput collateralInput : inputs) {
                this.collateralInputs.add(collateralInput);
            }
            return this;
        }

        public TxContext ignoreScriptCostEvaluationError(boolean flag) {
            this.ignoreScriptCostEvaluationError = flag;
            return this;
        }

        public TxContext withSerializationEra(Era era) {
            this.serializationEra = era;
            return this;
        }

        public TxContext withReferenceScripts(PlutusScript ... scripts) {
            if (scripts == null || scripts.length == 0) {
                throw new TxBuildException("Reference scripts can't be null or empty");
            }
            if (this.referenceScripts == null) {
                this.referenceScripts = new ArrayList<PlutusScript>();
            }
            this.referenceScripts.addAll(Arrays.asList(scripts));
            return this;
        }

        private TxBuilder buildValidityIntervalTxBuilder(TxBuilder txBuilder) {
            if (this.validFrom != 0L || this.validTo != 0L) {
                return txBuilder.andThen((context, txn) -> {
                    if (this.validFrom != 0L) {
                        txn.getBody().setValidityStartInterval(this.validFrom);
                    }
                    if (this.validTo != 0L) {
                        txn.getBody().setTtl(this.validTo);
                    }
                });
            }
            return txBuilder;
        }
    }
}

