/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.AddressType;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.plutus.spec.ExUnits;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.quicktx.DepositRefundContext;
import com.bloxbean.cardano.client.quicktx.DepositRefundType;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.transaction.spec.Withdrawal;
import com.bloxbean.cardano.client.transaction.spec.cert.PoolRegistration;
import com.bloxbean.cardano.client.transaction.spec.cert.PoolRetirement;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeDelegation;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeDeregistration;
import com.bloxbean.cardano.client.transaction.spec.cert.StakePoolId;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeRegistration;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class StakeTx {
    private static final Logger log = LoggerFactory.getLogger(StakeTx.class);
    protected List<StakeRegistration> stakeRegistrations;
    protected List<StakeKeyDeregestrationContext> stakeDeRegistrationContexts;
    protected List<StakeDelegationContext> stakeDelegationContexts;
    protected List<WithdrawalContext> withdrawalContexts;
    protected List<PoolRegistrationContext> poolRegistrationContexts;
    protected List<PoolRetirement> poolRetirements;

    public StakeTx registerStakeAddress(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        byte[] delegationHash = (byte[])address.getDelegationCredentialHash().orElseThrow(() -> new TxBuildException("Invalid stake address. Address does not have delegation credential"));
        StakeCredential stakeCredential = null;
        if (address.isStakeKeyHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromKeyHash((byte[])delegationHash);
        } else if (address.isScriptHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromScriptHash((byte[])delegationHash);
        }
        if (this.stakeRegistrations == null) {
            this.stakeRegistrations = new ArrayList<StakeRegistration>();
        }
        StakeRegistration stakeRegistration = new StakeRegistration(stakeCredential);
        this.stakeRegistrations.add(stakeRegistration);
        return this;
    }

    public StakeTx deregisterStakeAddress(@NonNull Address address, PlutusData redeemer, String refundAddr) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        byte[] delegationHash = (byte[])address.getDelegationCredentialHash().orElseThrow(() -> new TxBuildException("Invalid stake address. Address does not have delegation credential"));
        StakeCredential stakeCredential = null;
        if (address.isStakeKeyHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromKeyHash((byte[])delegationHash);
        } else if (address.isScriptHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromScriptHash((byte[])delegationHash);
        }
        if (this.stakeDeRegistrationContexts == null) {
            this.stakeDeRegistrationContexts = new ArrayList<StakeKeyDeregestrationContext>();
        }
        StakeDeregistration stakeDeregistration = new StakeDeregistration(stakeCredential);
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        StakeKeyDeregestrationContext stakeKeyDeregestrationContext = new StakeKeyDeregestrationContext(stakeDeregistration, _redeemer, refundAddr);
        this.stakeDeRegistrationContexts.add(stakeKeyDeregestrationContext);
        return this;
    }

    public StakeTx delegateTo(@NonNull Address address, @NonNull String poolId, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        byte[] delegationHash = (byte[])address.getDelegationCredentialHash().orElseThrow(() -> new TxBuildException("Invalid stake address. Address does not have delegation credential"));
        StakeCredential stakeCredential = null;
        if (address.isStakeKeyHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromKeyHash((byte[])delegationHash);
        } else if (address.isScriptHashInDelegationPart()) {
            stakeCredential = StakeCredential.fromScriptHash((byte[])delegationHash);
        }
        if (this.stakeDelegationContexts == null) {
            this.stakeDelegationContexts = new ArrayList<StakeDelegationContext>();
        }
        StakePoolId stakePoolId = poolId.startsWith("pool") ? StakePoolId.fromBech32PoolId((String)poolId) : StakePoolId.fromHexPoolId((String)poolId);
        StakeDelegation stakeDelegation = new StakeDelegation(stakeCredential, stakePoolId);
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Cert).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        StakeDelegationContext stakeDelegationContext = new StakeDelegationContext(stakeDelegation, _redeemer);
        this.stakeDelegationContexts.add(stakeDelegationContext);
        return this;
    }

    public StakeTx withdraw(@NonNull Address address, @NonNull BigInteger amount, PlutusData redeemer, String receiver) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        if (AddressType.Reward != address.getAddressType()) {
            throw new TxBuildException("Invalid address type. Only reward address can be used for withdrawal");
        }
        if (this.withdrawalContexts == null) {
            this.withdrawalContexts = new ArrayList<WithdrawalContext>();
        }
        Redeemer _redeemer = null;
        if (redeemer != null) {
            _redeemer = Redeemer.builder().tag(RedeemerTag.Reward).data(redeemer).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(1000L)).build()).build();
        }
        this.withdrawalContexts.add(new WithdrawalContext(new Withdrawal(address.toBech32(), amount), _redeemer, receiver));
        return this;
    }

    public StakeTx registerPool(@NonNull PoolRegistration poolRegistration) {
        if (poolRegistration == null) {
            throw new NullPointerException("poolRegistration is marked non-null but is null");
        }
        if (this.poolRegistrationContexts == null) {
            this.poolRegistrationContexts = new ArrayList<PoolRegistrationContext>();
        }
        this.poolRegistrationContexts.add(new PoolRegistrationContext(poolRegistration, false));
        return this;
    }

    public StakeTx updatePool(@NonNull PoolRegistration poolRegistration) {
        if (poolRegistration == null) {
            throw new NullPointerException("poolRegistration is marked non-null but is null");
        }
        if (this.poolRegistrationContexts == null) {
            this.poolRegistrationContexts = new ArrayList<PoolRegistrationContext>();
        }
        this.poolRegistrationContexts.add(new PoolRegistrationContext(poolRegistration, true));
        return this;
    }

    public StakeTx retirePool(@NonNull String poolId, int epoch) {
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        if (epoch <= 0) {
            throw new TxBuildException("Invalid epoch. Epoch should be greater than current epoch");
        }
        if (this.poolRetirements == null) {
            this.poolRetirements = new ArrayList<PoolRetirement>();
        }
        byte[] poolKeyHash = poolId.startsWith("pool") ? StakePoolId.fromBech32PoolId((String)poolId).getPoolKeyHash() : StakePoolId.fromHexPoolId((String)poolId).getPoolKeyHash();
        this.poolRetirements.add(new PoolRetirement(poolKeyHash, (long)epoch));
        return this;
    }

    Tuple<List<DepositRefundContext>, TxBuilder> build(String fromAddress, String changeAddress) {
        List<DepositRefundContext> paymentContexts = this.buildStakePayments(fromAddress, changeAddress);
        TxBuilder txBuilder = (context, txn) -> {};
        txBuilder = this.buildStakeAddressRegistration(txBuilder, fromAddress);
        txBuilder = this.buildStakeAddressDeRegistration(txBuilder, changeAddress);
        txBuilder = this.buildStakeDelegation(txBuilder);
        txBuilder = this.buildWithdrawal(txBuilder, changeAddress);
        txBuilder = this.buildPoolRegistration(txBuilder, fromAddress);
        txBuilder = this.buildPoolRetirement(txBuilder);
        return new Tuple(paymentContexts, (Object)txBuilder);
    }

    private List<DepositRefundContext> buildStakePayments(String fromAddress, String changeAddress) {
        List poolRegistrations;
        ArrayList<DepositRefundContext> depositRefundContexts = new ArrayList<DepositRefundContext>();
        if (!(this.stakeRegistrations != null && this.stakeRegistrations.size() != 0 || this.stakeDeRegistrationContexts != null && this.stakeDeRegistrationContexts.size() != 0 || this.stakeDelegationContexts != null && this.stakeDelegationContexts.size() != 0 || this.withdrawalContexts != null && this.withdrawalContexts.size() != 0 || this.poolRegistrationContexts != null && this.poolRegistrationContexts.size() != 0 || this.poolRetirements != null && this.poolRetirements.size() != 0)) {
            return depositRefundContexts;
        }
        if (this.stakeRegistrations != null && this.stakeRegistrations.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.STAKE_KEY_REGISTRATION, this.stakeRegistrations.size()));
        }
        if (this.stakeDeRegistrationContexts != null && this.stakeDeRegistrationContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.STAKE_KEY_DEREGISTRATION));
        }
        if (this.stakeDelegationContexts != null && this.stakeDelegationContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.DELGATION));
        }
        if (this.withdrawalContexts != null && this.withdrawalContexts.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.WITHDRAWAL));
        }
        if (this.poolRegistrationContexts != null && this.poolRegistrationContexts.size() > 0 && (poolRegistrations = this.poolRegistrationContexts.stream().filter(poolRegistrationContext -> !poolRegistrationContext.isUpdate()).map(PoolRegistrationContext::getPoolRegistration).collect(Collectors.toList())).size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.POOL_REGISTRATION, poolRegistrations.size()));
        }
        if (this.poolRetirements != null && this.poolRetirements.size() > 0) {
            depositRefundContexts.add(new DepositRefundContext(fromAddress, DepositRefundType.POOL_RETIREMENT));
        }
        return depositRefundContexts;
    }

    private TxBuilder buildStakeAddressRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.stakeRegistrations == null || this.stakeRegistrations.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.stakeRegistrations == null || this.stakeRegistrations.size() == 0) {
                return;
            }
            ArrayList<StakeRegistration> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<StakeRegistration>();
                txn.getBody().setCerts(certificates);
            }
            certificates.addAll(this.stakeRegistrations);
            String keyDeposit = context.getProtocolParams().getKeyDeposit();
            BigInteger stakeKeyDeposit = new BigInteger(keyDeposit);
            BigInteger totalStakeKeyDeposit = stakeKeyDeposit.multiply(BigInteger.valueOf(this.stakeRegistrations.size()));
            log.debug("Total stakekey registration deposit: " + totalStakeKeyDeposit);
            txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalStakeKeyDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                to.getValue().setCoin(to.getValue().getCoin().subtract(totalStakeKeyDeposit));
                if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                    txn.getBody().getOutputs().remove(to);
                }
            }, () -> {
                throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
            });
        });
        return txBuilder;
    }

    private TxBuilder buildStakeAddressDeRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.stakeDeRegistrationContexts == null || this.stakeDeRegistrationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.stakeDeRegistrationContexts == null || this.stakeDeRegistrationContexts.size() == 0) {
                return;
            }
            ArrayList<StakeDeregistration> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<StakeDeregistration>();
                txn.getBody().setCerts(certificates);
            }
            if (txn.getWitnessSet() == null) {
                txn.setWitnessSet(new TransactionWitnessSet());
            }
            BigInteger stakeKeyRegDeposit = new BigInteger(context.getProtocolParams().getKeyDeposit());
            for (StakeKeyDeregestrationContext stakeKeyDeregestrationContext : this.stakeDeRegistrationContexts) {
                certificates.add(stakeKeyDeregestrationContext.getStakeDeregistration());
                if (stakeKeyDeregestrationContext.refundAddress == null) {
                    stakeKeyDeregestrationContext.refundAddress = fromAddress;
                }
                if (stakeKeyDeregestrationContext.redeemer != null) {
                    Redeemer redeemer = stakeKeyDeregestrationContext.redeemer;
                    redeemer.setIndex(certificates.size() - 1);
                    txn.getWitnessSet().getRedeemers().add(redeemer);
                }
                txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(stakeKeyDeregestrationContext.refundAddress)).findFirst().ifPresentOrElse(to -> to.getValue().setCoin(to.getValue().getCoin().add(stakeKeyRegDeposit)), () -> {
                    TransactionOutput transactionOutput = new TransactionOutput(stakeKeyDeregestrationContext.refundAddress, Value.builder().coin(stakeKeyRegDeposit).build());
                    txn.getBody().getOutputs().add(transactionOutput);
                });
            }
        });
        return txBuilder;
    }

    private TxBuilder buildStakeDelegation(TxBuilder txBuilder) {
        if (this.stakeDelegationContexts == null || this.stakeDelegationContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.stakeDelegationContexts == null || this.stakeDelegationContexts.size() == 0) {
                return;
            }
            ArrayList<StakeDelegation> certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList<StakeDelegation>();
                txn.getBody().setCerts(certificates);
            }
            if (txn.getWitnessSet() == null) {
                txn.setWitnessSet(new TransactionWitnessSet());
            }
            for (StakeDelegationContext stakeDelegationContext : this.stakeDelegationContexts) {
                certificates.add(stakeDelegationContext.getStakeDelegation());
                if (stakeDelegationContext.redeemer == null) continue;
                Redeemer redeemer = stakeDelegationContext.redeemer;
                redeemer.setIndex(certificates.size() - 1);
                txn.getWitnessSet().getRedeemers().add(redeemer);
            }
        });
        return txBuilder;
    }

    private TxBuilder buildWithdrawal(TxBuilder txBuilder, String changeAddress) {
        if (this.withdrawalContexts == null || this.withdrawalContexts.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.withdrawalContexts == null || this.withdrawalContexts.size() == 0) {
                return;
            }
            if (txn.getBody().getWithdrawals() == null || txn.getBody().getWithdrawals().isEmpty()) {
                txn.getBody().setWithdrawals(new ArrayList());
            }
            for (WithdrawalContext withdrawalContext : this.withdrawalContexts) {
                txn.getBody().getWithdrawals().add(withdrawalContext.getWithdrawal());
                if (withdrawalContext.receiver == null) {
                    withdrawalContext.receiver = changeAddress;
                }
                if (withdrawalContext.redeemer != null) {
                    Redeemer redeemer = withdrawalContext.redeemer;
                    redeemer.setIndex(txn.getBody().getWithdrawals().size() - 1);
                    txn.getWitnessSet().getRedeemers().add(redeemer);
                }
                txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(withdrawalContext.receiver)).findFirst().ifPresentOrElse(to -> to.getValue().setCoin(to.getValue().getCoin().add(withdrawalContext.withdrawal.getCoin())), () -> {
                    TransactionOutput transactionOutput = new TransactionOutput(withdrawalContext.receiver, Value.builder().coin(withdrawalContext.withdrawal.getCoin()).build());
                    txn.getBody().getOutputs().add(transactionOutput);
                });
            }
        });
        return txBuilder;
    }

    private TxBuilder buildPoolRegistration(TxBuilder txBuilder, String fromAddress) {
        if (this.poolRegistrationContexts == null || this.poolRegistrationContexts.isEmpty()) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.poolRegistrationContexts == null || this.poolRegistrationContexts.isEmpty()) {
                return;
            }
            ArrayList certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList();
                txn.getBody().setCerts(certificates);
            }
            List poolRegistrations = this.poolRegistrationContexts.stream().filter(poolRegistrationContext -> !poolRegistrationContext.isUpdate()).map(PoolRegistrationContext::getPoolRegistration).collect(Collectors.toList());
            List poolUpdates = this.poolRegistrationContexts.stream().filter(PoolRegistrationContext::isUpdate).map(PoolRegistrationContext::getPoolRegistration).collect(Collectors.toList());
            if (poolRegistrations.size() > 0) {
                certificates.addAll(poolRegistrations);
            }
            if (poolUpdates.size() > 0) {
                certificates.addAll(poolUpdates);
            }
            String poolDeposit = context.getProtocolParams().getPoolDeposit();
            BigInteger poolRegDeposit = new BigInteger(poolDeposit);
            BigInteger totalPoolRegistrationDeposit = poolRegDeposit.multiply(BigInteger.valueOf(poolRegistrations.size()));
            log.debug("Total pool registration deposit: " + totalPoolRegistrationDeposit);
            if (poolRegistrations.size() > 0) {
                txn.getBody().getOutputs().stream().filter(to -> to.getAddress().equals(fromAddress) && to.getValue().getCoin().compareTo(totalPoolRegistrationDeposit) >= 0).sorted((o1, o2) -> o2.getValue().getCoin().compareTo(o1.getValue().getCoin())).findFirst().ifPresentOrElse(to -> {
                    to.getValue().setCoin(to.getValue().getCoin().subtract(totalPoolRegistrationDeposit));
                    if (to.getValue().getCoin().equals(BigInteger.ZERO) && to.getValue().getMultiAssets() == null && to.getValue().getMultiAssets().size() == 0) {
                        txn.getBody().getOutputs().remove(to);
                    }
                }, () -> {
                    throw new TxBuildException("Output for from address not found to remove deposit amount: " + fromAddress);
                });
            }
        });
        return txBuilder;
    }

    private TxBuilder buildPoolRetirement(TxBuilder txBuilder) {
        if (this.poolRetirements == null || this.poolRetirements.size() == 0) {
            return txBuilder;
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (this.poolRetirements == null || this.poolRetirements.size() == 0) {
                return;
            }
            ArrayList certificates = txn.getBody().getCerts();
            if (certificates == null) {
                certificates = new ArrayList();
                txn.getBody().setCerts(certificates);
            }
            txn.getBody().getCerts().addAll(this.poolRetirements);
        });
        return txBuilder;
    }

    static class PaymentContext {
        private String address;
        private Amount amount;

        public String getAddress() {
            return this.address;
        }

        public Amount getAmount() {
            return this.amount;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public void setAmount(Amount amount) {
            this.amount = amount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PaymentContext)) {
                return false;
            }
            PaymentContext other = (PaymentContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$address = this.getAddress();
            String other$address = other.getAddress();
            if (this$address == null ? other$address != null : !this$address.equals(other$address)) {
                return false;
            }
            Amount this$amount = this.getAmount();
            Amount other$amount = other.getAmount();
            return !(this$amount == null ? other$amount != null : !this$amount.equals(other$amount));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PaymentContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $address = this.getAddress();
            result = result * 59 + ($address == null ? 43 : $address.hashCode());
            Amount $amount = this.getAmount();
            result = result * 59 + ($amount == null ? 43 : $amount.hashCode());
            return result;
        }

        public String toString() {
            return "StakeTx.PaymentContext(address=" + this.getAddress() + ", amount=" + this.getAmount() + ")";
        }

        public PaymentContext(String address, Amount amount) {
            this.address = address;
            this.amount = amount;
        }
    }

    static class PoolRegistrationContext {
        private PoolRegistration poolRegistration;
        private boolean update;

        public PoolRegistration getPoolRegistration() {
            return this.poolRegistration;
        }

        public boolean isUpdate() {
            return this.update;
        }

        public void setPoolRegistration(PoolRegistration poolRegistration) {
            this.poolRegistration = poolRegistration;
        }

        public void setUpdate(boolean update) {
            this.update = update;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof PoolRegistrationContext)) {
                return false;
            }
            PoolRegistrationContext other = (PoolRegistrationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isUpdate() != other.isUpdate()) {
                return false;
            }
            PoolRegistration this$poolRegistration = this.getPoolRegistration();
            PoolRegistration other$poolRegistration = other.getPoolRegistration();
            return !(this$poolRegistration == null ? other$poolRegistration != null : !this$poolRegistration.equals(other$poolRegistration));
        }

        protected boolean canEqual(Object other) {
            return other instanceof PoolRegistrationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isUpdate() ? 79 : 97);
            PoolRegistration $poolRegistration = this.getPoolRegistration();
            result = result * 59 + ($poolRegistration == null ? 43 : $poolRegistration.hashCode());
            return result;
        }

        public String toString() {
            return "StakeTx.PoolRegistrationContext(poolRegistration=" + this.getPoolRegistration() + ", update=" + this.isUpdate() + ")";
        }

        public PoolRegistrationContext(PoolRegistration poolRegistration, boolean update) {
            this.poolRegistration = poolRegistration;
            this.update = update;
        }
    }

    static class WithdrawalContext {
        private Withdrawal withdrawal;
        private Redeemer redeemer;
        private String receiver;

        public Withdrawal getWithdrawal() {
            return this.withdrawal;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public String getReceiver() {
            return this.receiver;
        }

        public void setWithdrawal(Withdrawal withdrawal) {
            this.withdrawal = withdrawal;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public void setReceiver(String receiver) {
            this.receiver = receiver;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WithdrawalContext)) {
                return false;
            }
            WithdrawalContext other = (WithdrawalContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Withdrawal this$withdrawal = this.getWithdrawal();
            Withdrawal other$withdrawal = other.getWithdrawal();
            if (this$withdrawal == null ? other$withdrawal != null : !this$withdrawal.equals(other$withdrawal)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            if (this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer)) {
                return false;
            }
            String this$receiver = this.getReceiver();
            String other$receiver = other.getReceiver();
            return !(this$receiver == null ? other$receiver != null : !this$receiver.equals(other$receiver));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WithdrawalContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Withdrawal $withdrawal = this.getWithdrawal();
            result = result * 59 + ($withdrawal == null ? 43 : $withdrawal.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            String $receiver = this.getReceiver();
            result = result * 59 + ($receiver == null ? 43 : $receiver.hashCode());
            return result;
        }

        public String toString() {
            return "StakeTx.WithdrawalContext(withdrawal=" + this.getWithdrawal() + ", redeemer=" + this.getRedeemer() + ", receiver=" + this.getReceiver() + ")";
        }

        public WithdrawalContext(Withdrawal withdrawal, Redeemer redeemer, String receiver) {
            this.withdrawal = withdrawal;
            this.redeemer = redeemer;
            this.receiver = receiver;
        }
    }

    static class StakeDelegationContext {
        private StakeDelegation stakeDelegation;
        private Redeemer redeemer;

        public StakeDelegation getStakeDelegation() {
            return this.stakeDelegation;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setStakeDelegation(StakeDelegation stakeDelegation) {
            this.stakeDelegation = stakeDelegation;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StakeDelegationContext)) {
                return false;
            }
            StakeDelegationContext other = (StakeDelegationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StakeDelegation this$stakeDelegation = this.getStakeDelegation();
            StakeDelegation other$stakeDelegation = other.getStakeDelegation();
            if (this$stakeDelegation == null ? other$stakeDelegation != null : !this$stakeDelegation.equals(other$stakeDelegation)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StakeDelegationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StakeDelegation $stakeDelegation = this.getStakeDelegation();
            result = result * 59 + ($stakeDelegation == null ? 43 : $stakeDelegation.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "StakeTx.StakeDelegationContext(stakeDelegation=" + this.getStakeDelegation() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public StakeDelegationContext(StakeDelegation stakeDelegation, Redeemer redeemer) {
            this.stakeDelegation = stakeDelegation;
            this.redeemer = redeemer;
        }
    }

    static class StakeKeyDeregestrationContext {
        private StakeDeregistration stakeDeregistration;
        private Redeemer redeemer;
        private String refundAddress;

        public StakeDeregistration getStakeDeregistration() {
            return this.stakeDeregistration;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public String getRefundAddress() {
            return this.refundAddress;
        }

        public void setStakeDeregistration(StakeDeregistration stakeDeregistration) {
            this.stakeDeregistration = stakeDeregistration;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public void setRefundAddress(String refundAddress) {
            this.refundAddress = refundAddress;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof StakeKeyDeregestrationContext)) {
                return false;
            }
            StakeKeyDeregestrationContext other = (StakeKeyDeregestrationContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            StakeDeregistration this$stakeDeregistration = this.getStakeDeregistration();
            StakeDeregistration other$stakeDeregistration = other.getStakeDeregistration();
            if (this$stakeDeregistration == null ? other$stakeDeregistration != null : !this$stakeDeregistration.equals(other$stakeDeregistration)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            if (this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer)) {
                return false;
            }
            String this$refundAddress = this.getRefundAddress();
            String other$refundAddress = other.getRefundAddress();
            return !(this$refundAddress == null ? other$refundAddress != null : !this$refundAddress.equals(other$refundAddress));
        }

        protected boolean canEqual(Object other) {
            return other instanceof StakeKeyDeregestrationContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            StakeDeregistration $stakeDeregistration = this.getStakeDeregistration();
            result = result * 59 + ($stakeDeregistration == null ? 43 : $stakeDeregistration.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            String $refundAddress = this.getRefundAddress();
            result = result * 59 + ($refundAddress == null ? 43 : $refundAddress.hashCode());
            return result;
        }

        public String toString() {
            return "StakeTx.StakeKeyDeregestrationContext(stakeDeregistration=" + this.getStakeDeregistration() + ", redeemer=" + this.getRedeemer() + ", refundAddress=" + this.getRefundAddress() + ")";
        }

        public StakeKeyDeregestrationContext(StakeDeregistration stakeDeregistration, Redeemer redeemer, String refundAddress) {
            this.stakeDeregistration = stakeDeregistration;
            this.redeemer = redeemer;
            this.refundAddress = refundAddress;
        }
    }
}

