/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.account.Account;
import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.DepositRefundContext;
import com.bloxbean.cardano.client.quicktx.GovTx;
import com.bloxbean.cardano.client.quicktx.StakeTx;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.cert.PoolRegistration;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.Vote;
import com.bloxbean.cardano.client.transaction.spec.governance.Voter;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.List;
import java.util.Set;
import lombok.NonNull;

public class Tx
extends AbstractTx<Tx> {
    private StakeTx stakeTx = new StakeTx();
    private GovTx govTx = new GovTx();
    private String sender;
    protected boolean senderAdded = false;

    public Tx mintAssets(@NonNull NativeScript script, Asset asset) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        return this.mintAssets(script, List.of(asset), null);
    }

    public Tx mintAssets(@NonNull NativeScript script, Asset asset, String receiver) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        return this.mintAssets(script, List.of(asset), receiver);
    }

    public Tx mintAssets(@NonNull NativeScript script, List<Asset> assets) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        return this.mintAssets(script, assets, null);
    }

    public Tx mintAssets(@NonNull NativeScript script, List<Asset> assets, String receiver) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        try {
            String policyId = script.getPolicyId();
            if (receiver != null) {
                assets.forEach(asset -> this.payToAddress(receiver, List.of(new Amount(AssetUtil.getUnit((String)policyId, (Asset)asset), asset.getValue()))));
            }
            this.addToMultiAssetList((Script)script, assets);
        }
        catch (Exception e) {
            throw new TxBuildException(e);
        }
        return this;
    }

    public Tx from(String sender) {
        this.verifySenderNotExists();
        this.sender = sender;
        this.senderAdded = true;
        return this;
    }

    public Tx collectFrom(List<Utxo> utxos) {
        this.inputUtxos = utxos;
        return this;
    }

    public Tx collectFrom(Set<Utxo> utxos) {
        this.inputUtxos = List.copyOf(utxos);
        return this;
    }

    public Tx registerStakeAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.registerStakeAddress(new Address(address));
        return this;
    }

    public Tx registerStakeAddress(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.registerStakeAddress(address);
        return this;
    }

    public Tx deregisterStakeAddress(@NonNull String address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(new Address(address), null, null);
        return this;
    }

    public Tx deregisterStakeAddress(@NonNull Address address) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(address, null, null);
        return this;
    }

    public Tx deregisterStakeAddress(@NonNull String address, @NonNull String refundAddr) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (refundAddr == null) {
            throw new NullPointerException("refundAddr is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(new Address(address), null, refundAddr);
        return this;
    }

    public Tx deregisterStakeAddress(@NonNull Address address, @NonNull String refundAddr) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (refundAddr == null) {
            throw new NullPointerException("refundAddr is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(address, null, refundAddr);
        return this;
    }

    public Tx delegateTo(@NonNull String address, @NonNull String poolId) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        this.stakeTx.delegateTo(new Address(address), poolId, null);
        return this;
    }

    public Tx delegateTo(@NonNull Address address, @NonNull String poolId) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        this.stakeTx.delegateTo(address, poolId, null);
        return this;
    }

    public Tx withdraw(@NonNull String rewardAddress, @NonNull BigInteger amount) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(new Address(rewardAddress), amount, null, null);
        return this;
    }

    public Tx withdraw(@NonNull Address rewardAddress, @NonNull BigInteger amount) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(rewardAddress, amount, null, null);
        return this;
    }

    public Tx withdraw(@NonNull String rewardAddress, @NonNull BigInteger amount, String receiver) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(new Address(rewardAddress), amount, null, receiver);
        return this;
    }

    public Tx withdraw(@NonNull Address rewardAddress, @NonNull BigInteger amount, String receiver) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(rewardAddress, amount, null, receiver);
        return this;
    }

    public Tx registerPool(@NonNull PoolRegistration poolRegistration) {
        if (poolRegistration == null) {
            throw new NullPointerException("poolRegistration is marked non-null but is null");
        }
        this.stakeTx.registerPool(poolRegistration);
        return this;
    }

    public Tx updatePool(@NonNull PoolRegistration poolRegistration) {
        if (poolRegistration == null) {
            throw new NullPointerException("poolRegistration is marked non-null but is null");
        }
        this.stakeTx.updatePool(poolRegistration);
        return this;
    }

    public Tx retirePool(@NonNull String poolId, @NonNull int epoch) {
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        this.stakeTx.retirePool(poolId, epoch);
        return this;
    }

    public Tx registerDRep(@NonNull Account account, Anchor anchor) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.govTx.registerDRep(account.drepCredential(), anchor, null);
        return this;
    }

    public Tx registerDRep(@NonNull Account account) {
        if (account == null) {
            throw new NullPointerException("account is marked non-null but is null");
        }
        this.govTx.registerDRep(account.drepCredential(), null, null);
        return this;
    }

    public Tx registerDRep(@NonNull Credential drepCredential, Anchor anchor) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.registerDRep(drepCredential, anchor, null);
        return this;
    }

    public Tx registerDRep(@NonNull Credential drepCredential) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.registerDRep(drepCredential, null, null);
        return this;
    }

    public Tx unregisterDRep(@NonNull Credential drepCredential, String refundAddress, BigInteger refundAmount) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.unregisterDRep(drepCredential, refundAddress, refundAmount, null);
        return this;
    }

    public Tx unregisterDRep(@NonNull Credential drepCredential) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.unregisterDRep(drepCredential, null, null, null);
        return this;
    }

    public Tx unregisterDRep(@NonNull Credential drepCredential, @NonNull String refundAddress) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        if (refundAddress == null) {
            throw new NullPointerException("refundAddress is marked non-null but is null");
        }
        this.govTx.unregisterDRep(drepCredential, refundAddress, null, null);
        return this;
    }

    public Tx updateDRep(@NonNull Credential drepCredential, Anchor anchor) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.updateDRep(drepCredential, anchor, null);
        return this;
    }

    public Tx updateDRep(@NonNull Credential drepCredential) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.updateDRep(drepCredential, null, null);
        return this;
    }

    public Tx createProposal(@NonNull GovAction govAction, @NonNull String rewardAccount, Anchor anchor) {
        if (govAction == null) {
            throw new NullPointerException("govAction is marked non-null but is null");
        }
        if (rewardAccount == null) {
            throw new NullPointerException("rewardAccount is marked non-null but is null");
        }
        this.govTx.createProposal(govAction, rewardAccount, anchor, null);
        return this;
    }

    public Tx createVote(@NonNull Voter voter, @NonNull GovActionId govActionId, @NonNull Vote vote, Anchor anchor) {
        if (voter == null) {
            throw new NullPointerException("voter is marked non-null but is null");
        }
        if (govActionId == null) {
            throw new NullPointerException("govActionId is marked non-null but is null");
        }
        if (vote == null) {
            throw new NullPointerException("vote is marked non-null but is null");
        }
        this.govTx.createVote(voter, govActionId, vote, anchor, null);
        return this;
    }

    public Tx createVote(@NonNull Voter voter, @NonNull GovActionId govActionId, @NonNull Vote vote) {
        if (voter == null) {
            throw new NullPointerException("voter is marked non-null but is null");
        }
        if (govActionId == null) {
            throw new NullPointerException("govActionId is marked non-null but is null");
        }
        if (vote == null) {
            throw new NullPointerException("vote is marked non-null but is null");
        }
        this.govTx.createVote(voter, govActionId, vote, null, null);
        return this;
    }

    public Tx delegateVotingPowerTo(@NonNull String address, @NonNull DRep drep) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (drep == null) {
            throw new NullPointerException("drep is marked non-null but is null");
        }
        this.govTx.delegateVotingPowerTo(new Address(address), drep, null);
        return this;
    }

    public Tx delegateVotingPowerTo(@NonNull Address address, @NonNull DRep drep) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (drep == null) {
            throw new NullPointerException("drep is marked non-null but is null");
        }
        this.govTx.delegateVotingPowerTo(address, drep, null);
        return this;
    }

    String sender() {
        if (this.sender != null) {
            return this.sender;
        }
        return null;
    }

    @Override
    protected String getChangeAddress() {
        if (this.changeAddress != null) {
            return this.changeAddress;
        }
        if (this.sender != null) {
            return this.sender;
        }
        throw new TxBuildException("No change address. Please define at least one of sender address or sender account or change address");
    }

    @Override
    protected String getFromAddress() {
        if (this.sender != null) {
            return this.sender;
        }
        throw new TxBuildException("No sender address or sender account defined");
    }

    @Override
    protected void postBalanceTx(Transaction transaction) {
    }

    @Override
    protected void verifyData() {
    }

    @Override
    protected String getFeePayer() {
        if (this.sender != null) {
            return this.sender;
        }
        return null;
    }

    @Override
    TxBuilder complete() {
        Tuple<List<DepositRefundContext>, TxBuilder> stakeBuildTuple = this.stakeTx.build(this.getFromAddress(), this.getChangeAddress());
        this.addDepositRefundContext((List)stakeBuildTuple._1);
        Tuple<List<DepositRefundContext>, TxBuilder> govBuildTuple = this.govTx.build(this.getFromAddress(), this.getChangeAddress());
        this.addDepositRefundContext((List)govBuildTuple._1);
        TxBuilder txBuilder = super.complete();
        txBuilder = txBuilder.andThen((TxBuilder)stakeBuildTuple._2).andThen((TxBuilder)govBuildTuple._2);
        return txBuilder;
    }

    private void verifySenderNotExists() {
        if (this.senderAdded) {
            throw new TxBuildException("Sender already added. Cannot add additional sender.");
        }
    }
}

