/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx.verifiers;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.quicktx.Verifier;
import com.bloxbean.cardano.client.quicktx.VerifierException;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;

public class OutputAmountVerifier
implements Verifier {
    private final String address;
    private final Amount amount;
    private final String customMsg;

    public OutputAmountVerifier(String address, Amount amount, String customMsg) {
        this.address = address;
        this.amount = amount;
        this.customMsg = customMsg;
    }

    @Override
    public void verify(Transaction txn) throws VerifierException {
        if ("lovelace".equals(this.amount.getUnit())) {
            BigInteger lovelaceAmt = txn.getBody().getOutputs().stream().filter(o -> o.getAddress().equals(this.address)).map(o -> o.getValue().getCoin()).reduce(BigInteger.ZERO, (amount1, amount2) -> amount1.add((BigInteger)amount2));
            if (lovelaceAmt.compareTo(this.amount.getQuantity()) != 0) {
                String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.amount, lovelaceAmt);
                throw new VerifierException(expectedMsg);
            }
        } else {
            BigInteger assetAmount = txn.getBody().getOutputs().stream().filter(o -> o.getAddress().equals(this.address) && o.getValue().getMultiAssets() != null).flatMap(transactionOutput -> transactionOutput.getValue().getMultiAssets().stream()).flatMap(multiAsset -> multiAsset.getAssets().stream().map(asset -> new Tuple((Object)multiAsset.getPolicyId(), asset))).filter(assetTuple -> {
                String unit = AssetUtil.getUnit((String)((String)assetTuple._1), (Asset)((Asset)assetTuple._2));
                return unit != null && unit.equals(this.amount.getUnit());
            }).map(assetTuple -> ((Asset)assetTuple._2).getValue()).reduce(BigInteger.ZERO, (amount1, amount2) -> amount1.add((BigInteger)amount2));
            String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.amount, assetAmount);
            if (assetAmount.compareTo(this.amount.getQuantity()) != 0) {
                throw new VerifierException(expectedMsg);
            }
        }
    }

    private String formatExceptionMessage(String customMsg, String address, Amount expectedAmount, BigInteger actualAmount) {
        Object expectedMsg = String.format("Expected amount %s(%s) for address %s, \nbut got %s", expectedAmount.getQuantity(), expectedAmount.getUnit(), address, actualAmount);
        if (customMsg != null) {
            expectedMsg = customMsg + ".\n" + (String)expectedMsg;
        }
        return expectedMsg;
    }
}

