/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.address.Address;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.MintUtil;
import com.bloxbean.cardano.client.function.helper.RedeemerUtil;
import com.bloxbean.cardano.client.plutus.spec.ExUnits;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.PlutusV1Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.plutus.spec.Redeemer;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.quicktx.AbstractTx;
import com.bloxbean.cardano.client.quicktx.DepositRefundContext;
import com.bloxbean.cardano.client.quicktx.GovTx;
import com.bloxbean.cardano.client.quicktx.StakeTx;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionInput;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import com.bloxbean.cardano.client.transaction.spec.governance.Vote;
import com.bloxbean.cardano.client.transaction.spec.governance.Voter;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.util.Tuple;
import com.bloxbean.cardano.hdwallet.Wallet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import lombok.NonNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptTx
extends AbstractTx<ScriptTx> {
    private static final Logger log = LoggerFactory.getLogger(ScriptTx.class);
    protected List<PlutusScript> spendingValidators;
    protected List<PlutusScript> mintingValidators;
    protected List<PlutusScript> certValidators;
    protected List<PlutusScript> rewardValidators;
    protected List<PlutusScript> proposingValidators;
    protected List<PlutusScript> votingValidators;
    protected List<SpendingContext> spendingContexts = new ArrayList<SpendingContext>();
    protected List<MintingContext> mintingContexts = new ArrayList<MintingContext>();
    protected List<TransactionInput> referenceInputs;
    protected String fromAddress;
    private StakeTx stakeTx;
    private GovTx govTx;

    public ScriptTx() {
        this.spendingValidators = new ArrayList<PlutusScript>();
        this.mintingValidators = new ArrayList<PlutusScript>();
        this.certValidators = new ArrayList<PlutusScript>();
        this.rewardValidators = new ArrayList<PlutusScript>();
        this.proposingValidators = new ArrayList<PlutusScript>();
        this.votingValidators = new ArrayList<PlutusScript>();
        this.stakeTx = new StakeTx();
        this.govTx = new GovTx();
    }

    public ScriptTx collectFrom(Utxo utxo, PlutusData redeemerData, PlutusData datum) {
        if (this.inputUtxos == null) {
            this.inputUtxos = new ArrayList();
        }
        this.inputUtxos.add(utxo);
        Redeemer _redeemer = Redeemer.builder().tag(RedeemerTag.Spend).data(redeemerData).index(BigInteger.valueOf(1L)).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(10000L)).build()).build();
        SpendingContext spendingContext = new SpendingContext(utxo, _redeemer, datum);
        this.spendingContexts.add(spendingContext);
        return this;
    }

    public ScriptTx collectFrom(List<Utxo> utxos, PlutusData redeemerData, PlutusData datum) {
        if (utxos == null) {
            return this;
        }
        utxos.forEach(utxo -> this.collectFrom((Utxo)utxo, redeemerData, datum));
        return this;
    }

    public ScriptTx collectFrom(Utxo utxo, PlutusData redeemerData) {
        return this.collectFrom(utxo, redeemerData, null);
    }

    public ScriptTx collectFrom(List<Utxo> utxos, PlutusData redeemerData) {
        if (utxos == null) {
            return this;
        }
        utxos.forEach(utxo -> this.collectFrom((Utxo)utxo, redeemerData, null));
        return this;
    }

    public ScriptTx collectFrom(Utxo utxo) {
        if (this.inputUtxos == null) {
            this.inputUtxos = new ArrayList();
        }
        this.inputUtxos.add(utxo);
        return this;
    }

    public ScriptTx collectFrom(List<Utxo> utxos) {
        if (utxos == null) {
            return this;
        }
        utxos.forEach(utxo -> this.collectFrom((Utxo)utxo));
        return this;
    }

    public ScriptTx readFrom(Utxo ... utxos) {
        for (Utxo utxo : utxos) {
            this.readFrom(utxo.getTxHash(), utxo.getOutputIndex());
        }
        return this;
    }

    public ScriptTx readFrom(TransactionInput ... transactionInputs) {
        for (TransactionInput transactionInput : transactionInputs) {
            this.readFrom(transactionInput.getTransactionId(), transactionInput.getIndex());
        }
        return this;
    }

    public ScriptTx readFrom(String txHash, int outputIndex) {
        TransactionInput transactionInput = new TransactionInput(txHash, outputIndex);
        if (this.referenceInputs == null) {
            this.referenceInputs = new ArrayList<TransactionInput>();
        }
        if (!this.referenceInputs.contains(transactionInput)) {
            this.referenceInputs.add(transactionInput);
        }
        return this;
    }

    public ScriptTx mintAsset(PlutusScript script, Asset asset, PlutusData redeemer) {
        return this.mintAsset(script, List.of(asset), redeemer, null, null);
    }

    public ScriptTx mintAsset(PlutusScript script, List<Asset> assets, PlutusData redeemer) {
        return this.mintAsset(script, assets, redeemer, null, null);
    }

    public ScriptTx mintAsset(PlutusScript script, Asset asset, PlutusData redeemer, String receiver) {
        return this.mintAsset(script, List.of(asset), redeemer, receiver, null);
    }

    public ScriptTx mintAsset(PlutusScript script, List<Asset> assets, PlutusData redeemer, String receiver) {
        return this.mintAsset(script, assets, redeemer, receiver, null);
    }

    public ScriptTx mintAsset(PlutusScript script, List<Asset> assets, PlutusData redeemer, String receiver, PlutusData outputDatum) {
        String policyId;
        Redeemer _redeemer = Redeemer.builder().tag(RedeemerTag.Mint).data(redeemer).exUnits(ExUnits.builder().mem(BigInteger.valueOf(10000L)).steps(BigInteger.valueOf(10000L)).build()).build();
        MintingContext mintingContext = null;
        try {
            policyId = script.getPolicyId();
            mintingContext = new MintingContext(policyId, assets, _redeemer);
        }
        catch (CborSerializationException e) {
            throw new TxBuildException("Error getting policy id from script", (Exception)((Object)e));
        }
        this.mintingContexts.add(mintingContext);
        List<Amount> amounts = assets.stream().map(asset -> Amount.asset((String)policyId, (String)asset.getName(), (BigInteger)asset.getValue())).collect(Collectors.toList());
        if (receiver != null) {
            if (outputDatum != null) {
                this.payToContract(receiver, amounts, outputDatum);
            } else {
                this.payToAddress(receiver, amounts);
            }
        }
        this.addToMultiAssetList((Script)script, assets);
        this.attachMintValidator(script);
        return this;
    }

    public ScriptTx attachSpendingValidator(PlutusScript plutusScript) {
        this.spendingValidators.add(plutusScript);
        return this;
    }

    private ScriptTx attachMintValidator(PlutusScript plutusScript) {
        this.mintingValidators.add(plutusScript);
        return this;
    }

    public ScriptTx attachCertificateValidator(PlutusScript plutusScript) {
        this.certValidators.add(plutusScript);
        return this;
    }

    public ScriptTx attachRewardValidator(PlutusScript plutusScript) {
        this.rewardValidators.add(plutusScript);
        return this;
    }

    public ScriptTx attachProposingValidator(PlutusScript plutusScript) {
        this.proposingValidators.add(plutusScript);
        return this;
    }

    public ScriptTx attachVotingValidator(PlutusScript plutusScript) {
        this.votingValidators.add(plutusScript);
        return this;
    }

    public ScriptTx withChangeAddress(String changeAddress, PlutusData plutusData) {
        if (this.changeDatahash != null) {
            throw new TxBuildException("Change data hash already set. Cannot set change data");
        }
        this.changeAddress = changeAddress;
        this.changeData = plutusData;
        return this;
    }

    public ScriptTx deregisterStakeAddress(@NonNull String address, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(new Address(address), redeemer, null);
        return this;
    }

    public ScriptTx deregisterStakeAddress(@NonNull Address address, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(address, redeemer, null);
        return this;
    }

    public ScriptTx deregisterStakeAddress(@NonNull String address, PlutusData redeemer, String refundAddr) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        this.stakeTx.deregisterStakeAddress(new Address(address), redeemer, refundAddr);
        return this;
    }

    public ScriptTx delegateTo(@NonNull String address, @NonNull String poolId, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        this.stakeTx.delegateTo(new Address(address), poolId, redeemer);
        return this;
    }

    public ScriptTx delegateTo(@NonNull Address address, @NonNull String poolId, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (poolId == null) {
            throw new NullPointerException("poolId is marked non-null but is null");
        }
        this.stakeTx.delegateTo(address, poolId, redeemer);
        return this;
    }

    public ScriptTx withdraw(@NonNull String rewardAddress, @NonNull BigInteger amount, PlutusData redeemer) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(new Address(rewardAddress), amount, redeemer, null);
        return this;
    }

    public ScriptTx withdraw(@NonNull Address rewardAddress, @NonNull BigInteger amount, PlutusData redeemer) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(rewardAddress, amount, redeemer, null);
        return this;
    }

    public ScriptTx withdraw(@NonNull String rewardAddress, @NonNull BigInteger amount, PlutusData redeemer, String receiver) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(new Address(rewardAddress), amount, redeemer, receiver);
        return this;
    }

    public ScriptTx withdraw(@NonNull Address rewardAddress, @NonNull BigInteger amount, PlutusData redeemer, String receiver) {
        if (rewardAddress == null) {
            throw new NullPointerException("rewardAddress is marked non-null but is null");
        }
        if (amount == null) {
            throw new NullPointerException("amount is marked non-null but is null");
        }
        this.stakeTx.withdraw(rewardAddress, amount, redeemer, receiver);
        return this;
    }

    public ScriptTx registerDRep(@NonNull Credential drepCredential, Anchor anchor, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.registerDRep(drepCredential, anchor, redeemer);
        return this;
    }

    public ScriptTx registerDRep(@NonNull Credential drepCredential, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.registerDRep(drepCredential, null, redeemer);
        return this;
    }

    public ScriptTx unRegisterDRep(@NonNull Credential drepCredential, String refundAddress, BigInteger refundAmount, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.unregisterDRep(drepCredential, refundAddress, refundAmount, redeemer);
        return this;
    }

    public ScriptTx unRegisterDRep(@NonNull Credential drepCredential, String refundAddress, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.unregisterDRep(drepCredential, refundAddress, null, redeemer);
        return this;
    }

    public ScriptTx updateDRep(@NonNull Credential drepCredential, Anchor anchor, PlutusData redeemer) {
        if (drepCredential == null) {
            throw new NullPointerException("drepCredential is marked non-null but is null");
        }
        this.govTx.updateDRep(drepCredential, anchor, redeemer);
        return this;
    }

    public ScriptTx createProposal(GovAction govAction, @NonNull String returnAddress, Anchor anchor, PlutusData redeemer) {
        if (returnAddress == null) {
            throw new NullPointerException("returnAddress is marked non-null but is null");
        }
        this.govTx.createProposal(govAction, returnAddress, anchor, redeemer);
        return this;
    }

    public ScriptTx createVote(@NonNull Voter voter, @NonNull GovActionId govActionId, @NonNull Vote vote, Anchor anchor, PlutusData redeemer) {
        if (voter == null) {
            throw new NullPointerException("voter is marked non-null but is null");
        }
        if (govActionId == null) {
            throw new NullPointerException("govActionId is marked non-null but is null");
        }
        if (vote == null) {
            throw new NullPointerException("vote is marked non-null but is null");
        }
        this.govTx.createVote(voter, govActionId, vote, anchor, redeemer);
        return this;
    }

    public ScriptTx delegateVotingPowerTo(@NonNull Address address, @NonNull DRep drep, PlutusData redeemer) {
        if (address == null) {
            throw new NullPointerException("address is marked non-null but is null");
        }
        if (drep == null) {
            throw new NullPointerException("drep is marked non-null but is null");
        }
        this.govTx.delegateVotingPowerTo(address, drep, redeemer);
        return this;
    }

    public ScriptTx withChangeAddress(String changeAddress, String datumHash) {
        if (this.changeData != null) {
            throw new TxBuildException("Change data already set. Cannot set change data hash");
        }
        this.changeAddress = changeAddress;
        this.changeDatahash = datumHash;
        return this;
    }

    @Override
    protected String getChangeAddress() {
        if (this.changeAddress != null) {
            return this.changeAddress;
        }
        return null;
    }

    @Override
    protected String getFromAddress() {
        return this.fromAddress;
    }

    @Override
    protected Wallet getFromWallet() {
        return null;
    }

    void from(String address) {
        this.fromAddress = address;
    }

    @Override
    protected void postBalanceTx(Transaction transaction) {
        if (this.spendingContexts != null && !this.spendingContexts.isEmpty()) {
            this.verifyAndAdjustRedeemerIndexes(transaction);
        }
    }

    @Override
    protected void preTxEvaluation(Transaction transaction) {
        if (this.spendingContexts != null && !this.spendingContexts.isEmpty()) {
            this.verifyAndAdjustRedeemerIndexes(transaction);
        }
    }

    private void verifyAndAdjustRedeemerIndexes(Transaction transaction) {
        for (Redeemer redeemer : transaction.getWitnessSet().getRedeemers()) {
            if (redeemer.getTag() != RedeemerTag.Spend) continue;
            Optional<Utxo> scriptUtxo = this.getUtxoForRedeemer(redeemer);
            if (scriptUtxo.isPresent()) {
                int scriptInputIndex = RedeemerUtil.getScriptInputIndex((Utxo)scriptUtxo.get(), (Transaction)transaction);
                if (redeemer.getIndex().intValue() != scriptInputIndex && scriptInputIndex != -1) {
                    redeemer.setIndex(scriptInputIndex);
                }
                log.debug("Sorting done for redeemer : " + redeemer);
                continue;
            }
            log.warn("No utxo found for redeemer. Something went wrong." + redeemer);
        }
    }

    private Optional<Utxo> getUtxoForRedeemer(Redeemer redeemer) {
        return this.spendingContexts.stream().filter(spendingContext -> spendingContext.getRedeemer() == redeemer).findFirst().map(spendingContext -> spendingContext.getScriptUtxo());
    }

    @Override
    protected void verifyData() {
    }

    @Override
    protected String getFeePayer() {
        return null;
    }

    @Override
    TxBuilder complete() {
        Tuple<List<DepositRefundContext>, TxBuilder> stakeBuildTuple = this.stakeTx.build(this.getFromAddress(), this.getChangeAddress());
        this.addDepositRefundContext((List)stakeBuildTuple._1);
        Tuple<List<DepositRefundContext>, TxBuilder> govBuildTuple = this.govTx.build(this.getFromAddress(), this.getChangeAddress());
        this.addDepositRefundContext((List)govBuildTuple._1);
        TxBuilder txBuilder = super.complete();
        txBuilder = txBuilder.andThen(this.prepareScriptCallContext());
        txBuilder = txBuilder.andThen((TxBuilder)stakeBuildTuple._2).andThen((TxBuilder)govBuildTuple._2);
        return txBuilder;
    }

    protected TxBuilder prepareScriptCallContext() {
        TxBuilder txBuilder = (context, txn) -> {};
        txBuilder = this.addReferenceInputs(txBuilder);
        txBuilder = this.txBuilderFromSpendingValidators(txBuilder);
        txBuilder = this.txBuilderFromMintingValidators(txBuilder);
        txBuilder = this.txBuilderFromValidators(txBuilder, this.certValidators);
        txBuilder = this.txBuilderFromValidators(txBuilder, this.rewardValidators);
        txBuilder = this.txBuilderFromValidators(txBuilder, this.proposingValidators);
        txBuilder = this.txBuilderFromValidators(txBuilder, this.votingValidators);
        return txBuilder;
    }

    private TxBuilder addReferenceInputs(TxBuilder txBuilder) {
        if (this.referenceInputs != null) {
            txBuilder = txBuilder.andThen((context, txn) -> {
                List txRefInputs = txn.getBody().getReferenceInputs();
                if (txRefInputs == null) {
                    txn.getBody().setReferenceInputs(this.referenceInputs);
                } else {
                    txRefInputs.addAll(this.referenceInputs);
                }
            });
        }
        return txBuilder;
    }

    private TxBuilder txBuilderFromSpendingValidators(TxBuilder txBuilder) {
        for (PlutusScript plutusScript : this.spendingValidators) {
            txBuilder = txBuilder.andThen((context, transaction) -> {
                if (transaction.getWitnessSet() == null) {
                    transaction.setWitnessSet(new TransactionWitnessSet());
                }
                if (plutusScript instanceof PlutusV1Script) {
                    if (!transaction.getWitnessSet().getPlutusV1Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV1Scripts().add((PlutusV1Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV2Script) {
                    if (!transaction.getWitnessSet().getPlutusV2Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV2Scripts().add((PlutusV2Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV3Script && !transaction.getWitnessSet().getPlutusV3Scripts().contains(plutusScript)) {
                    transaction.getWitnessSet().getPlutusV3Scripts().add((PlutusV3Script)plutusScript);
                }
            });
        }
        for (SpendingContext spendingContext : this.spendingContexts) {
            txBuilder = txBuilder.andThen((context, transaction) -> {
                if (transaction.getWitnessSet() == null) {
                    transaction.setWitnessSet(new TransactionWitnessSet());
                }
                if (spendingContext.datum != null && !transaction.getWitnessSet().getPlutusDataList().contains(spendingContext.datum)) {
                    transaction.getWitnessSet().getPlutusDataList().add(spendingContext.datum);
                }
                if (spendingContext.redeemer != null) {
                    int scriptInputIndex = RedeemerUtil.getScriptInputIndex((Utxo)spendingContext.scriptUtxo, (Transaction)transaction);
                    if (scriptInputIndex == -1) {
                        throw new TxBuildException("Script utxo is not found in transaction inputs : " + spendingContext.scriptUtxo.getTxHash());
                    }
                    spendingContext.getRedeemer().setIndex(scriptInputIndex);
                    transaction.getWitnessSet().getRedeemers().add(spendingContext.redeemer);
                }
            });
        }
        return txBuilder;
    }

    private TxBuilder txBuilderFromMintingValidators(TxBuilder txBuilder) {
        for (PlutusScript plutusScript : this.mintingValidators) {
            txBuilder = txBuilder.andThen((context, transaction) -> {
                if (transaction.getWitnessSet() == null) {
                    transaction.setWitnessSet(new TransactionWitnessSet());
                }
                if (plutusScript instanceof PlutusV1Script) {
                    if (!transaction.getWitnessSet().getPlutusV1Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV1Scripts().add((PlutusV1Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV2Script) {
                    if (!transaction.getWitnessSet().getPlutusV2Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV2Scripts().add((PlutusV2Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV3Script && !transaction.getWitnessSet().getPlutusV3Scripts().contains(plutusScript)) {
                    transaction.getWitnessSet().getPlutusV3Scripts().add((PlutusV3Script)plutusScript);
                }
            });
        }
        txBuilder = txBuilder.andThen((context, txn) -> {
            if (txn.getBody().getMint() != null) {
                List multiAssets = MintUtil.getSortedMultiAssets((List)txn.getBody().getMint());
                txn.getBody().setMint(multiAssets);
            }
        });
        for (MintingContext mintingContext : this.mintingContexts) {
            txBuilder = txBuilder.andThen((context, transaction) -> {
                if (transaction.getWitnessSet() == null) {
                    transaction.setWitnessSet(new TransactionWitnessSet());
                }
                if (mintingContext.redeemer != null) {
                    List multiAssets = transaction.getBody().getMint();
                    int index = IntStream.range(0, multiAssets.size()).filter(i -> mintingContext.getPolicyId().equals(((MultiAsset)multiAssets.get(i)).getPolicyId())).findFirst().orElse(-1);
                    if (index == -1) {
                        throw new TxBuildException("Policy id is not found in transaction mint : " + mintingContext.getPolicyId());
                    }
                    mintingContext.getRedeemer().setIndex(index);
                    transaction.getWitnessSet().getRedeemers().stream().filter(redeemer -> redeemer.getTag() == mintingContext.getRedeemer().getTag() && redeemer.getIndex() == mintingContext.getRedeemer().getIndex()).findFirst().ifPresentOrElse(redeemer -> {}, () -> transaction.getWitnessSet().getRedeemers().add(mintingContext.redeemer));
                }
            });
        }
        return txBuilder;
    }

    private TxBuilder txBuilderFromValidators(TxBuilder txBuilder, List<PlutusScript> validators) {
        if (validators == null) {
            return txBuilder;
        }
        for (PlutusScript plutusScript : validators) {
            txBuilder = txBuilder.andThen((context, transaction) -> {
                if (transaction.getWitnessSet() == null) {
                    transaction.setWitnessSet(new TransactionWitnessSet());
                }
                if (plutusScript instanceof PlutusV1Script) {
                    if (!transaction.getWitnessSet().getPlutusV1Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV1Scripts().add((PlutusV1Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV2Script) {
                    if (!transaction.getWitnessSet().getPlutusV2Scripts().contains(plutusScript)) {
                        transaction.getWitnessSet().getPlutusV2Scripts().add((PlutusV2Script)plutusScript);
                    }
                } else if (plutusScript instanceof PlutusV3Script && !transaction.getWitnessSet().getPlutusV3Scripts().contains(plutusScript)) {
                    transaction.getWitnessSet().getPlutusV3Scripts().add((PlutusV3Script)plutusScript);
                }
            });
        }
        return txBuilder;
    }

    static class MintingContext {
        private String policyId;
        private List<Asset> assets;
        private Redeemer redeemer;

        public String getPolicyId() {
            return this.policyId;
        }

        public List<Asset> getAssets() {
            return this.assets;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public void setPolicyId(String policyId) {
            this.policyId = policyId;
        }

        public void setAssets(List<Asset> assets) {
            this.assets = assets;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MintingContext)) {
                return false;
            }
            MintingContext other = (MintingContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$policyId = this.getPolicyId();
            String other$policyId = other.getPolicyId();
            if (this$policyId == null ? other$policyId != null : !this$policyId.equals(other$policyId)) {
                return false;
            }
            List<Asset> this$assets = this.getAssets();
            List<Asset> other$assets = other.getAssets();
            if (this$assets == null ? other$assets != null : !((Object)this$assets).equals(other$assets)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            return !(this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MintingContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $policyId = this.getPolicyId();
            result = result * 59 + ($policyId == null ? 43 : $policyId.hashCode());
            List<Asset> $assets = this.getAssets();
            result = result * 59 + ($assets == null ? 43 : ((Object)$assets).hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            return result;
        }

        public String toString() {
            return "ScriptTx.MintingContext(policyId=" + this.getPolicyId() + ", assets=" + this.getAssets() + ", redeemer=" + this.getRedeemer() + ")";
        }

        public MintingContext(String policyId, List<Asset> assets, Redeemer redeemer) {
            this.policyId = policyId;
            this.assets = assets;
            this.redeemer = redeemer;
        }
    }

    static class SpendingContext {
        private Utxo scriptUtxo;
        private Redeemer redeemer;
        private PlutusData datum;

        public Utxo getScriptUtxo() {
            return this.scriptUtxo;
        }

        public Redeemer getRedeemer() {
            return this.redeemer;
        }

        public PlutusData getDatum() {
            return this.datum;
        }

        public void setScriptUtxo(Utxo scriptUtxo) {
            this.scriptUtxo = scriptUtxo;
        }

        public void setRedeemer(Redeemer redeemer) {
            this.redeemer = redeemer;
        }

        public void setDatum(PlutusData datum) {
            this.datum = datum;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SpendingContext)) {
                return false;
            }
            SpendingContext other = (SpendingContext)o;
            if (!other.canEqual(this)) {
                return false;
            }
            Utxo this$scriptUtxo = this.getScriptUtxo();
            Utxo other$scriptUtxo = other.getScriptUtxo();
            if (this$scriptUtxo == null ? other$scriptUtxo != null : !this$scriptUtxo.equals(other$scriptUtxo)) {
                return false;
            }
            Redeemer this$redeemer = this.getRedeemer();
            Redeemer other$redeemer = other.getRedeemer();
            if (this$redeemer == null ? other$redeemer != null : !this$redeemer.equals(other$redeemer)) {
                return false;
            }
            PlutusData this$datum = this.getDatum();
            PlutusData other$datum = other.getDatum();
            return !(this$datum == null ? other$datum != null : !this$datum.equals(other$datum));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SpendingContext;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            Utxo $scriptUtxo = this.getScriptUtxo();
            result = result * 59 + ($scriptUtxo == null ? 43 : $scriptUtxo.hashCode());
            Redeemer $redeemer = this.getRedeemer();
            result = result * 59 + ($redeemer == null ? 43 : $redeemer.hashCode());
            PlutusData $datum = this.getDatum();
            result = result * 59 + ($datum == null ? 43 : $datum.hashCode());
            return result;
        }

        public String toString() {
            return "ScriptTx.SpendingContext(scriptUtxo=" + this.getScriptUtxo() + ", redeemer=" + this.getRedeemer() + ", datum=" + this.getDatum() + ")";
        }

        public SpendingContext(Utxo scriptUtxo, Redeemer redeemer, PlutusData datum) {
            this.scriptUtxo = scriptUtxo;
            this.redeemer = redeemer;
            this.datum = datum;
        }
    }
}

