/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx.blueprint.extender;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.plutus.blueprint.model.Data;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.plutus.spec.PlutusScript;
import com.bloxbean.cardano.client.plutus.spec.PlutusV2Script;
import com.bloxbean.cardano.client.plutus.spec.PlutusV3Script;
import com.bloxbean.cardano.client.quicktx.QuickTxBuilder;
import com.bloxbean.cardano.client.quicktx.ScriptTx;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.DeployValidatorExtender;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.common.MintAsset;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;

public interface MintValidatorExtender<T>
extends DeployValidatorExtender {
    default public ScriptTx mintTx(Data redeemer, MintAsset ... mintReceivers) {
        List assets = Arrays.stream(mintReceivers).map(mintReceiver -> new Asset(mintReceiver.getAssetName(), mintReceiver.getQuantity())).collect(Collectors.toList());
        List<Asset> mintAssets = assets.stream().collect(Collectors.groupingBy(Asset::getName, Collectors.mapping(asset -> asset, Collectors.reducing((a, b) -> new Asset(a.getName(), a.getValue().add(b.getValue())))))).values().stream().map(Optional::get).collect(Collectors.toList());
        ScriptTx scriptTx = new ScriptTx().mintAsset(this.getPlutusScript(), mintAssets, (PlutusData)redeemer.toPlutusData());
        for (MintAsset receiver : mintReceivers) {
            String unit = AssetUtil.getUnit((String)this.getPolicyId(), (String)receiver.getAssetName());
            Amount amount = Amount.asset((String)unit, (BigInteger)receiver.getQuantity());
            if (receiver.getReceiverDatum() != null) {
                scriptTx.payToContract(receiver.getReceiver(), amount, receiver.getReceiverDatum());
                continue;
            }
            scriptTx.payToAddress(receiver.getReceiver(), amount);
        }
        if (this.getReferenceTxInput() != null) {
            scriptTx.readFrom((String)this.getReferenceTxInput()._1, (Integer)this.getReferenceTxInput()._2);
        }
        return scriptTx;
    }

    default public ScriptTx mintToAddressTx(Data redeemer, Asset asset, String receiver) {
        return this.mintToAddressTx(redeemer, List.of(asset), receiver);
    }

    default public ScriptTx mintToAddressTx(Data redeemer, List<Asset> assets, String receiver) {
        MintAsset[] mintAssets = (MintAsset[])assets.stream().map(asset -> MintAsset.builder().assetName(asset.getName()).quantity(asset.getValue()).receiver(receiver).build()).toArray(MintAsset[]::new);
        return this.mintTx(redeemer, mintAssets);
    }

    default public ScriptTx mintToContractTx(Data redeemer, Asset asset, String receiverContractAddress, Data outputDatum) {
        return this.mintToContractTx(redeemer, List.of(asset), receiverContractAddress, outputDatum);
    }

    default public ScriptTx mintToContractTx(Data redeemer, Asset asset, String receiverContractAddress, PlutusData outputDatum) {
        return this.mintToContractTx(redeemer, List.of(asset), receiverContractAddress, outputDatum);
    }

    default public ScriptTx mintToContractTx(Data redeemer, List<Asset> assets, String receiverContractAddress, Data outputDatum) {
        return this.mintToContractTx(redeemer, assets, receiverContractAddress, (PlutusData)(outputDatum != null ? outputDatum.toPlutusData() : null));
    }

    default public ScriptTx mintToContractTx(Data redeemer, List<Asset> assets, String receiverContractAddress, PlutusData outputDatum) {
        MintAsset[] mintAssets = (MintAsset[])assets.stream().map(asset -> MintAsset.builder().assetName(asset.getName()).quantity(asset.getValue()).receiver(receiverContractAddress).receiverDatum(outputDatum).build()).toArray(MintAsset[]::new);
        return this.mintTx(redeemer, mintAssets);
    }

    default public QuickTxBuilder.TxContext mint(Data redeemer, MintAsset ... mintReceivers) {
        this.requireSuppliersNullCheck();
        ScriptTx scriptTx = this.mintTx(redeemer, mintReceivers);
        QuickTxBuilder quickTxBuilder = new QuickTxBuilder(this.getUtxoSupplier(), this.getProtocolParamsSupplier(), this.getTransactionProcessor());
        QuickTxBuilder.TxContext txContext = quickTxBuilder.compose(scriptTx);
        if (this.getTransactionEvaluator() != null) {
            txContext.withTxEvaluator(this.getTransactionEvaluator());
        }
        if (this.getReferenceTxInput() != null) {
            PlutusScript plutusScript = this.getPlutusScript();
            txContext.withReferenceScripts(plutusScript);
            txContext.preBalanceTx((context, txn) -> {
                if (plutusScript instanceof PlutusV2Script) {
                    txn.getWitnessSet().getPlutusV2Scripts().remove(plutusScript);
                } else if (this.getPlutusScript() instanceof PlutusV3Script) {
                    txn.getWitnessSet().getPlutusV3Scripts().remove(plutusScript);
                }
            });
        }
        return txContext;
    }

    default public QuickTxBuilder.TxContext mintToAddress(Data redeemer, Asset asset, String receiver) {
        return this.mintToAddress(redeemer, List.of(asset), receiver);
    }

    default public QuickTxBuilder.TxContext mintToAddress(Data redeemer, List<Asset> assets, String receiver) {
        MintAsset[] mintAssets = (MintAsset[])assets.stream().map(asset -> MintAsset.builder().assetName(asset.getName()).quantity(asset.getValue()).receiver(receiver).build()).toArray(MintAsset[]::new);
        return this.mint(redeemer, mintAssets);
    }

    default public QuickTxBuilder.TxContext mintToContract(Data redeemer, Asset asset, String receiverScriptAddress, Data outputDatum) {
        return this.mintToContract(redeemer, List.of(asset), receiverScriptAddress, (PlutusData)(outputDatum != null ? outputDatum.toPlutusData() : null));
    }

    default public QuickTxBuilder.TxContext mintToContract(Data redeemer, Asset asset, String receiverScriptAddress, PlutusData outputDatum) {
        return this.mintToContract(redeemer, List.of(asset), receiverScriptAddress, outputDatum);
    }

    default public QuickTxBuilder.TxContext mintToContract(Data redeemer, List<Asset> assets, String receiverScriptAddress, Data outputDatum) {
        return this.mintToContract(redeemer, assets, receiverScriptAddress, (PlutusData)(outputDatum != null ? outputDatum.toPlutusData() : null));
    }

    default public QuickTxBuilder.TxContext mintToContract(Data redeemer, List<Asset> assets, String receiverScriptAddress, PlutusData outputDatum) {
        MintAsset[] mintAssets = (MintAsset[])assets.stream().map(asset -> MintAsset.builder().assetName(asset.getName()).quantity(asset.getValue()).receiver(receiverScriptAddress).receiverDatum(outputDatum).build()).toArray(MintAsset[]::new);
        return this.mint(redeemer, mintAssets);
    }

    default public String getPolicyId() {
        try {
            return this.getPlutusScript().getPolicyId();
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException(e.getMessage(), (Exception)((Object)e));
        }
    }
}

