/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.function.TxBuilder;
import com.bloxbean.cardano.client.function.TxOutputBuilder;
import com.bloxbean.cardano.client.function.exception.TxBuildException;
import com.bloxbean.cardano.client.function.helper.AuxDataProviders;
import com.bloxbean.cardano.client.function.helper.InputBuilders;
import com.bloxbean.cardano.client.function.helper.MintCreators;
import com.bloxbean.cardano.client.function.helper.OutputBuilders;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.quicktx.DepositRefundContext;
import com.bloxbean.cardano.client.quicktx.DepositRefundOutputBuilder;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.MultiAsset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionOutput;
import com.bloxbean.cardano.client.transaction.spec.Value;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import com.bloxbean.cardano.hdwallet.Wallet;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public abstract class AbstractTx<T> {
    public static final String DUMMY_TREASURY_ADDRESS = "_TREASURY_ADDRESS_";
    protected List<TransactionOutput> outputs;
    protected List<Tuple<Script, MultiAsset>> multiAssets;
    protected Metadata txMetadata;
    protected String changeAddress;
    protected List<Utxo> inputUtxos;
    protected PlutusData changeData;
    protected String changeDatahash;
    protected List<DepositRefundContext> depositRefundContexts;
    protected DonationContext donationContext;

    public T payToAddress(String address, Amount amount) {
        return this.payToAddress(address, List.of(amount), null, null, null, null);
    }

    public T payToAddress(String address, List<Amount> amounts) {
        return this.payToAddress(address, amounts, null, null, null, null);
    }

    public T payToAddress(String address, List<Amount> amounts, Script script) {
        return this.payToAddress(address, amounts, null, null, script, null);
    }

    public T payToAddress(String address, Amount amount, Script script) {
        return this.payToAddress(address, List.of(amount), null, null, script, null);
    }

    public T payToAddress(String address, List<Amount> amounts, byte[] scriptRefBytes) {
        return this.payToAddress(address, amounts, null, null, null, scriptRefBytes);
    }

    public T payToContract(String address, Amount amount, PlutusData datum) {
        return this.payToAddress(address, List.of(amount), null, datum, null, null);
    }

    public T payToContract(String address, List<Amount> amounts, PlutusData datum) {
        return this.payToAddress(address, amounts, null, datum, null, null);
    }

    public T payToContract(String address, Amount amount, String datumHash) {
        return this.payToAddress(address, List.of(amount), HexUtil.decodeHexString((String)datumHash), null, null, null);
    }

    public T payToContract(String address, List<Amount> amounts, String datumHash) {
        return this.payToAddress(address, amounts, HexUtil.decodeHexString((String)datumHash), null, null, null);
    }

    public T payToContract(String address, List<Amount> amounts, PlutusData datum, Script refScript) {
        return this.payToAddress(address, amounts, null, datum, refScript, null);
    }

    public T payToContract(String address, Amount amount, PlutusData datum, Script refScript) {
        return this.payToAddress(address, List.of(amount), null, datum, refScript, null);
    }

    public T payToContract(String address, List<Amount> amounts, PlutusData datum, byte[] scriptRefBytes) {
        return this.payToAddress(address, amounts, null, datum, null, scriptRefBytes);
    }

    protected T payToAddress(String address, List<Amount> amounts, byte[] datumHash, PlutusData datum, Script scriptRef, byte[] scriptRefBytes) {
        if (scriptRef != null && scriptRefBytes != null && scriptRefBytes.length > 0) {
            throw new TxBuildException("Both scriptRef and scriptRefBytes cannot be set. Only one of them can be set");
        }
        if (datumHash != null && datumHash.length > 0 && datum != null) {
            throw new TxBuildException("Both datumHash and datum cannot be set. Only one of them can be set");
        }
        TransactionOutput transactionOutput = TransactionOutput.builder().address(address).value(Value.builder().coin(BigInteger.ZERO).build()).build();
        for (Amount amount : amounts) {
            String unit = amount.getUnit();
            if (unit.equals("lovelace")) {
                transactionOutput.getValue().setCoin(amount.getQuantity());
                continue;
            }
            Tuple policyAssetName = AssetUtil.getPolicyIdAndAssetName((String)unit);
            Asset asset = new Asset((String)policyAssetName._2, amount.getQuantity());
            MultiAsset multiAsset = new MultiAsset((String)policyAssetName._1, List.of(asset));
            Value newValue = transactionOutput.getValue().add(new Value(BigInteger.ZERO, List.of(multiAsset)));
            transactionOutput.setValue(newValue);
        }
        if (datum != null) {
            transactionOutput.setInlineDatum(datum);
        } else if (datumHash != null) {
            transactionOutput.setDatumHash(datumHash);
        }
        if (scriptRef != null) {
            transactionOutput.setScriptRef(scriptRef);
        } else if (scriptRefBytes != null) {
            transactionOutput.setScriptRef(scriptRefBytes);
        }
        if (this.outputs == null) {
            this.outputs = new ArrayList<TransactionOutput>();
        }
        this.outputs.add(transactionOutput);
        return (T)this;
    }

    public T donateToTreasury(@NonNull BigInteger currentTreasuryValue, @NonNull BigInteger donationAmount) {
        if (currentTreasuryValue == null) {
            throw new NullPointerException("currentTreasuryValue is marked non-null but is null");
        }
        if (donationAmount == null) {
            throw new NullPointerException("donationAmount is marked non-null but is null");
        }
        if (this.donationContext != null) {
            throw new TxBuildException("Can't donate to treasury multiple times in a single transaction");
        }
        this.donationContext = new DonationContext(currentTreasuryValue, donationAmount);
        return (T)this;
    }

    public T withChangeAddress(String changeAddress) {
        this.changeAddress = changeAddress;
        return (T)this;
    }

    public T attachMetadata(Metadata metadata) {
        this.txMetadata = this.txMetadata == null ? metadata : this.txMetadata.merge(metadata);
        return (T)this;
    }

    boolean hasMultiAssetMinting() {
        return this.multiAssets != null && !this.multiAssets.isEmpty();
    }

    TxBuilder complete() {
        TxOutputBuilder txOutputBuilder = null;
        if (this.depositRefundContexts != null && this.depositRefundContexts.size() > 0) {
            for (DepositRefundContext depositPaymentContext : this.depositRefundContexts) {
                if (txOutputBuilder == null) {
                    txOutputBuilder = DepositRefundOutputBuilder.createFromDepositRefundContext(depositPaymentContext);
                    continue;
                }
                txOutputBuilder = txOutputBuilder.and(DepositRefundOutputBuilder.createFromDepositRefundContext(depositPaymentContext));
            }
        }
        if (this.donationContext != null) {
            TxOutputBuilder txOutputBuilder2 = txOutputBuilder = txOutputBuilder == null ? this.buildDummyDonationTxOutBuilder() : txOutputBuilder.and(this.buildDummyDonationTxOutBuilder());
        }
        if (this.outputs != null) {
            for (TransactionOutput output : this.outputs) {
                if (txOutputBuilder == null) {
                    txOutputBuilder = OutputBuilders.createFromOutput((TransactionOutput)output);
                    continue;
                }
                txOutputBuilder = txOutputBuilder.and(OutputBuilders.createFromOutput((TransactionOutput)output));
            }
        }
        if (this.multiAssets != null && !this.multiAssets.isEmpty()) {
            if (txOutputBuilder == null) {
                txOutputBuilder = (context, txn) -> {};
            }
            txOutputBuilder = txOutputBuilder.and((context, txn) -> {
                if (context.getMintMultiAssets() == null || context.getMintMultiAssets().isEmpty()) {
                    this.multiAssets.forEach(multiAssetTuple -> context.addMintMultiAsset((MultiAsset)multiAssetTuple._2));
                }
            });
        }
        TxBuilder txBuilder = txOutputBuilder == null ? (context, txn) -> {} : (this.inputUtxos != null && !this.inputUtxos.isEmpty() ? this.buildInputBuildersFromUtxos(txOutputBuilder) : this.buildInputBuilders(txOutputBuilder));
        if (this.multiAssets != null && !this.multiAssets.isEmpty()) {
            for (Tuple<Script, MultiAsset> multiAssetTuple : this.multiAssets) {
                txBuilder = txBuilder.andThen(MintCreators.mintCreator((Script)((Script)multiAssetTuple._1), (MultiAsset)((MultiAsset)multiAssetTuple._2)));
            }
        }
        if (this.txMetadata != null) {
            txBuilder = txBuilder.andThen(AuxDataProviders.metadataProvider((Metadata)this.txMetadata));
        }
        if (this.donationContext != null) {
            txBuilder = txBuilder.andThen(this.buildDonatationTxBuilder());
        }
        return txBuilder;
    }

    private TxBuilder buildInputBuilders(TxOutputBuilder txOutputBuilder) {
        String _changeAddress = this.getChangeAddress();
        String _fromAddress = this.getFromAddress();
        Wallet _fromWallet = this.getFromWallet();
        TxBuilder txBuilder = null;
        txBuilder = _fromWallet != null ? txOutputBuilder.buildInputs(InputBuilders.createFromSender((Wallet)_fromWallet, (String)_changeAddress)) : txOutputBuilder.buildInputs(InputBuilders.createFromSender((String)_fromAddress, (String)_changeAddress));
        return txBuilder;
    }

    private TxOutputBuilder buildDummyDonationTxOutBuilder() {
        if (this.donationContext == null) {
            return null;
        }
        TxOutputBuilder dummyTxOutputBuilder = (context, outputs) -> {
            TransactionOutput dummyDonationOutput = new TransactionOutput(DUMMY_TREASURY_ADDRESS, Value.builder().coin(this.donationContext.donationAmount).build());
            outputs.add(dummyDonationOutput);
        };
        return dummyTxOutputBuilder;
    }

    private TxBuilder buildDonatationTxBuilder() {
        if (this.donationContext == null) {
            return null;
        }
        return (context, txn) -> {
            txn.getBody().getOutputs().removeIf(output -> output.getAddress().equals(DUMMY_TREASURY_ADDRESS));
            txn.getBody().setCurrentTreasuryValue(this.donationContext.currentTreasuryValue);
            txn.getBody().setDonation(this.donationContext.donationAmount);
        };
    }

    private TxBuilder buildInputBuildersFromUtxos(TxOutputBuilder txOutputBuilder) {
        String _changeAddr = this.getChangeAddress();
        TxBuilder txBuilder = this.changeData != null ? txOutputBuilder.buildInputs(InputBuilders.createFromUtxos(this.inputUtxos, (String)_changeAddr, (Object)this.changeData)) : (this.changeDatahash != null ? txOutputBuilder.buildInputs(InputBuilders.createFromUtxos(this.inputUtxos, (String)_changeAddr, (String)this.changeDatahash)) : txOutputBuilder.buildInputs(InputBuilders.createFromUtxos(this.inputUtxos, (String)_changeAddr)));
        return txBuilder;
    }

    protected void addToMultiAssetList(@NonNull Script script, List<Asset> assets) {
        if (script == null) {
            throw new NullPointerException("script is marked non-null but is null");
        }
        String policyId = script.getPolicyId();
        MultiAsset multiAsset = MultiAsset.builder().policyId(policyId).assets(assets).build();
        if (this.multiAssets == null) {
            this.multiAssets = new ArrayList<Tuple<Script, MultiAsset>>();
        }
        this.multiAssets.stream().filter(ma -> {
            try {
                return ((Script)ma._1).getPolicyId().equals(script.getPolicyId());
            }
            catch (CborSerializationException e) {
                throw new CborRuntimeException((Exception)((Object)e));
            }
        }).findFirst().ifPresentOrElse(ma -> {
            this.multiAssets.remove(ma);
            this.multiAssets.add((Tuple<Script, MultiAsset>)new Tuple((Object)script, (Object)((MultiAsset)ma._2).add(multiAsset)));
        }, () -> this.multiAssets.add((Tuple<Script, MultiAsset>)new Tuple((Object)script, (Object)multiAsset)));
    }

    protected void addDepositRefundContext(List<DepositRefundContext> _depositRefundContexts) {
        if (this.depositRefundContexts == null) {
            this.depositRefundContexts = new ArrayList<DepositRefundContext>();
        }
        _depositRefundContexts.forEach(depositRefundContext -> this.depositRefundContexts.add((DepositRefundContext)depositRefundContext));
    }

    protected abstract String getChangeAddress();

    protected abstract String getFromAddress();

    protected abstract Wallet getFromWallet();

    protected void preTxEvaluation(Transaction transaction) {
    }

    protected abstract void postBalanceTx(Transaction var1);

    protected abstract void verifyData();

    protected abstract String getFeePayer();

    static class DonationContext {
        private BigInteger currentTreasuryValue;
        private BigInteger donationAmount;

        public BigInteger getCurrentTreasuryValue() {
            return this.currentTreasuryValue;
        }

        public BigInteger getDonationAmount() {
            return this.donationAmount;
        }

        public DonationContext(BigInteger currentTreasuryValue, BigInteger donationAmount) {
            this.currentTreasuryValue = currentTreasuryValue;
            this.donationAmount = donationAmount;
        }
    }
}

