/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx.blueprint.extender;

import com.bloxbean.cardano.client.api.UtxoSupplier;
import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.function.helper.ScriptUtxoFinders;
import com.bloxbean.cardano.client.plutus.blueprint.model.Data;
import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import com.bloxbean.cardano.client.quicktx.QuickTxBuilder;
import com.bloxbean.cardano.client.quicktx.ScriptTx;
import com.bloxbean.cardano.client.quicktx.Tx;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.DeployValidatorExtender;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.common.ChangeReceiver;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.common.Receiver;
import com.bloxbean.cardano.client.quicktx.blueprint.extender.common.ScriptReceiver;
import java.util.ArrayList;
import java.util.List;
import lombok.NonNull;

public interface LockUnlockValidatorExtender<T>
extends DeployValidatorExtender {
    default public Tx lockTx(String fromAddress, Amount amount, Data datum) {
        return this.lockTx(fromAddress, List.of(amount), datum);
    }

    default public Tx lockTx(String fromAddress, List<Amount> amounts, Data datum) {
        Tx tx = ((Tx)new Tx().payToContract(this.getScriptAddress(), amounts, (PlutusData)datum.toPlutusData())).from(fromAddress);
        return tx;
    }

    default public QuickTxBuilder.TxContext lock(String fromAddress, Amount amount, Data datum) {
        return this.lock(fromAddress, List.of(amount), datum);
    }

    default public QuickTxBuilder.TxContext lock(String fromAddress, List<Amount> amounts, Data datum) {
        this.requireSuppliersNullCheck();
        Tx tx = this.lockTx(fromAddress, amounts, datum);
        QuickTxBuilder quickTxBuilder = new QuickTxBuilder(this.getUtxoSupplier(), this.getProtocolParamsSupplier(), this.getTransactionProcessor());
        QuickTxBuilder.TxContext txContext = quickTxBuilder.compose(tx);
        return txContext;
    }

    default public ScriptTx unlockTx(Data datum, Data redeemer, List<Receiver> receivers, ChangeReceiver changeReceiver) {
        Utxo scriptUtxo = this.getScriptUtxo(datum);
        return this.unlockTx(scriptUtxo, redeemer, receivers, changeReceiver);
    }

    default public ScriptTx unlockTx(@NonNull Utxo scriptUtxo, Data redeemer, List<Receiver> receivers, ChangeReceiver changeReceiver) {
        if (scriptUtxo == null) {
            throw new NullPointerException("scriptUtxo is marked non-null but is null");
        }
        ScriptTx scriptTx = new ScriptTx().collectFrom(scriptUtxo, (PlutusData)redeemer.toPlutusData());
        for (Receiver receiver : receivers) {
            if (receiver instanceof ScriptReceiver) {
                ScriptReceiver scriptReceiver = (ScriptReceiver)receiver;
                scriptTx.payToContract(receiver.getAddress(), receiver.getAmounts(), scriptReceiver.getDatum());
                continue;
            }
            scriptTx.payToAddress(receiver.getAddress(), receiver.getAmounts());
        }
        if (this.getReferenceTxInput() != null) {
            scriptTx.readFrom((String)this.getReferenceTxInput()._1, (Integer)this.getReferenceTxInput()._2);
        } else {
            scriptTx.attachSpendingValidator(this.getPlutusScript());
        }
        if (changeReceiver != null) {
            if (changeReceiver.isScript()) {
                scriptTx.withChangeAddress(changeReceiver.getAddress(), changeReceiver.getDatum());
            } else {
                scriptTx.withChangeAddress(changeReceiver.getAddress());
            }
        }
        return scriptTx;
    }

    default public ScriptTx unlockToAddressTx(Data inputDatum, Data redeemer, String receiver) {
        Utxo scriptUtxo = this.getScriptUtxo(inputDatum);
        return this.unlockToAddressTx(scriptUtxo, redeemer, receiver);
    }

    default public ScriptTx unlockToContractTx(Data inputDatum, Data redeemer, String receiver, Data outputData) {
        return this.unlockToContractTx(inputDatum, redeemer, receiver, (PlutusData)(outputData != null ? outputData.toPlutusData() : null));
    }

    default public ScriptTx unlockToContractTx(Data inputDatum, Data redeemer, String receiver, PlutusData outputDatum) {
        Utxo scriptUtxo = this.getScriptUtxo(inputDatum);
        return this.unlockToContractTx(scriptUtxo, redeemer, receiver, outputDatum);
    }

    default public ScriptTx unlockToAddressTx(Utxo utxo, Data redeemer, String receiver) {
        List<Receiver> receivers = LockUnlockValidatorExtender.getReceiversFromUtxo(utxo, receiver, null);
        return this.unlockTx(utxo, redeemer, receivers, null);
    }

    default public ScriptTx unlockToContractTx(Utxo utxo, Data redeemer, String receiver, PlutusData outputDatum) {
        List<Receiver> receivers = LockUnlockValidatorExtender.getReceiversFromUtxo(utxo, receiver, outputDatum);
        return this.unlockTx(utxo, redeemer, receivers, null);
    }

    default public QuickTxBuilder.TxContext unlock(Data datum, Data redeemer, List<Receiver> receivers, ChangeReceiver changeReceiver) {
        try {
            return ScriptUtxoFinders.findFirstByInlineDatum((UtxoSupplier)this.getUtxoSupplier(), (String)this.getScriptAddress(), (Object)datum.toPlutusData()).map(scriptUtxo -> this.unlock((Utxo)scriptUtxo, redeemer, receivers, changeReceiver)).orElseThrow(() -> new IllegalStateException("Script Utxo not found"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e.getMessage());
        }
    }

    default public QuickTxBuilder.TxContext unlock(Utxo utxo, Data redeemer, List<Receiver> receivers, ChangeReceiver changeReceiver) {
        this.requireSuppliersNullCheck();
        ScriptTx scriptTx = this.unlockTx(utxo, redeemer, receivers, changeReceiver);
        QuickTxBuilder quickTxBuilder = new QuickTxBuilder(this.getUtxoSupplier(), this.getProtocolParamsSupplier(), this.getTransactionProcessor());
        QuickTxBuilder.TxContext txContext = quickTxBuilder.compose(scriptTx);
        if (this.getTransactionEvaluator() != null) {
            txContext.withTxEvaluator(this.getTransactionEvaluator());
        }
        if (this.getReferenceTxInput() != null) {
            txContext.withReferenceScripts(this.getPlutusScript());
        }
        return txContext;
    }

    default public QuickTxBuilder.TxContext unlockToAddress(Data inputDatum, Data redeemer, String receiver) {
        return this.unlock(inputDatum, redeemer, receiver, (PlutusData)null);
    }

    default public QuickTxBuilder.TxContext unlockToContract(Data inputDatum, Data redeemer, String receiverContractAddress, Data outputDatum) {
        return this.unlock(inputDatum, redeemer, receiverContractAddress, (PlutusData)(outputDatum != null ? outputDatum.toPlutusData() : null));
    }

    default public QuickTxBuilder.TxContext unlockToContract(Data inputDatum, Data redeemer, String receiverContractAddress, PlutusData outputDatum) {
        return this.unlock(inputDatum, redeemer, receiverContractAddress, outputDatum);
    }

    private QuickTxBuilder.TxContext unlock(Data datum, Data redeemer, String receiver, PlutusData receiverDatum) {
        try {
            return ScriptUtxoFinders.findFirstByInlineDatum((UtxoSupplier)this.getUtxoSupplier(), (String)this.getScriptAddress(), (Object)datum.toPlutusData()).map(scriptUtxo -> this.unlock((Utxo)scriptUtxo, redeemer, receiver, receiverDatum)).orElseThrow(() -> new IllegalStateException("Script Utxo not found"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    default public QuickTxBuilder.TxContext unlockToAddress(Utxo utxo, Data redeemer, String receiver) {
        return this.unlock(utxo, redeemer, receiver, (PlutusData)null);
    }

    default public QuickTxBuilder.TxContext unlockToContract(Utxo utxo, Data redeemer, String receiver, Data outputDatum) {
        return this.unlock(utxo, redeemer, receiver, (PlutusData)(outputDatum != null ? outputDatum.toPlutusData() : null));
    }

    default public QuickTxBuilder.TxContext unlockToContract(Utxo utxo, Data redeemer, String receiverAddr, PlutusData outputDatum) {
        return this.unlock(utxo, redeemer, receiverAddr, outputDatum);
    }

    private QuickTxBuilder.TxContext unlock(Utxo utxo, Data redeemer, String receiverAddr, PlutusData outputDatum) {
        List<Receiver> receivers = LockUnlockValidatorExtender.getReceiversFromUtxo(utxo, receiverAddr, outputDatum);
        return this.unlock(utxo, redeemer, receivers, new ChangeReceiver(receiverAddr));
    }

    private static List<Receiver> getReceiversFromUtxo(Utxo utxo, String receiverAddr, PlutusData datum) {
        List amounts = utxo.getAmount();
        ArrayList<Receiver> receivers = new ArrayList<Receiver>();
        if (datum != null) {
            amounts.forEach(amount -> receivers.add(new ScriptReceiver(receiverAddr, (Amount)amount, datum)));
        } else {
            amounts.forEach(amount -> receivers.add(new Receiver(receiverAddr, (Amount)amount)));
        }
        return receivers;
    }

    private Utxo getScriptUtxo(Data inputDatum) {
        try {
            return (Utxo)ScriptUtxoFinders.findFirstByInlineDatum((UtxoSupplier)this.getUtxoSupplier(), (String)this.getScriptAddress(), (Object)inputDatum.toPlutusData()).orElseThrow(() -> new IllegalStateException("Script Utxo not found"));
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }
}

