/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx.blueprint.extender.common;

import com.bloxbean.cardano.client.plutus.spec.PlutusData;
import java.math.BigInteger;

public class MintAsset {
    private String assetName;
    private BigInteger quantity;
    private String receiver;
    private PlutusData receiverDatum;

    public MintAsset(String assetName, BigInteger quantity, String receiver) {
        this.assetName = assetName;
        this.quantity = quantity;
        this.receiver = receiver;
    }

    public static MintAssetBuilder builder() {
        return new MintAssetBuilder();
    }

    public String getAssetName() {
        return this.assetName;
    }

    public BigInteger getQuantity() {
        return this.quantity;
    }

    public String getReceiver() {
        return this.receiver;
    }

    public PlutusData getReceiverDatum() {
        return this.receiverDatum;
    }

    public MintAsset(String assetName, BigInteger quantity, String receiver, PlutusData receiverDatum) {
        this.assetName = assetName;
        this.quantity = quantity;
        this.receiver = receiver;
        this.receiverDatum = receiverDatum;
    }

    public MintAsset() {
    }

    public static class MintAssetBuilder {
        private String assetName;
        private BigInteger quantity;
        private String receiver;
        private PlutusData receiverDatum;

        MintAssetBuilder() {
        }

        public MintAssetBuilder assetName(String assetName) {
            this.assetName = assetName;
            return this;
        }

        public MintAssetBuilder quantity(BigInteger quantity) {
            this.quantity = quantity;
            return this;
        }

        public MintAssetBuilder receiver(String receiver) {
            this.receiver = receiver;
            return this;
        }

        public MintAssetBuilder receiverDatum(PlutusData receiverDatum) {
            this.receiverDatum = receiverDatum;
            return this;
        }

        public MintAsset build() {
            return new MintAsset(this.assetName, this.quantity, this.receiver, this.receiverDatum);
        }

        public String toString() {
            return "MintAsset.MintAssetBuilder(assetName=" + this.assetName + ", quantity=" + this.quantity + ", receiver=" + this.receiver + ", receiverDatum=" + this.receiverDatum + ")";
        }
    }
}

