/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.quicktx.verifiers;

import com.bloxbean.cardano.client.api.model.Amount;
import com.bloxbean.cardano.client.api.util.AssetUtil;
import com.bloxbean.cardano.client.quicktx.Verifier;
import com.bloxbean.cardano.client.quicktx.VerifierException;
import com.bloxbean.cardano.client.transaction.spec.Asset;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.Tuple;
import java.math.BigInteger;
import java.util.function.Predicate;

public class OutputAmountVerifier
implements Verifier {
    private final String address;
    private final Amount amount;
    private final Predicate<Amount> predicate;
    private final String unit;
    private final String customMsg;

    public OutputAmountVerifier(String address, Amount amount, String customMsg) {
        this.address = address;
        this.amount = amount;
        this.unit = amount.getUnit();
        this.predicate = null;
        this.customMsg = customMsg;
    }

    public OutputAmountVerifier(String address, String unit, Predicate<Amount> predicate, String customMsg) {
        this.address = address;
        this.amount = null;
        this.unit = unit;
        this.predicate = predicate;
        this.customMsg = customMsg;
    }

    @Override
    public void verify(Transaction txn) throws VerifierException {
        if ("lovelace".equals(this.unit)) {
            BigInteger lovelaceAmt = txn.getBody().getOutputs().stream().filter(o -> o.getAddress().equals(this.address)).map(o -> o.getValue().getCoin()).reduce(BigInteger.ZERO, (amount1, amount2) -> amount1.add((BigInteger)amount2));
            if (this.predicate != null) {
                if (!this.predicate.test(Amount.lovelace((BigInteger)lovelaceAmt))) {
                    String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.unit, lovelaceAmt);
                    throw new VerifierException(expectedMsg);
                }
            } else if (lovelaceAmt.compareTo(this.amount.getQuantity()) != 0) {
                String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.amount, lovelaceAmt);
                throw new VerifierException(expectedMsg);
            }
        } else {
            BigInteger assetAmount = txn.getBody().getOutputs().stream().filter(o -> o.getAddress().equals(this.address) && o.getValue().getMultiAssets() != null).flatMap(transactionOutput -> transactionOutput.getValue().getMultiAssets().stream()).flatMap(multiAsset -> multiAsset.getAssets().stream().map(asset -> new Tuple((Object)multiAsset.getPolicyId(), asset))).filter(assetTuple -> {
                String unit = AssetUtil.getUnit((String)((String)assetTuple._1), (Asset)((Asset)assetTuple._2));
                return unit != null && unit.equals(this.amount.getUnit());
            }).map(assetTuple -> ((Asset)assetTuple._2).getValue()).reduce(BigInteger.ZERO, (amount1, amount2) -> amount1.add((BigInteger)amount2));
            if (this.predicate != null) {
                if (!this.predicate.test(Amount.asset((String)this.amount.getUnit(), (BigInteger)assetAmount))) {
                    String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.unit, assetAmount);
                    throw new VerifierException(expectedMsg);
                }
            } else if (assetAmount.compareTo(this.amount.getQuantity()) != 0) {
                String expectedMsg = this.formatExceptionMessage(this.customMsg, this.address, this.amount, assetAmount);
                throw new VerifierException(expectedMsg);
            }
        }
    }

    private String formatExceptionMessage(String customMsg, String address, Amount expectedAmount, BigInteger actualAmount) {
        Object expectedMsg = String.format("Expected amount %s(%s) for address %s, \nbut got %s", expectedAmount.getQuantity(), expectedAmount.getUnit(), address, actualAmount);
        if (customMsg != null) {
            expectedMsg = customMsg + ".\n" + (String)expectedMsg;
        }
        return expectedMsg;
    }

    private String formatExceptionMessage(String customMsg, String address, String unit, BigInteger actualAmount) {
        Object expectedMsg = String.format("Amount for  address %s and unit %s doesn't match the condition. Actual amount: %s", address, unit, actualAmount);
        if (customMsg != null) {
            expectedMsg = customMsg + ".\n" + (String)expectedMsg;
        }
        return expectedMsg;
    }
}

