/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.supplier.ogmios;

import com.bloxbean.cardano.client.api.TransactionProcessor;
import com.bloxbean.cardano.client.api.exception.ApiException;
import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.api.model.Result;
import com.bloxbean.cardano.client.api.model.Utxo;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.supplier.ogmios.OgmiosBaseService;
import com.bloxbean.cardano.client.supplier.ogmios.OgmiosHTTPApi;
import com.bloxbean.cardano.client.supplier.ogmios.dto.BaseRequestDto;
import com.bloxbean.cardano.client.supplier.ogmios.dto.EvaluateTransactionResponeDto;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class OgmiosTransactionProcessor
extends OgmiosBaseService
implements TransactionProcessor {
    private static final Logger log = LoggerFactory.getLogger(OgmiosTransactionProcessor.class);
    private static final String SUBMIT_TRANSACTION_METHOD = "submitTransaction";
    private static final String EVALUATE_TRANSACTION_METHOD = "evaluateTransaction";
    private final OgmiosHTTPApi ogmiosHTTPApi;
    private ObjectMapper objectMapper = new ObjectMapper();

    public OgmiosTransactionProcessor(String baseUrl) {
        super(baseUrl);
        this.ogmiosHTTPApi = (OgmiosHTTPApi)this.getRetrofit().create(OgmiosHTTPApi.class);
    }

    public Result<List<EvaluationResult>> evaluateTx(byte[] cbor, Set<Utxo> inputUtxos) throws ApiException {
        return this.evaluateTx(cbor);
    }

    public Result<List<EvaluationResult>> evaluateTx(final byte[] cbor) throws ApiException {
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("transaction", new HashMap(){
            {
                this.put("cbor", HexUtil.encodeHexString((byte[])cbor));
            }
        });
        BaseRequestDto request = new BaseRequestDto(EVALUATE_TRANSACTION_METHOD, params);
        return this.evalTx(request);
    }

    public Result<List<EvaluationResult>> evaluateTx(Transaction transaction, Set<Utxo> inputUtxos) throws ApiException {
        try {
            return this.evaluateTx(transaction.serialize(), inputUtxos);
        }
        catch (CborSerializationException e) {
            throw new RuntimeException("Couldn't deserialize Transaction", e);
        }
    }

    public Result<String> submitTransaction(final byte[] cborData) throws ApiException {
        HashMap<String, Map<String, String>> params = new HashMap<String, Map<String, String>>();
        params.put("transaction", new HashMap(){
            {
                this.put("cbor", HexUtil.encodeHexString((byte[])cborData));
            }
        });
        BaseRequestDto request = new BaseRequestDto(SUBMIT_TRANSACTION_METHOD, params);
        Call<BaseRequestDto<Map<String, Map<String, String>>>> call = this.ogmiosHTTPApi.submitTransaction(request);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                String id = (String)((Map)((Map)((BaseRequestDto)response.body()).getResult()).get("transaction")).get("id");
                return Result.success((String)response.toString()).withValue((Object)id).code(response.code());
            }
            return Result.error((String)response.errorBody().string()).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting latest epoch", (Exception)e);
        }
    }

    private Result evalTx(BaseRequestDto request) throws ApiException {
        Call<BaseRequestDto<List<EvaluateTransactionResponeDto>>> call = this.ogmiosHTTPApi.evaluateTransaction(request);
        try {
            Response response = call.execute();
            if (response.isSuccessful()) {
                ArrayList<EvaluationResult> evaluationResultList = new ArrayList<EvaluationResult>();
                for (EvaluateTransactionResponeDto executionUnitDTO : (List)((BaseRequestDto)response.body()).getResult()) {
                    evaluationResultList.add(executionUnitDTO.toEvaluationResult());
                }
                return Result.success((String)((BaseRequestDto)response.body()).toString()).withValue(evaluationResultList).code(response.code());
            }
            String error = null;
            String errorBody = response.errorBody().string();
            try {
                JsonNode jsonNode = this.objectMapper.readTree(errorBody);
                error = jsonNode != null ? jsonNode.get("error").toString() : errorBody;
            }
            catch (Exception e) {
                log.error("Error parsing error response", (Throwable)e);
            }
            return Result.error(error).code(response.code());
        }
        catch (IOException e) {
            throw new ApiException("Error getting latest epoch", (Exception)e);
        }
    }
}

