/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.supplier.ogmios;

import com.bloxbean.cardano.client.api.ProtocolParamsSupplier;
import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.supplier.ogmios.OgmiosBaseService;
import com.bloxbean.cardano.client.supplier.ogmios.OgmiosHTTPApi;
import com.bloxbean.cardano.client.supplier.ogmios.dto.BaseRequestDto;
import com.bloxbean.cardano.client.supplier.ogmios.dto.ProtocolParametersDto;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import retrofit2.Call;
import retrofit2.Response;

public class OgmiosProtocolParamSupplier
extends OgmiosBaseService
implements ProtocolParamsSupplier {
    private static final Logger log = LoggerFactory.getLogger(OgmiosProtocolParamSupplier.class);
    private static final String QUERY_PROTOCOL_PARAMS_METHOD = "queryLedgerState/protocolParameters";
    private final OgmiosHTTPApi ogmiosHTTPApi = (OgmiosHTTPApi)this.getRetrofit().create(OgmiosHTTPApi.class);

    public OgmiosProtocolParamSupplier(String baseUrl) {
        super(baseUrl);
    }

    public ProtocolParams getProtocolParams() {
        BaseRequestDto request = new BaseRequestDto(QUERY_PROTOCOL_PARAMS_METHOD);
        Call<BaseRequestDto<ProtocolParametersDto>> call = this.ogmiosHTTPApi.getProtocolParameters(request);
        try {
            Response response = call.execute();
            if (response.isSuccessful() && ((BaseRequestDto)response.body()).getResult() != null) {
                return ((ProtocolParametersDto)((BaseRequestDto)response.body()).getResult()).toProtocolParams();
            }
            return null;
        }
        catch (IOException e) {
            log.error("Error getting protocol params", (Throwable)e);
            return null;
        }
    }
}

