/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.supplier.ogmios.dto;

import com.bloxbean.cardano.client.api.model.EvaluationResult;
import com.bloxbean.cardano.client.plutus.spec.RedeemerTag;
import com.bloxbean.cardano.client.supplier.ogmios.dto.ExecutionUnitDto;
import com.bloxbean.cardano.client.supplier.ogmios.dto.ValidatorDto;
import java.util.Objects;

public class EvaluateTransactionResponeDto {
    private ValidatorDto validator;
    private ExecutionUnitDto budget;

    public EvaluationResult toEvaluationResult() {
        RedeemerTag redeemerTag;
        Objects.requireNonNull(this.validator, "validator field is null");
        Objects.requireNonNull(this.budget, "budget field is null");
        EvaluationResult evaluationResult = new EvaluationResult();
        switch (this.validator.getPurpose()) {
            case "spend": {
                redeemerTag = RedeemerTag.Spend;
                break;
            }
            case "mint": {
                redeemerTag = RedeemerTag.Mint;
                break;
            }
            case "publish": {
                redeemerTag = RedeemerTag.Cert;
                break;
            }
            case "withdraw": {
                redeemerTag = RedeemerTag.Reward;
                break;
            }
            case "vote": {
                redeemerTag = RedeemerTag.Voting;
                break;
            }
            case "propose": {
                redeemerTag = RedeemerTag.Proposing;
                break;
            }
            default: {
                throw new IllegalStateException("Unexpected purpose value: " + this.validator.getPurpose());
            }
        }
        evaluationResult.setIndex(this.validator.getIndex());
        evaluationResult.setRedeemerTag(redeemerTag);
        evaluationResult.setExUnits(this.budget.toExecutionUnit());
        return evaluationResult;
    }

    public ValidatorDto getValidator() {
        return this.validator;
    }

    public ExecutionUnitDto getBudget() {
        return this.budget;
    }

    public void setValidator(ValidatorDto validator) {
        this.validator = validator;
    }

    public void setBudget(ExecutionUnitDto budget) {
        this.budget = budget;
    }
}

