/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.supplier.ogmios.dto;

import com.bloxbean.cardano.client.api.model.ProtocolParams;
import com.bloxbean.cardano.client.plutus.util.PlutusOps;
import com.bloxbean.cardano.client.supplier.ogmios.dto.ExecutionUnitDto;
import com.bloxbean.cardano.client.supplier.ogmios.dto.MinFeeReferenceScriptsDto;
import com.bloxbean.cardano.client.supplier.ogmios.dto.VotingThresholdDto;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

@JsonIgnoreProperties(ignoreUnknown=true)
public class ProtocolParametersDto {
    private long minFeeCoefficient;
    private Map<String, Map<String, Long>> minFeeConstant;
    private Map<String, Integer> maxBlockBodySize;
    private Map<String, Integer> maxBlockHeaderSize;
    private Map<String, Integer> maxTransactionSize;
    private Map<String, Map<String, Long>> stakeCredentialDeposit;
    private Map<String, Map<String, Long>> stakePoolDeposit;
    private long stakePoolRetirementEpochBound;
    private long desiredNumberOfStakePools;
    private String stakePoolPledgeInfluence;
    private String monetaryExpansion;
    private String treasuryExpansion;
    private Map<String, Map<String, Long>> minStakePoolCost;
    private Map<String, Map<String, Long>> minUtxoDepositConstant;
    private int minUtxoDepositCoefficient;
    private Map<String, Long[]> plutusCostModels;
    private ExecutionUnitDto scriptExecutionPrices;
    private ExecutionUnitDto maxExecutionUnitsPerTransaction;
    private ExecutionUnitDto maxExecutionUnitsPerBlock;
    private Map<String, Integer> maxValueSize;
    private long collateralPercentage;
    private long maxCollateralInputs;
    private Map<String, Integer> version;
    private VotingThresholdDto stakePoolVotingThresholds;
    private VotingThresholdDto delegateRepresentativeVotingThresholds;
    private long constitutionalCommitteeMinSize;
    private long constitutionalCommitteeMaxTermLength;
    private Map<String, Map<String, Long>> governanceActionDeposit;
    private Map<String, Map<String, Long>> delegateRepresentativeDeposit;
    private long delegateRepresentativeMaxIdleTime;
    private MinFeeReferenceScriptsDto minFeeReferenceScripts;

    public ProtocolParams toProtocolParams() {
        ProtocolParams protocolParams = new ProtocolParams();
        protocolParams.setMinFeeA(Integer.valueOf((int)this.minFeeCoefficient));
        protocolParams.setMinFeeB(Integer.valueOf(this.minFeeConstant.get("ada").get("lovelace").intValue()));
        protocolParams.setMaxBlockSize(Integer.valueOf(this.maxBlockBodySize.get("bytes")));
        protocolParams.setMaxTxSize(Integer.valueOf(this.maxTransactionSize.get("bytes")));
        protocolParams.setMaxBlockHeaderSize(Integer.valueOf(this.maxBlockHeaderSize.get("bytes")));
        protocolParams.setKeyDeposit(this.stakeCredentialDeposit.get("ada").get("lovelace").toString());
        protocolParams.setPoolDeposit(this.stakePoolDeposit.get("ada").get("lovelace").toString());
        protocolParams.setEMax(Integer.valueOf((int)this.stakePoolRetirementEpochBound));
        protocolParams.setNOpt(Integer.valueOf((int)this.desiredNumberOfStakePools));
        protocolParams.setA0(ProtocolParametersDto.stringToDecimal(this.stakePoolPledgeInfluence));
        protocolParams.setRho(ProtocolParametersDto.stringToDecimal(this.monetaryExpansion));
        protocolParams.setTau(ProtocolParametersDto.stringToDecimal(this.treasuryExpansion));
        protocolParams.setProtocolMajorVer(this.version.get("major"));
        protocolParams.setProtocolMinorVer(this.version.get("minor"));
        protocolParams.setMinUtxo(String.valueOf(this.minUtxoDepositCoefficient));
        protocolParams.setMinPoolCost(this.minStakePoolCost.get("ada").get("lovelace").toString());
        LinkedHashMap<String, LinkedHashMap> costModels = new LinkedHashMap<String, LinkedHashMap>();
        costModels.put("PlutusV1", new LinkedHashMap<String, Long>(){
            {
                List plutusOps = PlutusOps.getOperations((int)1);
                for (int i = 0; i < ProtocolParametersDto.this.plutusCostModels.get("plutus:v1").length; ++i) {
                    this.put((String)plutusOps.get(i), ProtocolParametersDto.this.plutusCostModels.get("plutus:v1")[i]);
                }
            }
        });
        costModels.put("PlutusV2", new LinkedHashMap<String, Long>(){
            {
                List plutusOps = PlutusOps.getOperations((int)2);
                for (int i = 0; i < ProtocolParametersDto.this.plutusCostModels.get("plutus:v2").length; ++i) {
                    this.put((String)plutusOps.get(i), ProtocolParametersDto.this.plutusCostModels.get("plutus:v2")[i]);
                }
            }
        });
        costModels.put("PlutusV3", new LinkedHashMap<String, Long>(){
            {
                List plutusOps = PlutusOps.getOperations((int)3);
                for (int i = 0; i < ProtocolParametersDto.this.plutusCostModels.get("plutus:v3").length; ++i) {
                    this.put((String)plutusOps.get(i), ProtocolParametersDto.this.plutusCostModels.get("plutus:v3")[i]);
                }
            }
        });
        protocolParams.setCostModels(costModels);
        protocolParams.setPriceMem(ProtocolParametersDto.stringToDecimal(this.scriptExecutionPrices.getMemory()));
        protocolParams.setPriceStep(ProtocolParametersDto.stringToDecimal(this.scriptExecutionPrices.getCpu()));
        protocolParams.setMaxTxExMem(this.maxExecutionUnitsPerTransaction.getMemory());
        protocolParams.setMaxTxExSteps(this.maxExecutionUnitsPerTransaction.getCpu());
        protocolParams.setMaxBlockExMem(this.maxExecutionUnitsPerBlock.getMemory());
        protocolParams.setMaxBlockExSteps(this.maxExecutionUnitsPerBlock.getCpu());
        protocolParams.setMaxValSize(String.valueOf(this.maxValueSize.get("bytes")));
        protocolParams.setCollateralPercent(BigDecimal.valueOf(this.collateralPercentage));
        protocolParams.setMaxCollateralInputs(Integer.valueOf((int)this.maxCollateralInputs));
        protocolParams.setCoinsPerUtxoSize(String.valueOf(this.minUtxoDepositCoefficient));
        if (this.minFeeReferenceScripts != null) {
            protocolParams.setMinFeeRefScriptCostPerByte(this.minFeeReferenceScripts.getBase());
        }
        return protocolParams;
    }

    private static BigDecimal stringToDecimal(String str) {
        try {
            if (str == null || str.isEmpty()) {
                return null;
            }
            String[] parts = str.split("/");
            double d = Double.parseDouble(parts[0]) / Double.parseDouble(parts[1]);
            return new BigDecimal(d);
        }
        catch (Exception e) {
            return BigDecimal.ZERO;
        }
    }

    public long getMinFeeCoefficient() {
        return this.minFeeCoefficient;
    }

    public Map<String, Map<String, Long>> getMinFeeConstant() {
        return this.minFeeConstant;
    }

    public Map<String, Integer> getMaxBlockBodySize() {
        return this.maxBlockBodySize;
    }

    public Map<String, Integer> getMaxBlockHeaderSize() {
        return this.maxBlockHeaderSize;
    }

    public Map<String, Integer> getMaxTransactionSize() {
        return this.maxTransactionSize;
    }

    public Map<String, Map<String, Long>> getStakeCredentialDeposit() {
        return this.stakeCredentialDeposit;
    }

    public Map<String, Map<String, Long>> getStakePoolDeposit() {
        return this.stakePoolDeposit;
    }

    public long getStakePoolRetirementEpochBound() {
        return this.stakePoolRetirementEpochBound;
    }

    public long getDesiredNumberOfStakePools() {
        return this.desiredNumberOfStakePools;
    }

    public String getStakePoolPledgeInfluence() {
        return this.stakePoolPledgeInfluence;
    }

    public String getMonetaryExpansion() {
        return this.monetaryExpansion;
    }

    public String getTreasuryExpansion() {
        return this.treasuryExpansion;
    }

    public Map<String, Map<String, Long>> getMinStakePoolCost() {
        return this.minStakePoolCost;
    }

    public Map<String, Map<String, Long>> getMinUtxoDepositConstant() {
        return this.minUtxoDepositConstant;
    }

    public int getMinUtxoDepositCoefficient() {
        return this.minUtxoDepositCoefficient;
    }

    public Map<String, Long[]> getPlutusCostModels() {
        return this.plutusCostModels;
    }

    public ExecutionUnitDto getScriptExecutionPrices() {
        return this.scriptExecutionPrices;
    }

    public ExecutionUnitDto getMaxExecutionUnitsPerTransaction() {
        return this.maxExecutionUnitsPerTransaction;
    }

    public ExecutionUnitDto getMaxExecutionUnitsPerBlock() {
        return this.maxExecutionUnitsPerBlock;
    }

    public Map<String, Integer> getMaxValueSize() {
        return this.maxValueSize;
    }

    public long getCollateralPercentage() {
        return this.collateralPercentage;
    }

    public long getMaxCollateralInputs() {
        return this.maxCollateralInputs;
    }

    public Map<String, Integer> getVersion() {
        return this.version;
    }

    public VotingThresholdDto getStakePoolVotingThresholds() {
        return this.stakePoolVotingThresholds;
    }

    public VotingThresholdDto getDelegateRepresentativeVotingThresholds() {
        return this.delegateRepresentativeVotingThresholds;
    }

    public long getConstitutionalCommitteeMinSize() {
        return this.constitutionalCommitteeMinSize;
    }

    public long getConstitutionalCommitteeMaxTermLength() {
        return this.constitutionalCommitteeMaxTermLength;
    }

    public Map<String, Map<String, Long>> getGovernanceActionDeposit() {
        return this.governanceActionDeposit;
    }

    public Map<String, Map<String, Long>> getDelegateRepresentativeDeposit() {
        return this.delegateRepresentativeDeposit;
    }

    public long getDelegateRepresentativeMaxIdleTime() {
        return this.delegateRepresentativeMaxIdleTime;
    }

    public MinFeeReferenceScriptsDto getMinFeeReferenceScripts() {
        return this.minFeeReferenceScripts;
    }

    public void setMinFeeCoefficient(long minFeeCoefficient) {
        this.minFeeCoefficient = minFeeCoefficient;
    }

    public void setMinFeeConstant(Map<String, Map<String, Long>> minFeeConstant) {
        this.minFeeConstant = minFeeConstant;
    }

    public void setMaxBlockBodySize(Map<String, Integer> maxBlockBodySize) {
        this.maxBlockBodySize = maxBlockBodySize;
    }

    public void setMaxBlockHeaderSize(Map<String, Integer> maxBlockHeaderSize) {
        this.maxBlockHeaderSize = maxBlockHeaderSize;
    }

    public void setMaxTransactionSize(Map<String, Integer> maxTransactionSize) {
        this.maxTransactionSize = maxTransactionSize;
    }

    public void setStakeCredentialDeposit(Map<String, Map<String, Long>> stakeCredentialDeposit) {
        this.stakeCredentialDeposit = stakeCredentialDeposit;
    }

    public void setStakePoolDeposit(Map<String, Map<String, Long>> stakePoolDeposit) {
        this.stakePoolDeposit = stakePoolDeposit;
    }

    public void setStakePoolRetirementEpochBound(long stakePoolRetirementEpochBound) {
        this.stakePoolRetirementEpochBound = stakePoolRetirementEpochBound;
    }

    public void setDesiredNumberOfStakePools(long desiredNumberOfStakePools) {
        this.desiredNumberOfStakePools = desiredNumberOfStakePools;
    }

    public void setStakePoolPledgeInfluence(String stakePoolPledgeInfluence) {
        this.stakePoolPledgeInfluence = stakePoolPledgeInfluence;
    }

    public void setMonetaryExpansion(String monetaryExpansion) {
        this.monetaryExpansion = monetaryExpansion;
    }

    public void setTreasuryExpansion(String treasuryExpansion) {
        this.treasuryExpansion = treasuryExpansion;
    }

    public void setMinStakePoolCost(Map<String, Map<String, Long>> minStakePoolCost) {
        this.minStakePoolCost = minStakePoolCost;
    }

    public void setMinUtxoDepositConstant(Map<String, Map<String, Long>> minUtxoDepositConstant) {
        this.minUtxoDepositConstant = minUtxoDepositConstant;
    }

    public void setMinUtxoDepositCoefficient(int minUtxoDepositCoefficient) {
        this.minUtxoDepositCoefficient = minUtxoDepositCoefficient;
    }

    public void setPlutusCostModels(Map<String, Long[]> plutusCostModels) {
        this.plutusCostModels = plutusCostModels;
    }

    public void setScriptExecutionPrices(ExecutionUnitDto scriptExecutionPrices) {
        this.scriptExecutionPrices = scriptExecutionPrices;
    }

    public void setMaxExecutionUnitsPerTransaction(ExecutionUnitDto maxExecutionUnitsPerTransaction) {
        this.maxExecutionUnitsPerTransaction = maxExecutionUnitsPerTransaction;
    }

    public void setMaxExecutionUnitsPerBlock(ExecutionUnitDto maxExecutionUnitsPerBlock) {
        this.maxExecutionUnitsPerBlock = maxExecutionUnitsPerBlock;
    }

    public void setMaxValueSize(Map<String, Integer> maxValueSize) {
        this.maxValueSize = maxValueSize;
    }

    public void setCollateralPercentage(long collateralPercentage) {
        this.collateralPercentage = collateralPercentage;
    }

    public void setMaxCollateralInputs(long maxCollateralInputs) {
        this.maxCollateralInputs = maxCollateralInputs;
    }

    public void setVersion(Map<String, Integer> version) {
        this.version = version;
    }

    public void setStakePoolVotingThresholds(VotingThresholdDto stakePoolVotingThresholds) {
        this.stakePoolVotingThresholds = stakePoolVotingThresholds;
    }

    public void setDelegateRepresentativeVotingThresholds(VotingThresholdDto delegateRepresentativeVotingThresholds) {
        this.delegateRepresentativeVotingThresholds = delegateRepresentativeVotingThresholds;
    }

    public void setConstitutionalCommitteeMinSize(long constitutionalCommitteeMinSize) {
        this.constitutionalCommitteeMinSize = constitutionalCommitteeMinSize;
    }

    public void setConstitutionalCommitteeMaxTermLength(long constitutionalCommitteeMaxTermLength) {
        this.constitutionalCommitteeMaxTermLength = constitutionalCommitteeMaxTermLength;
    }

    public void setGovernanceActionDeposit(Map<String, Map<String, Long>> governanceActionDeposit) {
        this.governanceActionDeposit = governanceActionDeposit;
    }

    public void setDelegateRepresentativeDeposit(Map<String, Map<String, Long>> delegateRepresentativeDeposit) {
        this.delegateRepresentativeDeposit = delegateRepresentativeDeposit;
    }

    public void setDelegateRepresentativeMaxIdleTime(long delegateRepresentativeMaxIdleTime) {
        this.delegateRepresentativeMaxIdleTime = delegateRepresentativeMaxIdleTime;
    }

    public void setMinFeeReferenceScripts(MinFeeReferenceScriptsDto minFeeReferenceScripts) {
        this.minFeeReferenceScripts = minFeeReferenceScripts;
    }
}

