/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.MirPot;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import java.math.BigInteger;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;

public class MoveInstataneous
implements Certificate {
    private final CertificateType type = CertificateType.MOVE_INSTATENEOUS_REWARDS_CERT;
    private MirPot pot;
    private BigInteger accountingPotCoin;
    private java.util.Map<StakeCredential, BigInteger> stakeCredentialCoinMap;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(6L));
        if (this.pot == null) {
            throw new CborSerializationException("pot can't be null");
        }
        Array moveInstArray = new Array();
        moveInstArray.add((DataItem)new UnsignedInteger((long)this.pot.getValue()));
        if (this.stakeCredentialCoinMap != null && this.stakeCredentialCoinMap.size() > 0) {
            Map map = new Map();
            map.setChunked(true);
            for (StakeCredential stakeCredential : this.stakeCredentialCoinMap.keySet()) {
                BigInteger deltaCoin = this.stakeCredentialCoinMap.get(stakeCredential);
                map.put((DataItem)stakeCredential.serialize(), (DataItem)new UnsignedInteger(deltaCoin));
            }
            moveInstArray.add((DataItem)map);
        } else {
            moveInstArray.add((DataItem)new UnsignedInteger(this.accountingPotCoin));
        }
        array.add((DataItem)moveInstArray);
        return array;
    }

    public static MoveInstataneous deserialize(Array moveInstantaneousArr) throws CborDeserializationException {
        List dataItemList = moveInstantaneousArr.getDataItems();
        if (dataItemList == null || dataItemList.size() != 2) {
            throw new CborDeserializationException("MoveInstantaneous Rewards deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger type = (UnsignedInteger)dataItemList.get(0);
        if (type == null || type.getValue().intValue() != 6) {
            throw new CborDeserializationException("MoveInstantaneous Rewards deserialization failed. Invalid type : " + type != null ? String.valueOf(type.getValue().intValue()) : null);
        }
        List moveInstDIList = ((Array)dataItemList.get(1)).getDataItems();
        MirPot pot = null;
        int fundsDrawnFrom = CborSerializationUtil.toInt((DataItem)((DataItem)moveInstDIList.get(0)));
        if (fundsDrawnFrom == 0) {
            pot = MirPot.RESERVES;
        }
        if (fundsDrawnFrom == 1) {
            pot = MirPot.TREASURY;
        }
        LinkedHashMap<StakeCredential, BigInteger> stakeCredentialsMap = new LinkedHashMap<StakeCredential, BigInteger>();
        BigInteger accountingPotCoin = null;
        DataItem fundsMoveDI = (DataItem)moveInstDIList.get(1);
        if (fundsMoveDI.getMajorType() == MajorType.MAP) {
            Map fundsMoveDIMap = (Map)fundsMoveDI;
            Collection keys = fundsMoveDIMap.getKeys();
            for (DataItem key : keys) {
                DataItem deltaCoinDI = fundsMoveDIMap.get(key);
                BigInteger deltaCoinValue = CborSerializationUtil.getBigInteger((DataItem)deltaCoinDI);
                StakeCredential stakeCredential = StakeCredential.deserialize((Array)key);
                stakeCredentialsMap.put(stakeCredential, deltaCoinValue);
            }
        } else {
            accountingPotCoin = CborSerializationUtil.getBigInteger((DataItem)fundsMoveDI);
        }
        return new MoveInstataneous(pot, accountingPotCoin, stakeCredentialsMap);
    }

    public static MoveInstataneousBuilder builder() {
        return new MoveInstataneousBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public MirPot getPot() {
        return this.pot;
    }

    public BigInteger getAccountingPotCoin() {
        return this.accountingPotCoin;
    }

    public java.util.Map<StakeCredential, BigInteger> getStakeCredentialCoinMap() {
        return this.stakeCredentialCoinMap;
    }

    public MoveInstataneous() {
    }

    public MoveInstataneous(MirPot pot, BigInteger accountingPotCoin, java.util.Map<StakeCredential, BigInteger> stakeCredentialCoinMap) {
        this.pot = pot;
        this.accountingPotCoin = accountingPotCoin;
        this.stakeCredentialCoinMap = stakeCredentialCoinMap;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof MoveInstataneous)) {
            return false;
        }
        MoveInstataneous other = (MoveInstataneous)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        MirPot this$pot = this.getPot();
        MirPot other$pot = other.getPot();
        if (this$pot == null ? other$pot != null : !((Object)((Object)this$pot)).equals((Object)other$pot)) {
            return false;
        }
        BigInteger this$accountingPotCoin = this.getAccountingPotCoin();
        BigInteger other$accountingPotCoin = other.getAccountingPotCoin();
        if (this$accountingPotCoin == null ? other$accountingPotCoin != null : !((Object)this$accountingPotCoin).equals(other$accountingPotCoin)) {
            return false;
        }
        java.util.Map<StakeCredential, BigInteger> this$stakeCredentialCoinMap = this.getStakeCredentialCoinMap();
        java.util.Map<StakeCredential, BigInteger> other$stakeCredentialCoinMap = other.getStakeCredentialCoinMap();
        return !(this$stakeCredentialCoinMap == null ? other$stakeCredentialCoinMap != null : !((Object)this$stakeCredentialCoinMap).equals(other$stakeCredentialCoinMap));
    }

    protected boolean canEqual(Object other) {
        return other instanceof MoveInstataneous;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        MirPot $pot = this.getPot();
        result = result * 59 + ($pot == null ? 43 : ((Object)((Object)$pot)).hashCode());
        BigInteger $accountingPotCoin = this.getAccountingPotCoin();
        result = result * 59 + ($accountingPotCoin == null ? 43 : ((Object)$accountingPotCoin).hashCode());
        java.util.Map<StakeCredential, BigInteger> $stakeCredentialCoinMap = this.getStakeCredentialCoinMap();
        result = result * 59 + ($stakeCredentialCoinMap == null ? 43 : ((Object)$stakeCredentialCoinMap).hashCode());
        return result;
    }

    public String toString() {
        return "MoveInstataneous(type=" + this.getType() + ", pot=" + this.getPot() + ", accountingPotCoin=" + this.getAccountingPotCoin() + ", stakeCredentialCoinMap=" + this.getStakeCredentialCoinMap() + ")";
    }

    public static class MoveInstataneousBuilder {
        private MirPot pot;
        private BigInteger accountingPotCoin;
        private java.util.Map<StakeCredential, BigInteger> stakeCredentialCoinMap;

        MoveInstataneousBuilder() {
        }

        public MoveInstataneousBuilder pot(MirPot pot) {
            this.pot = pot;
            return this;
        }

        public MoveInstataneousBuilder accountingPotCoin(BigInteger accountingPotCoin) {
            this.accountingPotCoin = accountingPotCoin;
            return this;
        }

        public MoveInstataneousBuilder stakeCredentialCoinMap(java.util.Map<StakeCredential, BigInteger> stakeCredentialCoinMap) {
            this.stakeCredentialCoinMap = stakeCredentialCoinMap;
            return this;
        }

        public MoveInstataneous build() {
            return new MoveInstataneous(this.pot, this.accountingPotCoin, this.stakeCredentialCoinMap);
        }

        public String toString() {
            return "MoveInstataneous.MoveInstataneousBuilder(pot=" + this.pot + ", accountingPotCoin=" + this.accountingPotCoin + ", stakeCredentialCoinMap=" + this.stakeCredentialCoinMap + ")";
        }
    }
}

