/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import java.util.Arrays;
import java.util.List;

public class GenesisKeyDelegation
implements Certificate {
    private final CertificateType type = CertificateType.GENESIS_KEY_DELEGATION;
    private byte[] genesisHash;
    private byte[] genesisDelegateHash;
    private byte[] vrfKeyHash;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(5L));
        array.add((DataItem)new ByteString(this.genesisHash));
        array.add((DataItem)new ByteString(this.genesisDelegateHash));
        array.add((DataItem)new ByteString(this.vrfKeyHash));
        return array;
    }

    public static GenesisKeyDelegation deserialize(Array genesisKeyDelArray) throws CborDeserializationException {
        List dataItemList = genesisKeyDelArray.getDataItems();
        if (dataItemList == null || dataItemList.size() != 4) {
            throw new CborDeserializationException("GenesisKeyDelegation deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger type = (UnsignedInteger)dataItemList.get(0);
        if (type == null || type.getValue().intValue() != 5) {
            throw new CborDeserializationException("GenesisKeyDelegation deserialization failed. Invalid type : " + type != null ? String.valueOf(type.getValue().intValue()) : null);
        }
        byte[] genesisHash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(1)));
        byte[] genesisDelegateHash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(2)));
        byte[] vrfKeyHash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(3)));
        return new GenesisKeyDelegation(genesisHash, genesisDelegateHash, vrfKeyHash);
    }

    public static GenesisKeyDelegationBuilder builder() {
        return new GenesisKeyDelegationBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public byte[] getGenesisHash() {
        return this.genesisHash;
    }

    public byte[] getGenesisDelegateHash() {
        return this.genesisDelegateHash;
    }

    public byte[] getVrfKeyHash() {
        return this.vrfKeyHash;
    }

    public GenesisKeyDelegation() {
    }

    public GenesisKeyDelegation(byte[] genesisHash, byte[] genesisDelegateHash, byte[] vrfKeyHash) {
        this.genesisHash = genesisHash;
        this.genesisDelegateHash = genesisDelegateHash;
        this.vrfKeyHash = vrfKeyHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof GenesisKeyDelegation)) {
            return false;
        }
        GenesisKeyDelegation other = (GenesisKeyDelegation)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getGenesisHash(), other.getGenesisHash())) {
            return false;
        }
        if (!Arrays.equals(this.getGenesisDelegateHash(), other.getGenesisDelegateHash())) {
            return false;
        }
        return Arrays.equals(this.getVrfKeyHash(), other.getVrfKeyHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof GenesisKeyDelegation;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getGenesisHash());
        result = result * 59 + Arrays.hashCode(this.getGenesisDelegateHash());
        result = result * 59 + Arrays.hashCode(this.getVrfKeyHash());
        return result;
    }

    public String toString() {
        return "GenesisKeyDelegation(type=" + this.getType() + ", genesisHash=" + Arrays.toString(this.getGenesisHash()) + ", genesisDelegateHash=" + Arrays.toString(this.getGenesisDelegateHash()) + ", vrfKeyHash=" + Arrays.toString(this.getVrfKeyHash()) + ")";
    }

    public static class GenesisKeyDelegationBuilder {
        private byte[] genesisHash;
        private byte[] genesisDelegateHash;
        private byte[] vrfKeyHash;

        GenesisKeyDelegationBuilder() {
        }

        public GenesisKeyDelegationBuilder genesisHash(byte[] genesisHash) {
            this.genesisHash = genesisHash;
            return this;
        }

        public GenesisKeyDelegationBuilder genesisDelegateHash(byte[] genesisDelegateHash) {
            this.genesisDelegateHash = genesisDelegateHash;
            return this;
        }

        public GenesisKeyDelegationBuilder vrfKeyHash(byte[] vrfKeyHash) {
            this.vrfKeyHash = vrfKeyHash;
            return this;
        }

        public GenesisKeyDelegation build() {
            return new GenesisKeyDelegation(this.genesisHash, this.genesisDelegateHash, this.vrfKeyHash);
        }

        public String toString() {
            return "GenesisKeyDelegation.GenesisKeyDelegationBuilder(genesisHash=" + Arrays.toString(this.genesisHash) + ", genesisDelegateHash=" + Arrays.toString(this.genesisDelegateHash) + ", vrfKeyHash=" + Arrays.toString(this.vrfKeyHash) + ")";
        }
    }
}

