/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.util;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.util.HexUtil;

public class TransactionUtil {
    public static Transaction createCopy(Transaction transaction) {
        try {
            Transaction cloneTxn = Transaction.deserialize(transaction.serialize());
            return cloneTxn;
        }
        catch (CborDeserializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    public static String getTxHash(Transaction transaction) {
        try {
            transaction.serialize();
            return TransactionUtil.safeGetTxHash(transaction.getBody());
        }
        catch (Exception ex) {
            throw new RuntimeException("Get transaction hash failed. ", ex);
        }
    }

    public static String getTxHash(byte[] transactionBytes) {
        try {
            Array array = (Array)CborSerializationUtil.deserialize((byte[])transactionBytes);
            DataItem txBodyDI = (DataItem)array.getDataItems().get(0);
            return TransactionUtil.safeGetTxHash(CborSerializationUtil.serialize((DataItem)txBodyDI, (boolean)false));
        }
        catch (Exception ex) {
            throw new RuntimeException("Get transaction hash failed. ", ex);
        }
    }

    private static String safeGetTxHash(byte[] txBodyBytes) throws Exception {
        return HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])txBodyBytes));
    }

    private static String safeGetTxHash(TransactionBody safeTransactionBody) throws Exception {
        return TransactionUtil.safeGetTxHash(CborSerializationUtil.serialize((DataItem)safeTransactionBody.serialize()));
    }
}

