/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.MajorType;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.Special;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.transaction.spec.AuxiliaryData;
import com.bloxbean.cardano.client.transaction.spec.TransactionBody;
import com.bloxbean.cardano.client.transaction.spec.TransactionWitnessSet;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.util.List;

public class Transaction {
    private TransactionBody body;
    private TransactionWitnessSet witnessSet;
    private boolean isValid;
    private AuxiliaryData auxiliaryData;

    @Deprecated
    public void setMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        if (this.auxiliaryData == null) {
            this.auxiliaryData = new AuxiliaryData();
        }
        this.auxiliaryData.setMetadata(metadata);
    }

    @Deprecated
    @JsonIgnore
    public Metadata getMetadata() {
        if (this.auxiliaryData != null) {
            return this.auxiliaryData.getMetadata();
        }
        return null;
    }

    public byte[] serialize() throws CborSerializationException {
        try {
            Map witnessMap;
            if (this.auxiliaryData != null && this.body.getAuxiliaryDataHash() == null) {
                byte[] auxiliaryDataHash = this.auxiliaryData.getAuxiliaryDataHash();
                this.body.setAuxiliaryDataHash(auxiliaryDataHash);
            }
            Array array = new Array();
            Map bodyMap = this.body.serialize();
            array.add((DataItem)bodyMap);
            if (this.witnessSet != null) {
                witnessMap = this.witnessSet.serialize();
                array.add((DataItem)witnessMap);
            } else {
                witnessMap = new Map();
                array.add((DataItem)witnessMap);
            }
            if (this.isValid) {
                array.add((DataItem)SimpleValue.TRUE);
            } else {
                array.add((DataItem)SimpleValue.FALSE);
            }
            if (this.auxiliaryData != null) {
                DataItem auxDataMap = this.auxiliaryData.serialize();
                array.add(auxDataMap);
            } else {
                array.add((DataItem)SimpleValue.NULL);
            }
            return CborSerializationUtil.serialize((DataItem)array);
        }
        catch (Exception e) {
            throw new CborSerializationException("CBOR Serialization failed", e);
        }
    }

    public String serializeToHex() throws CborSerializationException {
        try {
            byte[] bytes = this.serialize();
            return HexUtil.encodeHexString((byte[])bytes);
        }
        catch (Exception ex) {
            throw new CborSerializationException("CBOR serialization exception", ex);
        }
    }

    public static Transaction deserialize(byte[] bytes) throws CborDeserializationException {
        try {
            DataItem auxiliaryDataDI;
            List dataItemList = CborDecoder.decode((byte[])bytes);
            Transaction transaction = new Transaction();
            if (dataItemList.size() != 1) {
                throw new CborDeserializationException("Invalid no of dataitems");
            }
            Array array = (Array)dataItemList.get(0);
            List txnItems = array.getDataItems();
            if (txnItems.size() < 3) {
                throw new CborDeserializationException("Invalid no of items");
            }
            DataItem txnBodyDI = (DataItem)txnItems.get(0);
            DataItem witnessDI = (DataItem)txnItems.get(1);
            if (witnessDI != null) {
                TransactionWitnessSet witnessSet = TransactionWitnessSet.deserialize((Map)witnessDI);
                transaction.setWitnessSet(witnessSet);
            }
            DataItem isValidDI = (DataItem)txnItems.get(2);
            boolean checkAuxData = true;
            if (isValidDI != null && isValidDI instanceof Special) {
                if (isValidDI == SimpleValue.TRUE) {
                    transaction.setValid(true);
                } else if (isValidDI == SimpleValue.FALSE) {
                    transaction.setValid(false);
                } else if (isValidDI == SimpleValue.NULL) {
                    checkAuxData = false;
                    transaction.setValid(true);
                } else {
                    transaction.setValid(true);
                }
            } else {
                transaction.setValid(true);
            }
            if (checkAuxData && (auxiliaryDataDI = (DataItem)txnItems.get(3)) != null && MajorType.MAP.equals((Object)auxiliaryDataDI.getMajorType())) {
                DataItem auxiliaryDataMap = auxiliaryDataDI;
                AuxiliaryData auxiliaryData = AuxiliaryData.deserialize((Map)auxiliaryDataMap);
                transaction.setAuxiliaryData(auxiliaryData);
            }
            TransactionBody body = TransactionBody.deserialize((Map)txnBodyDI);
            transaction.setBody(body);
            return transaction;
        }
        catch (Exception e) {
            throw new CborDeserializationException("CBOR deserialization failed", e);
        }
    }

    public String toJson() {
        return JsonUtil.getPrettyJson((Object)this);
    }

    private static TransactionBody $default$body() {
        return new TransactionBody();
    }

    private static TransactionWitnessSet $default$witnessSet() {
        return new TransactionWitnessSet();
    }

    private static boolean $default$isValid() {
        return true;
    }

    public static TransactionBuilder builder() {
        return new TransactionBuilder();
    }

    public TransactionBody getBody() {
        return this.body;
    }

    public TransactionWitnessSet getWitnessSet() {
        return this.witnessSet;
    }

    public boolean isValid() {
        return this.isValid;
    }

    public AuxiliaryData getAuxiliaryData() {
        return this.auxiliaryData;
    }

    public void setBody(TransactionBody body) {
        this.body = body;
    }

    public void setWitnessSet(TransactionWitnessSet witnessSet) {
        this.witnessSet = witnessSet;
    }

    public void setValid(boolean isValid) {
        this.isValid = isValid;
    }

    public void setAuxiliaryData(AuxiliaryData auxiliaryData) {
        this.auxiliaryData = auxiliaryData;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Transaction)) {
            return false;
        }
        Transaction other = (Transaction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isValid() != other.isValid()) {
            return false;
        }
        TransactionBody this$body = this.getBody();
        TransactionBody other$body = other.getBody();
        if (this$body == null ? other$body != null : !((Object)this$body).equals(other$body)) {
            return false;
        }
        TransactionWitnessSet this$witnessSet = this.getWitnessSet();
        TransactionWitnessSet other$witnessSet = other.getWitnessSet();
        if (this$witnessSet == null ? other$witnessSet != null : !((Object)this$witnessSet).equals(other$witnessSet)) {
            return false;
        }
        AuxiliaryData this$auxiliaryData = this.getAuxiliaryData();
        AuxiliaryData other$auxiliaryData = other.getAuxiliaryData();
        return !(this$auxiliaryData == null ? other$auxiliaryData != null : !((Object)this$auxiliaryData).equals(other$auxiliaryData));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Transaction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isValid() ? 79 : 97);
        TransactionBody $body = this.getBody();
        result = result * 59 + ($body == null ? 43 : ((Object)$body).hashCode());
        TransactionWitnessSet $witnessSet = this.getWitnessSet();
        result = result * 59 + ($witnessSet == null ? 43 : ((Object)$witnessSet).hashCode());
        AuxiliaryData $auxiliaryData = this.getAuxiliaryData();
        result = result * 59 + ($auxiliaryData == null ? 43 : ((Object)$auxiliaryData).hashCode());
        return result;
    }

    public String toString() {
        return "Transaction(body=" + this.getBody() + ", witnessSet=" + this.getWitnessSet() + ", isValid=" + this.isValid() + ", auxiliaryData=" + this.getAuxiliaryData() + ")";
    }

    public Transaction(TransactionBody body, TransactionWitnessSet witnessSet, boolean isValid, AuxiliaryData auxiliaryData) {
        this.body = body;
        this.witnessSet = witnessSet;
        this.isValid = isValid;
        this.auxiliaryData = auxiliaryData;
    }

    public Transaction() {
        this.body = Transaction.$default$body();
        this.witnessSet = Transaction.$default$witnessSet();
        this.isValid = Transaction.$default$isValid();
    }

    public static class TransactionBuilder {
        private boolean body$set;
        private TransactionBody body$value;
        private boolean witnessSet$set;
        private TransactionWitnessSet witnessSet$value;
        private boolean isValid$set;
        private boolean isValid$value;
        private AuxiliaryData auxiliaryData;

        @Deprecated
        public TransactionBuilder metadata(Metadata metadata) {
            if (metadata == null) {
                return this;
            }
            if (this.auxiliaryData == null) {
                this.auxiliaryData = new AuxiliaryData();
            }
            this.auxiliaryData.setMetadata(metadata);
            return this;
        }

        TransactionBuilder() {
        }

        public TransactionBuilder body(TransactionBody body) {
            this.body$value = body;
            this.body$set = true;
            return this;
        }

        public TransactionBuilder witnessSet(TransactionWitnessSet witnessSet) {
            this.witnessSet$value = witnessSet;
            this.witnessSet$set = true;
            return this;
        }

        public TransactionBuilder isValid(boolean isValid) {
            this.isValid$value = isValid;
            this.isValid$set = true;
            return this;
        }

        public TransactionBuilder auxiliaryData(AuxiliaryData auxiliaryData) {
            this.auxiliaryData = auxiliaryData;
            return this;
        }

        public Transaction build() {
            TransactionBody body$value = this.body$value;
            if (!this.body$set) {
                body$value = Transaction.$default$body();
            }
            TransactionWitnessSet witnessSet$value = this.witnessSet$value;
            if (!this.witnessSet$set) {
                witnessSet$value = Transaction.$default$witnessSet();
            }
            boolean isValid$value = this.isValid$value;
            if (!this.isValid$set) {
                isValid$value = Transaction.$default$isValid();
            }
            return new Transaction(body$value, witnessSet$value, isValid$value, this.auxiliaryData);
        }

        public String toString() {
            return "Transaction.TransactionBuilder(body$value=" + this.body$value + ", witnessSet$value=" + this.witnessSet$value + ", isValid$value=" + this.isValid$value + ", auxiliaryData=" + this.auxiliaryData + ")";
        }
    }
}

