/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.RationalNumber;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnicodeString;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.UnitInterval;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.MultiHostName;
import com.bloxbean.cardano.client.transaction.spec.cert.Relay;
import com.bloxbean.cardano.client.transaction.spec.cert.SingleHostAddr;
import com.bloxbean.cardano.client.transaction.spec.cert.SingleHostName;
import com.bloxbean.cardano.client.transaction.spec.cert.StakePoolId;
import com.bloxbean.cardano.client.util.HexUtil;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.math.BigInteger;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;

public class PoolRegistration
implements Certificate {
    private final CertificateType type = CertificateType.POOL_REGISTRATION;
    private byte[] operator;
    private byte[] vrfKeyHash;
    private BigInteger pledge;
    private BigInteger cost;
    private UnitInterval margin;
    private String rewardAccount;
    private Set<String> poolOwners;
    private List<Relay> relays;
    private String poolMetadataUrl;
    private String poolMetadataHash;

    @Override
    public Array serialize() throws CborSerializationException {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(3L));
        array.add((DataItem)new ByteString(this.operator));
        array.add((DataItem)new ByteString(this.vrfKeyHash));
        array.add((DataItem)new UnsignedInteger(this.pledge));
        array.add((DataItem)new UnsignedInteger(this.cost));
        try {
            array.add((DataItem)new RationalNumber((Number)new UnsignedInteger(this.margin.getNumerator()), (Number)new UnsignedInteger(this.margin.getDenominator())));
        }
        catch (CborException e) {
            throw new CborSerializationException("Serialization error", (Exception)((Object)e));
        }
        array.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.rewardAccount)));
        Array poolOwnersArr = new Array();
        this.poolOwners.stream().forEach(poolOwner -> poolOwnersArr.add((DataItem)new ByteString(HexUtil.decodeHexString((String)poolOwner))));
        array.add((DataItem)poolOwnersArr);
        Array relayArr = new Array();
        if (this.relays != null) {
            for (Relay relay : this.relays) {
                relayArr.add((DataItem)relay.serialize());
            }
        }
        array.add((DataItem)relayArr);
        if (this.poolMetadataHash == null) {
            array.add((DataItem)SimpleValue.NULL);
        } else {
            Array poolMetadataArray = new Array();
            poolMetadataArray.add((DataItem)new UnicodeString(this.poolMetadataUrl));
            poolMetadataArray.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.poolMetadataHash)));
            array.add((DataItem)poolMetadataArray);
        }
        return array;
    }

    public static PoolRegistration deserialize(DataItem di) throws CborDeserializationException {
        Array poolRegistrationArr = (Array)di;
        List dataItemList = poolRegistrationArr.getDataItems();
        if (dataItemList == null || dataItemList.size() != 10) {
            throw new CborDeserializationException("PoolRegistration deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger type = (UnsignedInteger)dataItemList.get(0);
        if (type == null || type.getValue().intValue() != 3) {
            throw new CborDeserializationException("PoolRegistration deserialization failed. Invalid type : " + type != null ? String.valueOf(type.getValue().intValue()) : null);
        }
        byte[] operator = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(1)));
        byte[] vrfKeyHash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(2)));
        BigInteger pledge = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(3)));
        BigInteger cost = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(4)));
        RationalNumber marginDI = (RationalNumber)dataItemList.get(5);
        UnitInterval margin = new UnitInterval(CborSerializationUtil.getBigInteger((DataItem)marginDI.getNumerator()), CborSerializationUtil.getBigInteger((DataItem)marginDI.getDenominator()));
        String rewardAccount = CborSerializationUtil.toHex((DataItem)((DataItem)dataItemList.get(6)));
        HashSet<String> poolOwners = new HashSet<String>();
        List poolOwnersDataItems = ((Array)dataItemList.get(7)).getDataItems();
        for (DataItem poolOwnerDI : poolOwnersDataItems) {
            poolOwners.add(CborSerializationUtil.toHex((DataItem)poolOwnerDI));
        }
        ArrayList<Relay> relays = new ArrayList<Relay>();
        try {
            List relaysDataItems = ((Array)dataItemList.get(8)).getDataItems();
            for (DataItem relayDI : relaysDataItems) {
                relays.add(PoolRegistration.deserializeRelay(relayDI));
            }
        }
        catch (Exception e) {
            throw new CborDeserializationException("Deserialization error", e);
        }
        DataItem poolMetaDataDI = (DataItem)dataItemList.get(9);
        String metadataUrl = null;
        String metadataHash = null;
        if (poolMetaDataDI != SimpleValue.NULL) {
            List poolMetadataDataItems = ((Array)poolMetaDataDI).getDataItems();
            metadataUrl = CborSerializationUtil.toUnicodeString((DataItem)((DataItem)poolMetadataDataItems.get(0)));
            metadataHash = CborSerializationUtil.toHex((DataItem)((DataItem)poolMetadataDataItems.get(1)));
        }
        PoolRegistration poolRegistration = PoolRegistration.builder().operator(operator).vrfKeyHash(vrfKeyHash).pledge(pledge).cost(cost).margin(margin).rewardAccount(rewardAccount).poolOwners(poolOwners).relays(relays).poolMetadataUrl(metadataUrl).poolMetadataHash(metadataHash).build();
        return poolRegistration;
    }

    private static Relay deserializeRelay(DataItem relayDI) throws CborDeserializationException, CborException {
        List relayItems = ((Array)relayDI).getDataItems();
        int type = CborSerializationUtil.toInt((DataItem)((DataItem)relayItems.get(0)));
        int port = 0;
        String dns = null;
        if (type == 0) {
            Inet4Address ipv4 = null;
            Inet6Address ipv6 = null;
            DataItem itemDI = (DataItem)relayItems.get(1);
            port = itemDI != SimpleValue.NULL ? Integer.valueOf(CborSerializationUtil.toInt((DataItem)itemDI)) : null;
            itemDI = (DataItem)relayItems.get(2);
            if (itemDI != SimpleValue.NULL) {
                byte[] ipv4Bytes = CborSerializationUtil.toBytes((DataItem)itemDI);
                try {
                    ipv4 = (Inet4Address)Inet4Address.getByAddress(ipv4Bytes);
                }
                catch (Exception ex) {
                    throw new CborDeserializationException("Unable to convert byte[] to ipv4 address, {}, cbor: {}" + HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)relayDI)), ex);
                }
            }
            if ((itemDI = (DataItem)relayItems.get(3)) != SimpleValue.NULL) {
                byte[] ipv6Bytes = CborSerializationUtil.toBytes((DataItem)itemDI);
                try {
                    ipv6 = (Inet6Address)Inet6Address.getByAddress(ipv6Bytes);
                }
                catch (Exception ex) {
                    throw new CborDeserializationException("Unable to convert byte[] to ipv6 address, {}, cbor: {}" + HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)relayDI)), ex);
                }
            }
            return new SingleHostAddr(port, ipv4, ipv6);
        }
        if (type == 1) {
            DataItem itemDI = (DataItem)relayItems.get(1);
            port = itemDI != SimpleValue.NULL ? Integer.valueOf(CborSerializationUtil.toInt((DataItem)itemDI)) : null;
            itemDI = (DataItem)relayItems.get(2);
            dns = itemDI != SimpleValue.NULL ? CborSerializationUtil.toUnicodeString((DataItem)itemDI) : null;
            return new SingleHostName(port, dns);
        }
        if (type == 2) {
            DataItem itemDI = (DataItem)relayItems.get(1);
            dns = itemDI != SimpleValue.NULL ? CborSerializationUtil.toUnicodeString((DataItem)itemDI) : null;
            return new MultiHostName(dns);
        }
        throw new CborDeserializationException("Relay deserialization failed. Invalid type : " + type);
    }

    public static PoolRegistration deserialize(String cborHex) {
        DataItem dataItem = CborSerializationUtil.deserialize((byte[])HexUtil.decodeHexString((String)cborHex));
        try {
            return PoolRegistration.deserialize(dataItem);
        }
        catch (CborDeserializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    @JsonIgnore
    public String getBech32PoolId() {
        Objects.requireNonNull(this.operator, "Operator cannot be null");
        return StakePoolId.fromHexPoolId(HexUtil.encodeHexString((byte[])this.operator)).getBech32PoolId();
    }

    public String toString() {
        return "PoolRegistration{type=" + this.type + ", operator=" + (this.operator != null ? HexUtil.encodeHexString((byte[])this.operator) : null) + ", vrfKeyHash=" + (this.vrfKeyHash != null ? HexUtil.encodeHexString((byte[])this.vrfKeyHash) : null) + ", pledge=" + this.pledge + ", cost=" + this.cost + ", margin=" + this.margin + ", rewardAccount='" + this.rewardAccount + "', poolOwners=" + this.poolOwners + ", relays=" + this.relays + ", poolMetadataUrl='" + this.poolMetadataUrl + "', poolMetadataHash='" + this.poolMetadataHash + "'}";
    }

    public static PoolRegistrationBuilder builder() {
        return new PoolRegistrationBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public byte[] getOperator() {
        return this.operator;
    }

    public byte[] getVrfKeyHash() {
        return this.vrfKeyHash;
    }

    public BigInteger getPledge() {
        return this.pledge;
    }

    public BigInteger getCost() {
        return this.cost;
    }

    public UnitInterval getMargin() {
        return this.margin;
    }

    public String getRewardAccount() {
        return this.rewardAccount;
    }

    public Set<String> getPoolOwners() {
        return this.poolOwners;
    }

    public List<Relay> getRelays() {
        return this.relays;
    }

    public String getPoolMetadataUrl() {
        return this.poolMetadataUrl;
    }

    public String getPoolMetadataHash() {
        return this.poolMetadataHash;
    }

    public void setOperator(byte[] operator) {
        this.operator = operator;
    }

    public void setVrfKeyHash(byte[] vrfKeyHash) {
        this.vrfKeyHash = vrfKeyHash;
    }

    public void setPledge(BigInteger pledge) {
        this.pledge = pledge;
    }

    public void setCost(BigInteger cost) {
        this.cost = cost;
    }

    public void setMargin(UnitInterval margin) {
        this.margin = margin;
    }

    public void setRewardAccount(String rewardAccount) {
        this.rewardAccount = rewardAccount;
    }

    public void setPoolOwners(Set<String> poolOwners) {
        this.poolOwners = poolOwners;
    }

    public void setRelays(List<Relay> relays) {
        this.relays = relays;
    }

    public void setPoolMetadataUrl(String poolMetadataUrl) {
        this.poolMetadataUrl = poolMetadataUrl;
    }

    public void setPoolMetadataHash(String poolMetadataHash) {
        this.poolMetadataHash = poolMetadataHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PoolRegistration)) {
            return false;
        }
        PoolRegistration other = (PoolRegistration)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        if (!Arrays.equals(this.getOperator(), other.getOperator())) {
            return false;
        }
        if (!Arrays.equals(this.getVrfKeyHash(), other.getVrfKeyHash())) {
            return false;
        }
        BigInteger this$pledge = this.getPledge();
        BigInteger other$pledge = other.getPledge();
        if (this$pledge == null ? other$pledge != null : !((Object)this$pledge).equals(other$pledge)) {
            return false;
        }
        BigInteger this$cost = this.getCost();
        BigInteger other$cost = other.getCost();
        if (this$cost == null ? other$cost != null : !((Object)this$cost).equals(other$cost)) {
            return false;
        }
        UnitInterval this$margin = this.getMargin();
        UnitInterval other$margin = other.getMargin();
        if (this$margin == null ? other$margin != null : !this$margin.equals(other$margin)) {
            return false;
        }
        String this$rewardAccount = this.getRewardAccount();
        String other$rewardAccount = other.getRewardAccount();
        if (this$rewardAccount == null ? other$rewardAccount != null : !this$rewardAccount.equals(other$rewardAccount)) {
            return false;
        }
        Set<String> this$poolOwners = this.getPoolOwners();
        Set<String> other$poolOwners = other.getPoolOwners();
        if (this$poolOwners == null ? other$poolOwners != null : !((Object)this$poolOwners).equals(other$poolOwners)) {
            return false;
        }
        List<Relay> this$relays = this.getRelays();
        List<Relay> other$relays = other.getRelays();
        if (this$relays == null ? other$relays != null : !((Object)this$relays).equals(other$relays)) {
            return false;
        }
        String this$poolMetadataUrl = this.getPoolMetadataUrl();
        String other$poolMetadataUrl = other.getPoolMetadataUrl();
        if (this$poolMetadataUrl == null ? other$poolMetadataUrl != null : !this$poolMetadataUrl.equals(other$poolMetadataUrl)) {
            return false;
        }
        String this$poolMetadataHash = this.getPoolMetadataHash();
        String other$poolMetadataHash = other.getPoolMetadataHash();
        return !(this$poolMetadataHash == null ? other$poolMetadataHash != null : !this$poolMetadataHash.equals(other$poolMetadataHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PoolRegistration;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        result = result * 59 + Arrays.hashCode(this.getOperator());
        result = result * 59 + Arrays.hashCode(this.getVrfKeyHash());
        BigInteger $pledge = this.getPledge();
        result = result * 59 + ($pledge == null ? 43 : ((Object)$pledge).hashCode());
        BigInteger $cost = this.getCost();
        result = result * 59 + ($cost == null ? 43 : ((Object)$cost).hashCode());
        UnitInterval $margin = this.getMargin();
        result = result * 59 + ($margin == null ? 43 : $margin.hashCode());
        String $rewardAccount = this.getRewardAccount();
        result = result * 59 + ($rewardAccount == null ? 43 : $rewardAccount.hashCode());
        Set<String> $poolOwners = this.getPoolOwners();
        result = result * 59 + ($poolOwners == null ? 43 : ((Object)$poolOwners).hashCode());
        List<Relay> $relays = this.getRelays();
        result = result * 59 + ($relays == null ? 43 : ((Object)$relays).hashCode());
        String $poolMetadataUrl = this.getPoolMetadataUrl();
        result = result * 59 + ($poolMetadataUrl == null ? 43 : $poolMetadataUrl.hashCode());
        String $poolMetadataHash = this.getPoolMetadataHash();
        result = result * 59 + ($poolMetadataHash == null ? 43 : $poolMetadataHash.hashCode());
        return result;
    }

    public PoolRegistration(byte[] operator, byte[] vrfKeyHash, BigInteger pledge, BigInteger cost, UnitInterval margin, String rewardAccount, Set<String> poolOwners, List<Relay> relays, String poolMetadataUrl, String poolMetadataHash) {
        this.operator = operator;
        this.vrfKeyHash = vrfKeyHash;
        this.pledge = pledge;
        this.cost = cost;
        this.margin = margin;
        this.rewardAccount = rewardAccount;
        this.poolOwners = poolOwners;
        this.relays = relays;
        this.poolMetadataUrl = poolMetadataUrl;
        this.poolMetadataHash = poolMetadataHash;
    }

    public PoolRegistration() {
    }

    public static class PoolRegistrationBuilder {
        private byte[] operator;
        private byte[] vrfKeyHash;
        private BigInteger pledge;
        private BigInteger cost;
        private UnitInterval margin;
        private String rewardAccount;
        private Set<String> poolOwners;
        private List<Relay> relays;
        private String poolMetadataUrl;
        private String poolMetadataHash;

        PoolRegistrationBuilder() {
        }

        public PoolRegistrationBuilder operator(byte[] operator) {
            this.operator = operator;
            return this;
        }

        public PoolRegistrationBuilder vrfKeyHash(byte[] vrfKeyHash) {
            this.vrfKeyHash = vrfKeyHash;
            return this;
        }

        public PoolRegistrationBuilder pledge(BigInteger pledge) {
            this.pledge = pledge;
            return this;
        }

        public PoolRegistrationBuilder cost(BigInteger cost) {
            this.cost = cost;
            return this;
        }

        public PoolRegistrationBuilder margin(UnitInterval margin) {
            this.margin = margin;
            return this;
        }

        public PoolRegistrationBuilder rewardAccount(String rewardAccount) {
            this.rewardAccount = rewardAccount;
            return this;
        }

        public PoolRegistrationBuilder poolOwners(Set<String> poolOwners) {
            this.poolOwners = poolOwners;
            return this;
        }

        public PoolRegistrationBuilder relays(List<Relay> relays) {
            this.relays = relays;
            return this;
        }

        public PoolRegistrationBuilder poolMetadataUrl(String poolMetadataUrl) {
            this.poolMetadataUrl = poolMetadataUrl;
            return this;
        }

        public PoolRegistrationBuilder poolMetadataHash(String poolMetadataHash) {
            this.poolMetadataHash = poolMetadataHash;
            return this;
        }

        public PoolRegistration build() {
            return new PoolRegistration(this.operator, this.vrfKeyHash, this.pledge, this.cost, this.margin, this.rewardAccount, this.poolOwners, this.relays, this.poolMetadataUrl, this.poolMetadataHash);
        }

        public String toString() {
            return "PoolRegistration.PoolRegistrationBuilder(operator=" + Arrays.toString(this.operator) + ", vrfKeyHash=" + Arrays.toString(this.vrfKeyHash) + ", pledge=" + this.pledge + ", cost=" + this.cost + ", margin=" + this.margin + ", rewardAccount=" + this.rewardAccount + ", poolOwners=" + this.poolOwners + ", relays=" + this.relays + ", poolMetadataUrl=" + this.poolMetadataUrl + ", poolMetadataHash=" + this.poolMetadataHash + ")";
        }
    }
}

