/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Script;
import com.bloxbean.cardano.client.transaction.spec.script.RequireTimeAfter;
import com.bloxbean.cardano.client.transaction.spec.script.RequireTimeBefore;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAll;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAny;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptAtLeast;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptPubkey;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.bloxbean.cardano.client.transaction.util.NativeScriptDeserializer;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import java.util.List;

@JsonDeserialize(using=NativeScriptDeserializer.class)
public interface NativeScript
extends Script {
    public static NativeScript deserialize(Array nativeScriptArray) throws CborDeserializationException {
        List dataItemList = nativeScriptArray.getDataItems();
        if (dataItemList == null || dataItemList.size() == 0) {
            throw new CborDeserializationException("NativeScript deserialization failed. Invalid no of DataItem");
        }
        int type = ((UnsignedInteger)dataItemList.get(0)).getValue().intValue();
        if (type == 0) {
            return ScriptPubkey.deserialize(nativeScriptArray);
        }
        if (type == 1) {
            return ScriptAll.deserialize(nativeScriptArray);
        }
        if (type == 2) {
            return ScriptAny.deserialize(nativeScriptArray);
        }
        if (type == 3) {
            return ScriptAtLeast.deserialize(nativeScriptArray);
        }
        if (type == 4) {
            return RequireTimeAfter.deserialize(nativeScriptArray);
        }
        if (type == 5) {
            return RequireTimeBefore.deserialize(nativeScriptArray);
        }
        return null;
    }

    default public byte[] serializeScriptBody() throws CborSerializationException {
        DataItem di = this.serializeAsDataItem();
        try {
            return CborSerializationUtil.serialize((DataItem)di);
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serializaion error", (Exception)((Object)e));
        }
    }

    default public byte[] getScriptTypeBytes() {
        return new byte[]{(byte)this.getScriptType()};
    }

    default public int getScriptType() {
        return 0;
    }

    public static NativeScript deserializeJson(String jsonContent) throws CborDeserializationException, JsonProcessingException {
        return NativeScript.deserialize(JsonUtil.parseJson((String)jsonContent));
    }

    public static NativeScript deserialize(JsonNode jsonNode) throws CborDeserializationException {
        NativeScript nativeScript;
        String type = jsonNode.get("type").asText();
        switch (ScriptType.valueOf(type)) {
            case sig: {
                nativeScript = ScriptPubkey.deserialize(jsonNode);
                break;
            }
            case all: {
                nativeScript = ScriptAll.deserialize(jsonNode);
                break;
            }
            case any: {
                nativeScript = ScriptAny.deserialize(jsonNode);
                break;
            }
            case atLeast: {
                nativeScript = ScriptAtLeast.deserialize(jsonNode);
                break;
            }
            case after: {
                nativeScript = RequireTimeAfter.deserialize(jsonNode);
                break;
            }
            case before: {
                nativeScript = RequireTimeBefore.deserialize(jsonNode);
                break;
            }
            default: {
                throw new RuntimeException("Unknown script type");
            }
        }
        return nativeScript;
    }
}

