/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.script;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.crypto.Keys;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.bloxbean.cardano.client.transaction.spec.script.ScriptType;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.Tuple;
import com.fasterxml.jackson.databind.JsonNode;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ScriptPubkey
implements NativeScript {
    private static final Logger log = LoggerFactory.getLogger(ScriptPubkey.class);
    private final ScriptType type = ScriptType.sig;
    private String keyHash;

    public ScriptPubkey(String keyHash) {
        this.keyHash = keyHash;
    }

    public byte[] toBytes() {
        if (this.keyHash == null || this.keyHash.length() == 0) {
            return new byte[0];
        }
        byte[] keyHashBytes = new byte[]{};
        try {
            keyHashBytes = HexUtil.decodeHexString((String)this.keyHash);
        }
        catch (Exception e) {
            log.error("Error ", (Throwable)e);
        }
        return keyHashBytes;
    }

    public DataItem serializeAsDataItem() {
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(0L));
        array.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.keyHash)));
        return array;
    }

    public static ScriptPubkey deserialize(Array array) throws CborDeserializationException {
        ScriptPubkey scriptPubkey = new ScriptPubkey();
        ByteString keyHashBS = (ByteString)array.getDataItems().get(1);
        scriptPubkey.setKeyHash(HexUtil.encodeHexString((byte[])keyHashBS.getBytes()));
        return scriptPubkey;
    }

    public static ScriptPubkey deserialize(JsonNode jsonNode) throws CborDeserializationException {
        ScriptPubkey scriptPubkey = new ScriptPubkey();
        String keyHash = jsonNode.get("keyHash").asText();
        scriptPubkey.setKeyHash(keyHash);
        return scriptPubkey;
    }

    public static ScriptPubkey create(VerificationKey vkey) {
        return new ScriptPubkey(KeyGenUtil.getKeyHash((VerificationKey)vkey));
    }

    public static Tuple<ScriptPubkey, Keys> createWithNewKey() throws CborSerializationException {
        Keys keys = KeyGenUtil.generateKey();
        ScriptPubkey scriptPubkey = ScriptPubkey.create(keys.getVkey());
        return new Tuple((Object)scriptPubkey, (Object)keys);
    }

    public ScriptType getType() {
        return this.type;
    }

    public String getKeyHash() {
        return this.keyHash;
    }

    public void setKeyHash(String keyHash) {
        this.keyHash = keyHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ScriptPubkey)) {
            return false;
        }
        ScriptPubkey other = (ScriptPubkey)o;
        if (!other.canEqual(this)) {
            return false;
        }
        ScriptType this$type = this.getType();
        ScriptType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$keyHash = this.getKeyHash();
        String other$keyHash = other.getKeyHash();
        return !(this$keyHash == null ? other$keyHash != null : !this$keyHash.equals(other$keyHash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ScriptPubkey;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        ScriptType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $keyHash = this.getKeyHash();
        result = result * 59 + ($keyHash == null ? 43 : $keyHash.hashCode());
        return result;
    }

    public String toString() {
        return "ScriptPubkey(type=" + this.getType() + ", keyHash=" + this.getKeyHash() + ")";
    }

    public ScriptPubkey() {
    }
}

