/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import com.bloxbean.cardano.client.metadata.Metadata;
import com.bloxbean.cardano.client.metadata.helper.MetadataToJsonNoSchemaConverter;
import com.bloxbean.cardano.client.util.HexUtil;
import com.bloxbean.cardano.client.util.JsonUtil;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.std.StdSerializer;
import java.io.IOException;

class MetadataJacksonSerializer
extends StdSerializer<Metadata> {
    public MetadataJacksonSerializer() {
        this(null);
    }

    public MetadataJacksonSerializer(Class<Metadata> t) {
        super(t);
    }

    public void serialize(Metadata metadata, JsonGenerator gen, SerializerProvider provider) throws IOException {
        gen.writeStartObject();
        try {
            String json = MetadataToJsonNoSchemaConverter.cborBytesToJson((byte[])metadata.serialize());
            JsonNode jsonNode = JsonUtil.parseJson((String)json);
            gen.writeFieldName("json_metadata");
            gen.writeObject((Object)jsonNode);
        }
        catch (Exception json) {
            // empty catch block
        }
        try {
            String cborHex = HexUtil.encodeHexString((byte[])metadata.serialize());
            gen.writeFieldName("cbor_metadata");
            gen.writeString(cborHex);
        }
        catch (Exception exception) {
            // empty catch block
        }
        gen.writeEndObject();
    }
}

