/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.spec.EraSerializationConfig;
import com.bloxbean.cardano.client.transaction.spec.cert.AuthCommitteeHotCert;
import com.bloxbean.cardano.client.transaction.spec.cert.GenesisKeyDelegation;
import com.bloxbean.cardano.client.transaction.spec.cert.MoveInstataneous;
import com.bloxbean.cardano.client.transaction.spec.cert.PoolRegistration;
import com.bloxbean.cardano.client.transaction.spec.cert.PoolRetirement;
import com.bloxbean.cardano.client.transaction.spec.cert.RegCert;
import com.bloxbean.cardano.client.transaction.spec.cert.RegDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.ResignCommitteeColdCert;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeDelegation;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeDeregistration;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeRegDelegCert;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeRegistration;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeVoteDelegCert;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeVoteRegDelegCert;
import com.bloxbean.cardano.client.transaction.spec.cert.UnregCert;
import com.bloxbean.cardano.client.transaction.spec.cert.UnregDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.UpdateDRepCert;
import com.bloxbean.cardano.client.transaction.spec.cert.VoteDelegCert;
import com.bloxbean.cardano.client.transaction.spec.cert.VoteRegDelegCert;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;
import java.util.Objects;

public interface Certificate {
    public static Certificate deserialize(Array certArray) throws CborDeserializationException {
        Certificate certificate;
        Objects.requireNonNull(certArray);
        List dataItemList = certArray.getDataItems();
        if (dataItemList == null || dataItemList.size() < 2) {
            throw new CborDeserializationException("Certificate deserialization failed. Invalid number of DataItem(s) : " + (dataItemList != null ? String.valueOf(dataItemList.size()) : null));
        }
        UnsignedInteger typeUI = (UnsignedInteger)dataItemList.get(0);
        int type = typeUI.getValue().intValue();
        switch (type) {
            case 0: {
                certificate = StakeRegistration.deserialize(certArray);
                break;
            }
            case 1: {
                certificate = StakeDeregistration.deserialize(certArray);
                break;
            }
            case 2: {
                certificate = StakeDelegation.deserialize(certArray);
                break;
            }
            case 3: {
                certificate = PoolRegistration.deserialize((DataItem)certArray);
                break;
            }
            case 4: {
                certificate = PoolRetirement.deserialize(certArray);
                break;
            }
            case 5: {
                certificate = GenesisKeyDelegation.deserialize(certArray);
                break;
            }
            case 6: {
                certificate = MoveInstataneous.deserialize(certArray);
                break;
            }
            case 7: {
                certificate = RegCert.deserialize(certArray);
                break;
            }
            case 8: {
                certificate = UnregCert.deserialize(certArray);
                break;
            }
            case 9: {
                certificate = VoteDelegCert.deserialize(certArray);
                break;
            }
            case 10: {
                certificate = StakeVoteDelegCert.deserialize((DataItem)certArray);
                break;
            }
            case 11: {
                certificate = StakeRegDelegCert.deserialize(certArray);
                break;
            }
            case 12: {
                certificate = VoteRegDelegCert.deserialize(certArray);
                break;
            }
            case 13: {
                certificate = StakeVoteRegDelegCert.deserialize(certArray);
                break;
            }
            case 14: {
                certificate = AuthCommitteeHotCert.deserialize(certArray);
                break;
            }
            case 15: {
                certificate = ResignCommitteeColdCert.deserialize((DataItem)certArray);
                break;
            }
            case 16: {
                certificate = RegDRepCert.deserialize((DataItem)certArray);
                break;
            }
            case 17: {
                certificate = UnregDRepCert.deserialize((DataItem)certArray);
                break;
            }
            case 18: {
                certificate = UpdateDRepCert.deserialize((DataItem)certArray);
                break;
            }
            default: {
                throw new CborDeserializationException("Certificate deserialization failed. Unknown type : " + type);
            }
        }
        return certificate;
    }

    default public Array serialize() throws CborSerializationException {
        return this.serialize(EraSerializationConfig.INSTANCE.getEra());
    }

    public Array serialize(Era var1) throws CborSerializationException;

    default public String getCborHex() throws CborSerializationException {
        try {
            return HexUtil.encodeHexString((byte[])CborSerializationUtil.serialize((DataItem)this.serialize()));
        }
        catch (CborException e) {
            throw new CborSerializationException("Cbor serialization error", (Exception)((Object)e));
        }
    }
}

