/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.transaction.spec.governance.DRepType;
import com.bloxbean.cardano.client.util.HexUtil;
import java.util.List;

public class DRep {
    private DRepType type;
    private String hash;

    public static DRep addrKeyHash(String addrKeyHash) {
        DRep drep = new DRep();
        drep.type = DRepType.ADDR_KEYHASH;
        drep.hash = addrKeyHash;
        return drep;
    }

    public static DRep scriptHash(byte[] scriptHash) {
        return DRep.scriptHash(HexUtil.encodeHexString((byte[])scriptHash));
    }

    public static DRep scriptHash(String scriptHash) {
        DRep drep = new DRep();
        drep.type = DRepType.SCRIPTHASH;
        drep.hash = scriptHash;
        return drep;
    }

    public static DRep abstain() {
        DRep drep = new DRep();
        drep.type = DRepType.ABSTAIN;
        return drep;
    }

    public static DRep noConfidence() {
        DRep drep = new DRep();
        drep.type = DRepType.NO_CONFIDENCE;
        return drep;
    }

    public DataItem serialize() {
        Array drepArray = new Array();
        switch (this.type) {
            case ADDR_KEYHASH: {
                drepArray.add((DataItem)new UnsignedInteger(0L));
                drepArray.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.hash)));
                break;
            }
            case SCRIPTHASH: {
                drepArray.add((DataItem)new UnsignedInteger(1L));
                drepArray.add((DataItem)new ByteString(HexUtil.decodeHexString((String)this.hash)));
                break;
            }
            case ABSTAIN: {
                drepArray.add((DataItem)new UnsignedInteger(2L));
                break;
            }
            case NO_CONFIDENCE: {
                drepArray.add((DataItem)new UnsignedInteger(3L));
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid drep type: " + this.type);
            }
        }
        return drepArray;
    }

    public static DRep deserialize(DataItem di) {
        List dataItemList = ((Array)di).getDataItems();
        int key = CborSerializationUtil.toInt((DataItem)((DataItem)dataItemList.get(0)));
        switch (key) {
            case 0: {
                String addKeyHash = CborSerializationUtil.toHex((DataItem)((DataItem)dataItemList.get(1)));
                return DRep.addrKeyHash(addKeyHash);
            }
            case 1: {
                String scriptHash = CborSerializationUtil.toHex((DataItem)((DataItem)dataItemList.get(1)));
                return DRep.scriptHash(scriptHash);
            }
            case 2: {
                return DRep.abstain();
            }
            case 3: {
                return DRep.noConfidence();
            }
        }
        throw new IllegalArgumentException("Invalid Drep key: " + key);
    }

    public DRepType getType() {
        return this.type;
    }

    public String getHash() {
        return this.hash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DRep)) {
            return false;
        }
        DRep other = (DRep)o;
        if (!other.canEqual(this)) {
            return false;
        }
        DRepType this$type = this.getType();
        DRepType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        String this$hash = this.getHash();
        String other$hash = other.getHash();
        return !(this$hash == null ? other$hash != null : !this$hash.equals(other$hash));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DRep;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DRepType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        String $hash = this.getHash();
        result = result * 59 + ($hash == null ? 43 : $hash.hashCode());
        return result;
    }

    public String toString() {
        return "DRep(type=" + this.getType() + ", hash=" + this.getHash() + ")";
    }
}

