/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.util.AddressUtil;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class ProposalProcedure {
    private BigInteger deposit;
    private String rewardAccount;
    private GovAction govAction;
    private Anchor anchor;

    public DataItem serialize() {
        Objects.requireNonNull(this.deposit);
        Objects.requireNonNull(this.rewardAccount);
        Objects.requireNonNull(this.govAction);
        Objects.requireNonNull(this.anchor);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(this.deposit));
        try {
            byte[] addressBytes = AddressUtil.addressToBytes((String)this.rewardAccount);
            array.add((DataItem)new ByteString(addressBytes));
        }
        catch (AddressExcepion e) {
            throw new CborRuntimeException("Unable to get address bytes from rewardAddress", (Exception)((Object)e));
        }
        array.add(this.govAction.serialize());
        array.add(this.anchor.serialize());
        return array;
    }

    public static ProposalProcedure deserialize(DataItem di) {
        String rewardAddress;
        Array proposalProcedureArray = (Array)di;
        List diList = proposalProcedureArray.getDataItems();
        BigInteger deposit = CborSerializationUtil.getBigInteger((DataItem)((DataItem)diList.get(0)));
        try {
            rewardAddress = AddressUtil.bytesToAddress((byte[])((ByteString)diList.get(1)).getBytes());
        }
        catch (Exception e) {
            throw new CborRuntimeException("Bytes cannot be converted to bech32 reward address", e);
        }
        GovAction govAction = GovAction.deserialize((Array)diList.get(2));
        Anchor anchor = Anchor.deserialize((Array)diList.get(3));
        return new ProposalProcedure(deposit, rewardAddress, govAction, anchor);
    }

    public static ProposalProcedureBuilder builder() {
        return new ProposalProcedureBuilder();
    }

    public BigInteger getDeposit() {
        return this.deposit;
    }

    public String getRewardAccount() {
        return this.rewardAccount;
    }

    public GovAction getGovAction() {
        return this.govAction;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setDeposit(BigInteger deposit) {
        this.deposit = deposit;
    }

    public void setRewardAccount(String rewardAccount) {
        this.rewardAccount = rewardAccount;
    }

    public void setGovAction(GovAction govAction) {
        this.govAction = govAction;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ProposalProcedure)) {
            return false;
        }
        ProposalProcedure other = (ProposalProcedure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        BigInteger this$deposit = this.getDeposit();
        BigInteger other$deposit = other.getDeposit();
        if (this$deposit == null ? other$deposit != null : !((Object)this$deposit).equals(other$deposit)) {
            return false;
        }
        String this$rewardAccount = this.getRewardAccount();
        String other$rewardAccount = other.getRewardAccount();
        if (this$rewardAccount == null ? other$rewardAccount != null : !this$rewardAccount.equals(other$rewardAccount)) {
            return false;
        }
        GovAction this$govAction = this.getGovAction();
        GovAction other$govAction = other.getGovAction();
        if (this$govAction == null ? other$govAction != null : !this$govAction.equals(other$govAction)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ProposalProcedure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        BigInteger $deposit = this.getDeposit();
        result = result * 59 + ($deposit == null ? 43 : ((Object)$deposit).hashCode());
        String $rewardAccount = this.getRewardAccount();
        result = result * 59 + ($rewardAccount == null ? 43 : $rewardAccount.hashCode());
        GovAction $govAction = this.getGovAction();
        result = result * 59 + ($govAction == null ? 43 : $govAction.hashCode());
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        return result;
    }

    public String toString() {
        return "ProposalProcedure(deposit=" + this.getDeposit() + ", rewardAccount=" + this.getRewardAccount() + ", govAction=" + this.getGovAction() + ", anchor=" + this.getAnchor() + ")";
    }

    public ProposalProcedure(BigInteger deposit, String rewardAccount, GovAction govAction, Anchor anchor) {
        this.deposit = deposit;
        this.rewardAccount = rewardAccount;
        this.govAction = govAction;
        this.anchor = anchor;
    }

    public ProposalProcedure() {
    }

    public static class ProposalProcedureBuilder {
        private BigInteger deposit;
        private String rewardAccount;
        private GovAction govAction;
        private Anchor anchor;

        ProposalProcedureBuilder() {
        }

        public ProposalProcedureBuilder deposit(BigInteger deposit) {
            this.deposit = deposit;
            return this;
        }

        public ProposalProcedureBuilder rewardAccount(String rewardAccount) {
            this.rewardAccount = rewardAccount;
            return this;
        }

        public ProposalProcedureBuilder govAction(GovAction govAction) {
            this.govAction = govAction;
            return this;
        }

        public ProposalProcedureBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public ProposalProcedure build() {
            return new ProposalProcedure(this.deposit, this.rewardAccount, this.govAction, this.anchor);
        }

        public String toString() {
            return "ProposalProcedure.ProposalProcedureBuilder(deposit=" + this.deposit + ", rewardAccount=" + this.rewardAccount + ", govAction=" + this.govAction + ", anchor=" + this.anchor + ")";
        }
    }
}

