/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;

public enum Vote {
    NO(0),
    YES(1),
    ABSTAIN(2);

    private final int value;

    private Vote(int value) {
        this.value = value;
    }

    public DataItem serialize() {
        return new UnsignedInteger((long)this.value);
    }

    public static Vote deserialize(UnsignedInteger voteDI) {
        int vote = voteDI.getValue().intValue();
        switch (vote) {
            case 0: {
                return NO;
            }
            case 1: {
                return YES;
            }
            case 2: {
                return ABSTAIN;
            }
        }
        throw new IllegalArgumentException("Invalid vote. Expected 0,1,2. Found : " + vote);
    }
}

