/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.spec.EraSerializationConfig;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.HardForkInitiationAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.InfoAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.NewConstitution;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.NoConfidence;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.ParameterChangeAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.TreasuryWithdrawalsAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.UpdateCommittee;

public interface GovAction {
    public GovActionType getType();

    public static GovAction deserialize(Array govActionArray) {
        DataItem fistItem = (DataItem)govActionArray.getDataItems().get(0);
        int actionType = CborSerializationUtil.toInt((DataItem)fistItem);
        switch (actionType) {
            case 0: {
                return ParameterChangeAction.deserialize(govActionArray);
            }
            case 1: {
                return HardForkInitiationAction.deserialize(govActionArray);
            }
            case 2: {
                return TreasuryWithdrawalsAction.deserialize(govActionArray);
            }
            case 3: {
                return NoConfidence.deserialize(govActionArray);
            }
            case 4: {
                return UpdateCommittee.deserialize(govActionArray);
            }
            case 5: {
                return NewConstitution.deserialize(govActionArray);
            }
            case 6: {
                return new InfoAction();
            }
        }
        throw new IllegalArgumentException("GovAction is not a valid type : " + actionType);
    }

    public static GovActionId getGovActionId(DataItem actionIdDI) {
        GovActionId govActionId = actionIdDI == SimpleValue.NULL ? null : GovActionId.deserialize(actionIdDI);
        return govActionId;
    }

    default public DataItem serialize() {
        return this.serialize(EraSerializationConfig.INSTANCE.getEra());
    }

    public DataItem serialize(Era var1);
}

