/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.Number;
import co.nstant.in.cbor.model.RationalNumber;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.spec.UnitInterval;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import com.bloxbean.cardano.client.transaction.util.RationalNumberUtil;
import com.bloxbean.cardano.client.transaction.util.SerializationUtil;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public class UpdateCommittee
implements GovAction {
    private final GovActionType type = GovActionType.UPDATE_COMMITTEE;
    private GovActionId prevGovActionId;
    private Set<Credential> membersForRemoval;
    private java.util.Map<Credential, Integer> newMembersAndTerms;
    private UnitInterval quorumThreshold;

    public Array serialize(Era era) {
        Objects.requireNonNull(this.membersForRemoval);
        Objects.requireNonNull(this.newMembersAndTerms);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(4L));
        if (this.prevGovActionId != null) {
            array.add(this.prevGovActionId.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        Array membersForRemovalArray = SerializationUtil.createArray(era);
        for (Credential member : this.membersForRemoval) {
            membersForRemovalArray.add((DataItem)CredentialSerializer.serialize(member));
        }
        array.add((DataItem)membersForRemovalArray);
        Map newMembersTermsMap = new Map();
        for (Map.Entry<Credential, Integer> newMemberTerm : this.newMembersAndTerms.entrySet()) {
            newMembersTermsMap.put((DataItem)CredentialSerializer.serialize(newMemberTerm.getKey()), (DataItem)new UnsignedInteger((long)newMemberTerm.getValue().intValue()));
        }
        array.add((DataItem)newMembersTermsMap);
        array.add((DataItem)new RationalNumber((Number)new UnsignedInteger(this.quorumThreshold.getNumerator()), (Number)new UnsignedInteger(this.quorumThreshold.getDenominator())));
        return array;
    }

    public static UpdateCommittee deserialize(Array govActionArray) {
        List govActionDIList = govActionArray.getDataItems();
        DataItem actionIdDI = (DataItem)govActionDIList.get(1);
        GovActionId govActionId = GovAction.getGovActionId(actionIdDI);
        List committeeColdCredArray = ((Array)govActionDIList.get(2)).getDataItems();
        LinkedHashSet<Credential> committeeColdCredSet = new LinkedHashSet<Credential>();
        committeeColdCredArray.stream().map(coldCredDI -> CredentialSerializer.deserialize((Array)coldCredDI)).forEach(coldCred -> committeeColdCredSet.add((Credential)coldCred));
        LinkedHashMap<Credential, Integer> committeeColdCredEpochMap = new LinkedHashMap<Credential, Integer>();
        Map committeeColdCredEpochMapDI = (Map)govActionDIList.get(3);
        for (DataItem key : committeeColdCredEpochMapDI.getKeys()) {
            Credential cred = CredentialSerializer.deserialize((Array)key);
            int epoch = CborSerializationUtil.toInt((DataItem)committeeColdCredEpochMapDI.get(key));
            committeeColdCredEpochMap.put(cred, epoch);
        }
        UnitInterval unitInterval = RationalNumberUtil.toUnitInterval((RationalNumber)govActionDIList.get(4));
        return new UpdateCommittee(govActionId, committeeColdCredSet, committeeColdCredEpochMap, unitInterval);
    }

    private static Set<Credential> $default$membersForRemoval() {
        return new LinkedHashSet<Credential>();
    }

    private static java.util.Map<Credential, Integer> $default$newMembersAndTerms() {
        return new LinkedHashMap<Credential, Integer>();
    }

    public static UpdateCommitteeBuilder builder() {
        return new UpdateCommitteeBuilder();
    }

    @Override
    public GovActionType getType() {
        return this.type;
    }

    public GovActionId getPrevGovActionId() {
        return this.prevGovActionId;
    }

    public Set<Credential> getMembersForRemoval() {
        return this.membersForRemoval;
    }

    public java.util.Map<Credential, Integer> getNewMembersAndTerms() {
        return this.newMembersAndTerms;
    }

    public UnitInterval getQuorumThreshold() {
        return this.quorumThreshold;
    }

    public void setPrevGovActionId(GovActionId prevGovActionId) {
        this.prevGovActionId = prevGovActionId;
    }

    public void setMembersForRemoval(Set<Credential> membersForRemoval) {
        this.membersForRemoval = membersForRemoval;
    }

    public void setNewMembersAndTerms(java.util.Map<Credential, Integer> newMembersAndTerms) {
        this.newMembersAndTerms = newMembersAndTerms;
    }

    public void setQuorumThreshold(UnitInterval quorumThreshold) {
        this.quorumThreshold = quorumThreshold;
    }

    public UpdateCommittee(GovActionId prevGovActionId, Set<Credential> membersForRemoval, java.util.Map<Credential, Integer> newMembersAndTerms, UnitInterval quorumThreshold) {
        this.prevGovActionId = prevGovActionId;
        this.membersForRemoval = membersForRemoval;
        this.newMembersAndTerms = newMembersAndTerms;
        this.quorumThreshold = quorumThreshold;
    }

    public UpdateCommittee() {
        this.membersForRemoval = UpdateCommittee.$default$membersForRemoval();
        this.newMembersAndTerms = UpdateCommittee.$default$newMembersAndTerms();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateCommittee)) {
            return false;
        }
        UpdateCommittee other = (UpdateCommittee)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GovActionType this$type = this.getType();
        GovActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        GovActionId this$prevGovActionId = this.getPrevGovActionId();
        GovActionId other$prevGovActionId = other.getPrevGovActionId();
        if (this$prevGovActionId == null ? other$prevGovActionId != null : !((Object)this$prevGovActionId).equals(other$prevGovActionId)) {
            return false;
        }
        Set<Credential> this$membersForRemoval = this.getMembersForRemoval();
        Set<Credential> other$membersForRemoval = other.getMembersForRemoval();
        if (this$membersForRemoval == null ? other$membersForRemoval != null : !((Object)this$membersForRemoval).equals(other$membersForRemoval)) {
            return false;
        }
        java.util.Map<Credential, Integer> this$newMembersAndTerms = this.getNewMembersAndTerms();
        java.util.Map<Credential, Integer> other$newMembersAndTerms = other.getNewMembersAndTerms();
        if (this$newMembersAndTerms == null ? other$newMembersAndTerms != null : !((Object)this$newMembersAndTerms).equals(other$newMembersAndTerms)) {
            return false;
        }
        UnitInterval this$quorumThreshold = this.getQuorumThreshold();
        UnitInterval other$quorumThreshold = other.getQuorumThreshold();
        return !(this$quorumThreshold == null ? other$quorumThreshold != null : !this$quorumThreshold.equals(other$quorumThreshold));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateCommittee;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GovActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        GovActionId $prevGovActionId = this.getPrevGovActionId();
        result = result * 59 + ($prevGovActionId == null ? 43 : ((Object)$prevGovActionId).hashCode());
        Set<Credential> $membersForRemoval = this.getMembersForRemoval();
        result = result * 59 + ($membersForRemoval == null ? 43 : ((Object)$membersForRemoval).hashCode());
        java.util.Map<Credential, Integer> $newMembersAndTerms = this.getNewMembersAndTerms();
        result = result * 59 + ($newMembersAndTerms == null ? 43 : ((Object)$newMembersAndTerms).hashCode());
        UnitInterval $quorumThreshold = this.getQuorumThreshold();
        result = result * 59 + ($quorumThreshold == null ? 43 : $quorumThreshold.hashCode());
        return result;
    }

    public String toString() {
        return "UpdateCommittee(type=" + this.getType() + ", prevGovActionId=" + this.getPrevGovActionId() + ", membersForRemoval=" + this.getMembersForRemoval() + ", newMembersAndTerms=" + this.getNewMembersAndTerms() + ", quorumThreshold=" + this.getQuorumThreshold() + ")";
    }

    public static class UpdateCommitteeBuilder {
        private GovActionId prevGovActionId;
        private boolean membersForRemoval$set;
        private Set<Credential> membersForRemoval$value;
        private boolean newMembersAndTerms$set;
        private java.util.Map<Credential, Integer> newMembersAndTerms$value;
        private UnitInterval quorumThreshold;

        UpdateCommitteeBuilder() {
        }

        public UpdateCommitteeBuilder prevGovActionId(GovActionId prevGovActionId) {
            this.prevGovActionId = prevGovActionId;
            return this;
        }

        public UpdateCommitteeBuilder membersForRemoval(Set<Credential> membersForRemoval) {
            this.membersForRemoval$value = membersForRemoval;
            this.membersForRemoval$set = true;
            return this;
        }

        public UpdateCommitteeBuilder newMembersAndTerms(java.util.Map<Credential, Integer> newMembersAndTerms) {
            this.newMembersAndTerms$value = newMembersAndTerms;
            this.newMembersAndTerms$set = true;
            return this;
        }

        public UpdateCommitteeBuilder quorumThreshold(UnitInterval quorumThreshold) {
            this.quorumThreshold = quorumThreshold;
            return this;
        }

        public UpdateCommittee build() {
            Set<Credential> membersForRemoval$value = this.membersForRemoval$value;
            if (!this.membersForRemoval$set) {
                membersForRemoval$value = UpdateCommittee.$default$membersForRemoval();
            }
            java.util.Map<Credential, Integer> newMembersAndTerms$value = this.newMembersAndTerms$value;
            if (!this.newMembersAndTerms$set) {
                newMembersAndTerms$value = UpdateCommittee.$default$newMembersAndTerms();
            }
            return new UpdateCommittee(this.prevGovActionId, membersForRemoval$value, newMembersAndTerms$value, this.quorumThreshold);
        }

        public String toString() {
            return "UpdateCommittee.UpdateCommitteeBuilder(prevGovActionId=" + this.prevGovActionId + ", membersForRemoval$value=" + this.membersForRemoval$value + ", newMembersAndTerms$value=" + this.newMembersAndTerms$value + ", quorumThreshold=" + this.quorumThreshold + ")";
        }
    }
}

