/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.util;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import com.bloxbean.cardano.client.crypto.bip32.util.BytesUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.util.Tuple;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Arrays;

public class TransactionBytes {
    private byte[] initialBytes;
    private byte[] txBodyBytes;
    private byte[] txWitnessBytes;
    private byte[] validBytes;
    private byte[] auxiliaryDataBytes;

    public TransactionBytes(byte[] txBytes) {
        this.extractTransactionBytesFromTx(txBytes);
    }

    private TransactionBytes(byte[] initialBytes, byte[] txBodyBytes, byte[] txWitnessBytes, byte[] validBytes, byte[] auxiliaryDataBytes) {
        this.initialBytes = initialBytes;
        this.txBodyBytes = txBodyBytes;
        this.txWitnessBytes = txWitnessBytes;
        this.validBytes = validBytes;
        this.auxiliaryDataBytes = auxiliaryDataBytes;
    }

    public byte[] getTxBytes() {
        if (this.validBytes == null) {
            return BytesUtil.merge((byte[][])new byte[][]{this.initialBytes, this.txBodyBytes, this.txWitnessBytes, this.auxiliaryDataBytes});
        }
        return BytesUtil.merge((byte[][])new byte[][]{this.initialBytes, this.txBodyBytes, this.txWitnessBytes, this.validBytes, this.auxiliaryDataBytes});
    }

    public TransactionBytes withNewWitnessSetBytes(byte[] witnessBytes) {
        return new TransactionBytes(this.initialBytes, this.txBodyBytes, witnessBytes, this.validBytes, this.auxiliaryDataBytes);
    }

    private TransactionBytes extractTransactionBytesFromTx(byte[] txBytes) {
        if (txBytes == null || txBytes.length == 0) {
            throw new IllegalArgumentException("Transaction bytes can't be null or empty");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(txBytes);
        CborDecoder decoder = new CborDecoder((InputStream)bais);
        byte tag = (byte)bais.read();
        this.initialBytes = new byte[]{tag};
        this.txBodyBytes = (byte[])TransactionBytes.nextElementBytes((byte[])txBytes, (int)1, (CborDecoder)decoder, (ByteArrayInputStream)bais)._1;
        int nextPos = 1 + this.txBodyBytes.length;
        this.txWitnessBytes = (byte[])TransactionBytes.nextElementBytes((byte[])txBytes, (int)nextPos, (CborDecoder)decoder, (ByteArrayInputStream)bais)._1;
        Tuple<byte[], DataItem> nextElmTupel = TransactionBytes.nextElementBytes(txBytes, nextPos += this.txWitnessBytes.length, decoder, bais);
        this.validBytes = null;
        this.auxiliaryDataBytes = null;
        if (nextElmTupel._2 == SimpleValue.TRUE || nextElmTupel._2 == SimpleValue.FALSE) {
            this.validBytes = (byte[])nextElmTupel._1;
            this.auxiliaryDataBytes = (byte[])TransactionBytes.nextElementBytes((byte[])txBytes, (int)(nextPos += this.validBytes.length), (CborDecoder)decoder, (ByteArrayInputStream)bais)._1;
        } else {
            this.auxiliaryDataBytes = (byte[])nextElmTupel._1;
        }
        return this;
    }

    private static Tuple<byte[], DataItem> nextElementBytes(byte[] txBytes, int startPos, CborDecoder decoder, ByteArrayInputStream bais) {
        DataItem dataItem;
        try {
            dataItem = decoder.decodeNext();
        }
        catch (CborException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
        int available = bais.available();
        byte[] txBodyRaw = new byte[txBytes.length - available - startPos];
        System.arraycopy(txBytes, startPos, txBodyRaw, 0, txBodyRaw.length);
        return new Tuple((Object)txBodyRaw, (Object)dataItem);
    }

    public byte[] getInitialBytes() {
        return this.initialBytes;
    }

    public byte[] getTxBodyBytes() {
        return this.txBodyBytes;
    }

    public byte[] getTxWitnessBytes() {
        return this.txWitnessBytes;
    }

    public byte[] getValidBytes() {
        return this.validBytes;
    }

    public byte[] getAuxiliaryDataBytes() {
        return this.auxiliaryDataBytes;
    }

    public void setInitialBytes(byte[] initialBytes) {
        this.initialBytes = initialBytes;
    }

    public void setTxBodyBytes(byte[] txBodyBytes) {
        this.txBodyBytes = txBodyBytes;
    }

    public void setTxWitnessBytes(byte[] txWitnessBytes) {
        this.txWitnessBytes = txWitnessBytes;
    }

    public void setValidBytes(byte[] validBytes) {
        this.validBytes = validBytes;
    }

    public void setAuxiliaryDataBytes(byte[] auxiliaryDataBytes) {
        this.auxiliaryDataBytes = auxiliaryDataBytes;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TransactionBytes)) {
            return false;
        }
        TransactionBytes other = (TransactionBytes)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getInitialBytes(), other.getInitialBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getTxBodyBytes(), other.getTxBodyBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getTxWitnessBytes(), other.getTxWitnessBytes())) {
            return false;
        }
        if (!Arrays.equals(this.getValidBytes(), other.getValidBytes())) {
            return false;
        }
        return Arrays.equals(this.getAuxiliaryDataBytes(), other.getAuxiliaryDataBytes());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TransactionBytes;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getInitialBytes());
        result = result * 59 + Arrays.hashCode(this.getTxBodyBytes());
        result = result * 59 + Arrays.hashCode(this.getTxWitnessBytes());
        result = result * 59 + Arrays.hashCode(this.getValidBytes());
        result = result * 59 + Arrays.hashCode(this.getAuxiliaryDataBytes());
        return result;
    }

    public String toString() {
        return "TransactionBytes(initialBytes=" + Arrays.toString(this.getInitialBytes()) + ", txBodyBytes=" + Arrays.toString(this.getTxBodyBytes()) + ", txWitnessBytes=" + Arrays.toString(this.getTxWitnessBytes()) + ", validBytes=" + Arrays.toString(this.getValidBytes()) + ", auxiliaryDataBytes=" + Arrays.toString(this.getAuxiliaryDataBytes()) + ")";
    }
}

