/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.util;

import co.nstant.in.cbor.CborDecoder;
import co.nstant.in.cbor.CborException;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.util.HexUtil;
import java.io.ByteArrayInputStream;
import java.io.InputStream;

public class TransactionUtil {
    public static Transaction createCopy(Transaction transaction) {
        try {
            Transaction cloneTxn = Transaction.deserialize(transaction.serialize());
            cloneTxn.setEra(transaction.getEra());
            return cloneTxn;
        }
        catch (CborDeserializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }

    public static String getTxHash(Transaction transaction) {
        try {
            byte[] txBytes = transaction.serialize();
            return TransactionUtil.getTxHash(txBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException("Get transaction hash failed. ", ex);
        }
    }

    public static String getTxHash(byte[] transactionBytes) {
        try {
            byte[] txBodyBytes = TransactionUtil.extractTransactionBodyFromTx(transactionBytes);
            return TransactionUtil.safeGetTxHash(txBodyBytes);
        }
        catch (Exception ex) {
            throw new RuntimeException("Get transaction hash failed. ", ex);
        }
    }

    public static byte[] extractTransactionBodyFromTx(byte[] txBytes) {
        if (txBytes == null || txBytes.length == 0) {
            throw new IllegalArgumentException("Transaction bytes can't be null or empty");
        }
        ByteArrayInputStream bais = new ByteArrayInputStream(txBytes);
        CborDecoder decoder = new CborDecoder((InputStream)bais);
        bais.read();
        try {
            decoder.decodeNext();
        }
        catch (CborException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
        int available = bais.available();
        byte[] txBodyRaw = new byte[txBytes.length - available - 1];
        System.arraycopy(txBytes, 1, txBodyRaw, 0, txBodyRaw.length);
        return txBodyRaw;
    }

    private static String safeGetTxHash(byte[] txBodyBytes) {
        return HexUtil.encodeHexString((byte[])Blake2bUtil.blake2bHash256((byte[])txBodyBytes));
    }
}

