/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import java.util.List;

public class Nonce {
    private byte[] hash;

    public DataItem serialize() throws CborSerializationException {
        Array array = new Array();
        if (this.hash != null) {
            array.add((DataItem)new UnsignedInteger(1L));
            array.add((DataItem)new ByteString(this.hash));
        } else {
            array.add((DataItem)new UnsignedInteger(0L));
        }
        return array;
    }

    public static Nonce deserialize(DataItem di) throws CborDeserializationException {
        if (di == null) {
            return null;
        }
        List dataItemList = ((Array)di).getDataItems();
        int i = CborSerializationUtil.toInt((DataItem)((DataItem)dataItemList.get(0)));
        if (i == 0) {
            return new Nonce(null);
        }
        if (i == 1) {
            byte[] hash = CborSerializationUtil.toBytes((DataItem)((DataItem)dataItemList.get(1)));
            return new Nonce(hash);
        }
        throw new CborDeserializationException("Nonce deserialization failed. No variant matched. i=" + i);
    }

    public byte[] getHash() {
        return this.hash;
    }

    public Nonce(byte[] hash) {
        this.hash = hash;
    }
}

