/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction;

import co.nstant.in.cbor.CborException;
import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.crypto.Blake2bUtil;
import com.bloxbean.cardano.client.crypto.KeyGenUtil;
import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.crypto.VerificationKey;
import com.bloxbean.cardano.client.crypto.api.SigningProvider;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyGenerator;
import com.bloxbean.cardano.client.crypto.bip32.HdKeyPair;
import com.bloxbean.cardano.client.crypto.config.CryptoConfiguration;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.Transaction;
import com.bloxbean.cardano.client.transaction.util.TransactionBytes;
import lombok.NonNull;

public enum TransactionSigner {
    INSTANCE;


    public Transaction sign(@NonNull Transaction transaction, @NonNull HdKeyPair hdKeyPair) {
        if (transaction == null) {
            throw new NullPointerException("transaction is marked non-null but is null");
        }
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
        try {
            byte[] signedTxBytes = this.sign(transaction.serialize(), hdKeyPair);
            Transaction signedTx = Transaction.deserialize(signedTxBytes);
            signedTx.setEra(transaction.getEra());
            return signedTx;
        }
        catch (CborDeserializationException | CborSerializationException e) {
            throw new CborRuntimeException((Exception)e);
        }
    }

    public Transaction sign(Transaction transaction, SecretKey secretKey) {
        try {
            byte[] signedTxBytes = this.sign(transaction.serialize(), secretKey);
            Transaction signedTx = Transaction.deserialize(signedTxBytes);
            signedTx.setEra(transaction.getEra());
            return signedTx;
        }
        catch (CborDeserializationException | CborSerializationException e) {
            throw new CborRuntimeException((Exception)e);
        }
    }

    public byte[] sign(@NonNull byte[] txBytes, @NonNull HdKeyPair hdKeyPair) {
        if (txBytes == null) {
            throw new NullPointerException("txBytes is marked non-null but is null");
        }
        if (hdKeyPair == null) {
            throw new NullPointerException("hdKeyPair is marked non-null but is null");
        }
        TransactionBytes transactionBytes = new TransactionBytes(txBytes);
        byte[] txnBodyHash = Blake2bUtil.blake2bHash256((byte[])transactionBytes.getTxBodyBytes());
        SigningProvider signingProvider = CryptoConfiguration.INSTANCE.getSigningProvider();
        byte[] signature = signingProvider.signExtended(txnBodyHash, hdKeyPair.getPrivateKey().getKeyData(), hdKeyPair.getPublicKey().getKeyData());
        byte[] signedTransaction = this.addWitnessToTransaction(transactionBytes, hdKeyPair.getPublicKey().getKeyData(), signature);
        return signedTransaction;
    }

    public byte[] sign(@NonNull byte[] transactionBytes, @NonNull SecretKey secretKey) {
        VerificationKey verificationKey;
        byte[] signature;
        if (transactionBytes == null) {
            throw new NullPointerException("transactionBytes is marked non-null but is null");
        }
        if (secretKey == null) {
            throw new NullPointerException("secretKey is marked non-null but is null");
        }
        TransactionBytes txBytes = new TransactionBytes(transactionBytes);
        byte[] txnBodyHash = Blake2bUtil.blake2bHash256((byte[])txBytes.getTxBodyBytes());
        SigningProvider signingProvider = CryptoConfiguration.INSTANCE.getSigningProvider();
        if (secretKey.getBytes().length == 64) {
            byte[] vBytes = HdKeyGenerator.getPublicKey((byte[])secretKey.getBytes());
            signature = signingProvider.signExtended(txnBodyHash, secretKey.getBytes(), vBytes);
            try {
                verificationKey = VerificationKey.create((byte[])vBytes);
            }
            catch (CborSerializationException e) {
                throw new CborRuntimeException("Unable to get verification key from secret key", (Exception)((Object)e));
            }
        }
        signature = signingProvider.sign(txnBodyHash, secretKey.getBytes());
        try {
            verificationKey = KeyGenUtil.getPublicKeyFromPrivateKey((SecretKey)secretKey);
        }
        catch (CborSerializationException e) {
            throw new CborRuntimeException("Unable to get verification key from SecretKey", (Exception)((Object)e));
        }
        byte[] signedTransaction = this.addWitnessToTransaction(txBytes, verificationKey.getBytes(), signature);
        return signedTransaction;
    }

    private byte[] addWitnessToTransaction(TransactionBytes transactionBytes, byte[] vkey, byte[] signature) {
        try {
            Array vkWitnessArray;
            DataItem witnessSetDI = CborSerializationUtil.deserialize((byte[])transactionBytes.getTxWitnessBytes());
            Map witnessSetMap = (Map)witnessSetDI;
            DataItem vkWitnessArrayDI = witnessSetMap.get((DataItem)new UnsignedInteger(0L));
            if (vkWitnessArrayDI != null) {
                vkWitnessArray = (Array)vkWitnessArrayDI;
            } else {
                vkWitnessArray = new Array();
                witnessSetMap.put((DataItem)new UnsignedInteger(0L), (DataItem)vkWitnessArray);
            }
            Array vkeyWitness = new Array();
            vkeyWitness.add((DataItem)new ByteString(vkey));
            vkeyWitness.add((DataItem)new ByteString(signature));
            vkWitnessArray.add((DataItem)vkeyWitness);
            byte[] txWitnessBytes = CborSerializationUtil.serialize((DataItem)witnessSetMap, (boolean)false);
            return transactionBytes.withNewWitnessSetBytes(txWitnessBytes).getTxBytes();
        }
        catch (CborException e) {
            throw new CborRuntimeException((Exception)((Object)e));
        }
    }
}

