/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import java.util.List;
import java.util.Objects;

public class AuthCommitteeHotCert
implements Certificate {
    private final CertificateType type = CertificateType.AUTH_COMMITTEE_HOT_CERT;
    private Credential committeeColdCredential;
    private Credential committeeHotCredential;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.committeeColdCredential);
        Objects.requireNonNull(this.committeeHotCredential);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)CredentialSerializer.serialize(this.committeeColdCredential));
        certArray.add((DataItem)CredentialSerializer.serialize(this.committeeHotCredential));
        return certArray;
    }

    public static AuthCommitteeHotCert deserialize(Array certArray) {
        List dataItemList = certArray.getDataItems();
        Credential committeeColdCred = CredentialSerializer.deserialize((Array)dataItemList.get(1));
        Credential committeeHotCred = CredentialSerializer.deserialize((Array)dataItemList.get(2));
        return new AuthCommitteeHotCert(committeeColdCred, committeeHotCred);
    }

    public static AuthCommitteeHotCertBuilder builder() {
        return new AuthCommitteeHotCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public Credential getCommitteeColdCredential() {
        return this.committeeColdCredential;
    }

    public Credential getCommitteeHotCredential() {
        return this.committeeHotCredential;
    }

    public void setCommitteeColdCredential(Credential committeeColdCredential) {
        this.committeeColdCredential = committeeColdCredential;
    }

    public void setCommitteeHotCredential(Credential committeeHotCredential) {
        this.committeeHotCredential = committeeHotCredential;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuthCommitteeHotCert)) {
            return false;
        }
        AuthCommitteeHotCert other = (AuthCommitteeHotCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$committeeColdCredential = this.getCommitteeColdCredential();
        Credential other$committeeColdCredential = other.getCommitteeColdCredential();
        if (this$committeeColdCredential == null ? other$committeeColdCredential != null : !this$committeeColdCredential.equals(other$committeeColdCredential)) {
            return false;
        }
        Credential this$committeeHotCredential = this.getCommitteeHotCredential();
        Credential other$committeeHotCredential = other.getCommitteeHotCredential();
        return !(this$committeeHotCredential == null ? other$committeeHotCredential != null : !this$committeeHotCredential.equals(other$committeeHotCredential));
    }

    protected boolean canEqual(Object other) {
        return other instanceof AuthCommitteeHotCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $committeeColdCredential = this.getCommitteeColdCredential();
        result = result * 59 + ($committeeColdCredential == null ? 43 : $committeeColdCredential.hashCode());
        Credential $committeeHotCredential = this.getCommitteeHotCredential();
        result = result * 59 + ($committeeHotCredential == null ? 43 : $committeeHotCredential.hashCode());
        return result;
    }

    public String toString() {
        return "AuthCommitteeHotCert(type=" + this.getType() + ", committeeColdCredential=" + this.getCommitteeColdCredential() + ", committeeHotCredential=" + this.getCommitteeHotCredential() + ")";
    }

    public AuthCommitteeHotCert(Credential committeeColdCredential, Credential committeeHotCredential) {
        this.committeeColdCredential = committeeColdCredential;
        this.committeeHotCredential = committeeHotCredential;
    }

    public AuthCommitteeHotCert() {
    }

    public static class AuthCommitteeHotCertBuilder {
        private Credential committeeColdCredential;
        private Credential committeeHotCredential;

        AuthCommitteeHotCertBuilder() {
        }

        public AuthCommitteeHotCertBuilder committeeColdCredential(Credential committeeColdCredential) {
            this.committeeColdCredential = committeeColdCredential;
            return this;
        }

        public AuthCommitteeHotCertBuilder committeeHotCredential(Credential committeeHotCredential) {
            this.committeeHotCredential = committeeHotCredential;
            return this;
        }

        public AuthCommitteeHotCert build() {
            return new AuthCommitteeHotCert(this.committeeColdCredential, this.committeeHotCredential);
        }

        public String toString() {
            return "AuthCommitteeHotCert.AuthCommitteeHotCertBuilder(committeeColdCredential=" + this.committeeColdCredential + ", committeeHotCredential=" + this.committeeHotCredential + ")";
        }
    }
}

