/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.util.AddressUtil;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborRuntimeException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.Withdrawal;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;

public class TreasuryWithdrawalsAction
implements GovAction {
    private final GovActionType type = GovActionType.TREASURY_WITHDRAWALS_ACTION;
    private List<Withdrawal> withdrawals;
    private byte[] policyHash;

    public void addWithdrawal(Withdrawal withdrawal) {
        if (this.withdrawals == null) {
            this.withdrawals = new ArrayList<Withdrawal>();
        }
        this.withdrawals.add(withdrawal);
    }

    public Array serialize(Era era) {
        Objects.requireNonNull(this.withdrawals);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(2L));
        Map withdrawalMap = new Map();
        for (Withdrawal withdrawal : this.withdrawals) {
            withdrawal.serialize(withdrawalMap);
        }
        array.add((DataItem)withdrawalMap);
        if (this.policyHash != null && this.policyHash.length > 0) {
            if (this.policyHash.length != 28) {
                throw new IllegalArgumentException("Policy hash length should be 28 bytes");
            }
            array.add((DataItem)new ByteString(this.policyHash));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static TreasuryWithdrawalsAction deserialize(Array govActionArray) {
        List govActionDIList = govActionArray.getDataItems();
        Map map = (Map)govActionDIList.get(1);
        ArrayList<Withdrawal> withdrawals = new ArrayList<Withdrawal>();
        Collection keys = map.getKeys();
        for (DataItem key : keys) {
            String rewardAddress;
            try {
                rewardAddress = AddressUtil.bytesToAddress((byte[])CborSerializationUtil.toBytes((DataItem)key));
            }
            catch (Exception e) {
                throw new CborRuntimeException("Bytes cannot be converted to bech32 address", e);
            }
            BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)map.get(key));
            withdrawals.add(new Withdrawal(rewardAddress, coin));
        }
        DataItem policyHashDI = (DataItem)govActionDIList.get(2);
        byte[] policyHash = null;
        if (policyHashDI != SimpleValue.NULL) {
            policyHash = ((ByteString)policyHashDI).getBytes();
        }
        return new TreasuryWithdrawalsAction(withdrawals, policyHash);
    }

    private static List<Withdrawal> $default$withdrawals() {
        return new ArrayList<Withdrawal>();
    }

    public static TreasuryWithdrawalsActionBuilder builder() {
        return new TreasuryWithdrawalsActionBuilder();
    }

    @Override
    public GovActionType getType() {
        return this.type;
    }

    public List<Withdrawal> getWithdrawals() {
        return this.withdrawals;
    }

    public byte[] getPolicyHash() {
        return this.policyHash;
    }

    public void setWithdrawals(List<Withdrawal> withdrawals) {
        this.withdrawals = withdrawals;
    }

    public void setPolicyHash(byte[] policyHash) {
        this.policyHash = policyHash;
    }

    public TreasuryWithdrawalsAction(List<Withdrawal> withdrawals, byte[] policyHash) {
        this.withdrawals = withdrawals;
        this.policyHash = policyHash;
    }

    public TreasuryWithdrawalsAction() {
        this.withdrawals = TreasuryWithdrawalsAction.$default$withdrawals();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof TreasuryWithdrawalsAction)) {
            return false;
        }
        TreasuryWithdrawalsAction other = (TreasuryWithdrawalsAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GovActionType this$type = this.getType();
        GovActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        List<Withdrawal> this$withdrawals = this.getWithdrawals();
        List<Withdrawal> other$withdrawals = other.getWithdrawals();
        if (this$withdrawals == null ? other$withdrawals != null : !((Object)this$withdrawals).equals(other$withdrawals)) {
            return false;
        }
        return Arrays.equals(this.getPolicyHash(), other.getPolicyHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof TreasuryWithdrawalsAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GovActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        List<Withdrawal> $withdrawals = this.getWithdrawals();
        result = result * 59 + ($withdrawals == null ? 43 : ((Object)$withdrawals).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPolicyHash());
        return result;
    }

    public String toString() {
        return "TreasuryWithdrawalsAction(type=" + this.getType() + ", withdrawals=" + this.getWithdrawals() + ", policyHash=" + Arrays.toString(this.getPolicyHash()) + ")";
    }

    public static class TreasuryWithdrawalsActionBuilder {
        private boolean withdrawals$set;
        private List<Withdrawal> withdrawals$value;
        private byte[] policyHash;

        TreasuryWithdrawalsActionBuilder() {
        }

        public TreasuryWithdrawalsActionBuilder withdrawals(List<Withdrawal> withdrawals) {
            this.withdrawals$value = withdrawals;
            this.withdrawals$set = true;
            return this;
        }

        public TreasuryWithdrawalsActionBuilder policyHash(byte[] policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        public TreasuryWithdrawalsAction build() {
            List<Withdrawal> withdrawals$value = this.withdrawals$value;
            if (!this.withdrawals$set) {
                withdrawals$value = TreasuryWithdrawalsAction.$default$withdrawals();
            }
            return new TreasuryWithdrawalsAction(withdrawals$value, this.policyHash);
        }

        public String toString() {
            return "TreasuryWithdrawalsAction.TreasuryWithdrawalsActionBuilder(withdrawals$value=" + this.withdrawals$value + ", policyHash=" + Arrays.toString(this.policyHash) + ")";
        }
    }
}

