/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class RegDRepCert
implements Certificate {
    private final CertificateType type = CertificateType.REG_DREP_CERT;
    private Credential drepCredential;
    private BigInteger coin;
    private Anchor anchor;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.drepCredential);
        Objects.requireNonNull(this.coin);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)CredentialSerializer.serialize(this.drepCredential));
        certArray.add((DataItem)new UnsignedInteger(this.coin));
        if (this.anchor != null) {
            certArray.add(this.anchor.serialize());
        } else {
            certArray.add((DataItem)SimpleValue.NULL);
        }
        return certArray;
    }

    public static RegDRepCert deserialize(DataItem di) {
        Array certArray = (Array)di;
        List dataItemList = certArray.getDataItems();
        Credential drepCred = CredentialSerializer.deserialize((Array)dataItemList.get(1));
        BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(2)));
        DataItem anchorDI = (DataItem)dataItemList.get(3);
        Anchor anchor = null;
        if (anchorDI != SimpleValue.NULL) {
            anchor = Anchor.deserialize((Array)anchorDI);
        }
        return new RegDRepCert(drepCred, coin, anchor);
    }

    public static RegDRepCertBuilder builder() {
        return new RegDRepCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public Credential getDrepCredential() {
        return this.drepCredential;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public RegDRepCert(Credential drepCredential, BigInteger coin, Anchor anchor) {
        this.drepCredential = drepCredential;
        this.coin = coin;
        this.anchor = anchor;
    }

    public RegDRepCert() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RegDRepCert)) {
            return false;
        }
        RegDRepCert other = (RegDRepCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$drepCredential = this.getDrepCredential();
        Credential other$drepCredential = other.getDrepCredential();
        if (this$drepCredential == null ? other$drepCredential != null : !this$drepCredential.equals(other$drepCredential)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        if (this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof RegDRepCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $drepCredential = this.getDrepCredential();
        result = result * 59 + ($drepCredential == null ? 43 : $drepCredential.hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        return result;
    }

    public String toString() {
        return "RegDRepCert(type=" + this.getType() + ", drepCredential=" + this.getDrepCredential() + ", coin=" + this.getCoin() + ", anchor=" + this.getAnchor() + ")";
    }

    public static class RegDRepCertBuilder {
        private Credential drepCredential;
        private BigInteger coin;
        private Anchor anchor;

        RegDRepCertBuilder() {
        }

        public RegDRepCertBuilder drepCredential(Credential drepCredential) {
            this.drepCredential = drepCredential;
            return this;
        }

        public RegDRepCertBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public RegDRepCertBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public RegDRepCert build() {
            return new RegDRepCert(this.drepCredential, this.coin, this.anchor);
        }

        public String toString() {
            return "RegDRepCert.RegDRepCertBuilder(drepCredential=" + this.drepCredential + ", coin=" + this.coin + ", anchor=" + this.anchor + ")";
        }
    }
}

