/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import java.math.BigInteger;
import java.util.List;
import java.util.Objects;

public class UnregDRepCert
implements Certificate {
    private final CertificateType type = CertificateType.UNREG_DREP_CERT;
    private Credential drepCredential;
    private BigInteger coin;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.drepCredential);
        Objects.requireNonNull(this.coin);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)CredentialSerializer.serialize(this.drepCredential));
        certArray.add((DataItem)new UnsignedInteger(this.coin));
        return certArray;
    }

    public static UnregDRepCert deserialize(DataItem di) {
        Array certArray = (Array)di;
        List dataItemList = certArray.getDataItems();
        Credential drepCred = CredentialSerializer.deserialize((Array)dataItemList.get(1));
        BigInteger coin = CborSerializationUtil.getBigInteger((DataItem)((DataItem)dataItemList.get(2)));
        return new UnregDRepCert(drepCred, coin);
    }

    public static UnregDRepCertBuilder builder() {
        return new UnregDRepCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public Credential getDrepCredential() {
        return this.drepCredential;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public void setDrepCredential(Credential drepCredential) {
        this.drepCredential = drepCredential;
    }

    public void setCoin(BigInteger coin) {
        this.coin = coin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UnregDRepCert)) {
            return false;
        }
        UnregDRepCert other = (UnregDRepCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$drepCredential = this.getDrepCredential();
        Credential other$drepCredential = other.getDrepCredential();
        if (this$drepCredential == null ? other$drepCredential != null : !this$drepCredential.equals(other$drepCredential)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UnregDRepCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $drepCredential = this.getDrepCredential();
        result = result * 59 + ($drepCredential == null ? 43 : $drepCredential.hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        return result;
    }

    public String toString() {
        return "UnregDRepCert(type=" + this.getType() + ", drepCredential=" + this.getDrepCredential() + ", coin=" + this.getCoin() + ")";
    }

    public UnregDRepCert(Credential drepCredential, BigInteger coin) {
        this.drepCredential = drepCredential;
        this.coin = coin;
    }

    public UnregDRepCert() {
    }

    public static class UnregDRepCertBuilder {
        private Credential drepCredential;
        private BigInteger coin;

        UnregDRepCertBuilder() {
        }

        public UnregDRepCertBuilder drepCredential(Credential drepCredential) {
            this.drepCredential = drepCredential;
            return this;
        }

        public UnregDRepCertBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public UnregDRepCert build() {
            return new UnregDRepCert(this.drepCredential, this.coin);
        }

        public String toString() {
            return "UnregDRepCert.UnregDRepCertBuilder(drepCredential=" + this.drepCredential + ", coin=" + this.coin + ")";
        }
    }
}

