/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.spec.governance.Vote;
import java.util.List;
import java.util.Objects;

public class VotingProcedure {
    private Vote vote;
    private Anchor anchor;

    public DataItem serialize() {
        Objects.requireNonNull(this.vote);
        Array array = new Array();
        array.add(this.vote.serialize());
        if (this.anchor != null) {
            array.add(this.anchor.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static VotingProcedure deserialize(Array array) {
        if (array != null && array.getDataItems().size() != 2) {
            throw new IllegalArgumentException("Invalid voting_procedure array. Expected 2 items. Found : " + array.getDataItems().size());
        }
        List diList = array.getDataItems();
        Vote vote = Vote.deserialize((UnsignedInteger)diList.get(0));
        Anchor anchor = diList.get(1) == SimpleValue.NULL ? null : Anchor.deserialize((Array)diList.get(1));
        return new VotingProcedure(vote, anchor);
    }

    public static VotingProcedureBuilder builder() {
        return new VotingProcedureBuilder();
    }

    public Vote getVote() {
        return this.vote;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setVote(Vote vote) {
        this.vote = vote;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VotingProcedure)) {
            return false;
        }
        VotingProcedure other = (VotingProcedure)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Vote this$vote = this.getVote();
        Vote other$vote = other.getVote();
        if (this$vote == null ? other$vote != null : !((Object)((Object)this$vote)).equals((Object)other$vote)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VotingProcedure;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Vote $vote = this.getVote();
        result = result * 59 + ($vote == null ? 43 : ((Object)((Object)$vote)).hashCode());
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        return result;
    }

    public String toString() {
        return "VotingProcedure(vote=" + this.getVote() + ", anchor=" + this.getAnchor() + ")";
    }

    public VotingProcedure(Vote vote, Anchor anchor) {
        this.vote = vote;
        this.anchor = anchor;
    }

    public VotingProcedure() {
    }

    public static class VotingProcedureBuilder {
        private Vote vote;
        private Anchor anchor;

        VotingProcedureBuilder() {
        }

        public VotingProcedureBuilder vote(Vote vote) {
            this.vote = vote;
            return this;
        }

        public VotingProcedureBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public VotingProcedure build() {
            return new VotingProcedure(this.vote, this.anchor);
        }

        public String toString() {
            return "VotingProcedure.VotingProcedureBuilder(vote=" + this.vote + ", anchor=" + this.anchor + ")";
        }
    }
}

