/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.ProtocolParamUpdate;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;

public class ParameterChangeAction
implements GovAction {
    private final GovActionType type = GovActionType.PARAMETER_CHANGE_ACTION;
    private GovActionId prevGovActionId;
    private ProtocolParamUpdate protocolParamUpdate;
    private byte[] policyHash;

    public Array serialize(Era era) {
        Objects.requireNonNull(this.protocolParamUpdate);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(0L));
        if (this.prevGovActionId != null) {
            array.add(this.prevGovActionId.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        array.add(this.protocolParamUpdate.serialize());
        if (this.policyHash != null && this.policyHash.length > 0) {
            if (this.policyHash.length != 28) {
                throw new IllegalArgumentException("Policy hash length should be 28 bytes");
            }
            array.add((DataItem)new ByteString(this.policyHash));
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        return array;
    }

    public static GovAction deserialize(Array govActionArray) {
        List govActionDIList = govActionArray.getDataItems();
        DataItem actionIdDI = (DataItem)govActionDIList.get(1);
        GovActionId govActionId = GovAction.getGovActionId(actionIdDI);
        ProtocolParamUpdate protocolParamUpdate = ProtocolParamUpdate.deserialize((DataItem)govActionDIList.get(2));
        DataItem policyHashDI = (DataItem)govActionDIList.get(3);
        byte[] policyHash = null;
        if (policyHashDI != SimpleValue.NULL) {
            policyHash = ((ByteString)policyHashDI).getBytes();
        }
        return new ParameterChangeAction(govActionId, protocolParamUpdate, policyHash);
    }

    public static ParameterChangeActionBuilder builder() {
        return new ParameterChangeActionBuilder();
    }

    @Override
    public GovActionType getType() {
        return this.type;
    }

    public GovActionId getPrevGovActionId() {
        return this.prevGovActionId;
    }

    public ProtocolParamUpdate getProtocolParamUpdate() {
        return this.protocolParamUpdate;
    }

    public byte[] getPolicyHash() {
        return this.policyHash;
    }

    public void setPrevGovActionId(GovActionId prevGovActionId) {
        this.prevGovActionId = prevGovActionId;
    }

    public void setProtocolParamUpdate(ProtocolParamUpdate protocolParamUpdate) {
        this.protocolParamUpdate = protocolParamUpdate;
    }

    public void setPolicyHash(byte[] policyHash) {
        this.policyHash = policyHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ParameterChangeAction)) {
            return false;
        }
        ParameterChangeAction other = (ParameterChangeAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GovActionType this$type = this.getType();
        GovActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        GovActionId this$prevGovActionId = this.getPrevGovActionId();
        GovActionId other$prevGovActionId = other.getPrevGovActionId();
        if (this$prevGovActionId == null ? other$prevGovActionId != null : !((Object)this$prevGovActionId).equals(other$prevGovActionId)) {
            return false;
        }
        ProtocolParamUpdate this$protocolParamUpdate = this.getProtocolParamUpdate();
        ProtocolParamUpdate other$protocolParamUpdate = other.getProtocolParamUpdate();
        if (this$protocolParamUpdate == null ? other$protocolParamUpdate != null : !((Object)this$protocolParamUpdate).equals(other$protocolParamUpdate)) {
            return false;
        }
        return Arrays.equals(this.getPolicyHash(), other.getPolicyHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof ParameterChangeAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GovActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        GovActionId $prevGovActionId = this.getPrevGovActionId();
        result = result * 59 + ($prevGovActionId == null ? 43 : ((Object)$prevGovActionId).hashCode());
        ProtocolParamUpdate $protocolParamUpdate = this.getProtocolParamUpdate();
        result = result * 59 + ($protocolParamUpdate == null ? 43 : ((Object)$protocolParamUpdate).hashCode());
        result = result * 59 + Arrays.hashCode(this.getPolicyHash());
        return result;
    }

    public String toString() {
        return "ParameterChangeAction(type=" + this.getType() + ", prevGovActionId=" + this.getPrevGovActionId() + ", protocolParamUpdate=" + this.getProtocolParamUpdate() + ", policyHash=" + Arrays.toString(this.getPolicyHash()) + ")";
    }

    public ParameterChangeAction(GovActionId prevGovActionId, ProtocolParamUpdate protocolParamUpdate, byte[] policyHash) {
        this.prevGovActionId = prevGovActionId;
        this.protocolParamUpdate = protocolParamUpdate;
        this.policyHash = policyHash;
    }

    public ParameterChangeAction() {
    }

    public static class ParameterChangeActionBuilder {
        private GovActionId prevGovActionId;
        private ProtocolParamUpdate protocolParamUpdate;
        private byte[] policyHash;

        ParameterChangeActionBuilder() {
        }

        public ParameterChangeActionBuilder prevGovActionId(GovActionId prevGovActionId) {
            this.prevGovActionId = prevGovActionId;
            return this;
        }

        public ParameterChangeActionBuilder protocolParamUpdate(ProtocolParamUpdate protocolParamUpdate) {
            this.protocolParamUpdate = protocolParamUpdate;
            return this;
        }

        public ParameterChangeActionBuilder policyHash(byte[] policyHash) {
            this.policyHash = policyHash;
            return this;
        }

        public ParameterChangeAction build() {
            return new ParameterChangeAction(this.prevGovActionId, this.protocolParamUpdate, this.policyHash);
        }

        public String toString() {
            return "ParameterChangeAction.ParameterChangeActionBuilder(prevGovActionId=" + this.prevGovActionId + ", protocolParamUpdate=" + this.protocolParamUpdate + ", policyHash=" + Arrays.toString(this.policyHash) + ")";
        }
    }
}

