/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.Credential;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.governance.Anchor;
import com.bloxbean.cardano.client.transaction.util.CredentialSerializer;
import java.util.List;
import java.util.Objects;

public class UpdateDRepCert
implements Certificate {
    private final CertificateType type = CertificateType.UPDATE_DREP_CERT;
    private Credential drepCredential;
    private Anchor anchor;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.drepCredential);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)CredentialSerializer.serialize(this.drepCredential));
        if (this.anchor != null) {
            certArray.add(this.anchor.serialize());
        } else {
            certArray.add((DataItem)SimpleValue.NULL);
        }
        return certArray;
    }

    public static UpdateDRepCert deserialize(DataItem di) {
        Array certArray = (Array)di;
        List dataItemList = certArray.getDataItems();
        Credential drepCred = CredentialSerializer.deserialize((Array)dataItemList.get(1));
        DataItem anchorDI = (DataItem)dataItemList.get(2);
        Anchor anchor = null;
        if (anchorDI != SimpleValue.NULL) {
            anchor = Anchor.deserialize((Array)anchorDI);
        }
        return new UpdateDRepCert(drepCred, anchor);
    }

    public static UpdateDRepCertBuilder builder() {
        return new UpdateDRepCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public Credential getDrepCredential() {
        return this.drepCredential;
    }

    public Anchor getAnchor() {
        return this.anchor;
    }

    public void setDrepCredential(Credential drepCredential) {
        this.drepCredential = drepCredential;
    }

    public void setAnchor(Anchor anchor) {
        this.anchor = anchor;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof UpdateDRepCert)) {
            return false;
        }
        UpdateDRepCert other = (UpdateDRepCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        Credential this$drepCredential = this.getDrepCredential();
        Credential other$drepCredential = other.getDrepCredential();
        if (this$drepCredential == null ? other$drepCredential != null : !this$drepCredential.equals(other$drepCredential)) {
            return false;
        }
        Anchor this$anchor = this.getAnchor();
        Anchor other$anchor = other.getAnchor();
        return !(this$anchor == null ? other$anchor != null : !((Object)this$anchor).equals(other$anchor));
    }

    protected boolean canEqual(Object other) {
        return other instanceof UpdateDRepCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        Credential $drepCredential = this.getDrepCredential();
        result = result * 59 + ($drepCredential == null ? 43 : $drepCredential.hashCode());
        Anchor $anchor = this.getAnchor();
        result = result * 59 + ($anchor == null ? 43 : ((Object)$anchor).hashCode());
        return result;
    }

    public String toString() {
        return "UpdateDRepCert(type=" + this.getType() + ", drepCredential=" + this.getDrepCredential() + ", anchor=" + this.getAnchor() + ")";
    }

    public UpdateDRepCert(Credential drepCredential, Anchor anchor) {
        this.drepCredential = drepCredential;
        this.anchor = anchor;
    }

    public UpdateDRepCert() {
    }

    public static class UpdateDRepCertBuilder {
        private Credential drepCredential;
        private Anchor anchor;

        UpdateDRepCertBuilder() {
        }

        public UpdateDRepCertBuilder drepCredential(Credential drepCredential) {
            this.drepCredential = drepCredential;
            return this;
        }

        public UpdateDRepCertBuilder anchor(Anchor anchor) {
            this.anchor = anchor;
            return this;
        }

        public UpdateDRepCert build() {
            return new UpdateDRepCert(this.drepCredential, this.anchor);
        }

        public String toString() {
            return "UpdateDRepCert.UpdateDRepCertBuilder(drepCredential=" + this.drepCredential + ", anchor=" + this.anchor + ")";
        }
    }
}

