/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.cert;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.cert.Certificate;
import com.bloxbean.cardano.client.transaction.spec.cert.CertificateType;
import com.bloxbean.cardano.client.transaction.spec.cert.StakeCredential;
import com.bloxbean.cardano.client.transaction.spec.governance.DRep;
import java.util.List;
import java.util.Objects;

public class VoteDelegCert
implements Certificate {
    private final CertificateType type = CertificateType.VOTE_DELEG_CERT;
    private StakeCredential stakeCredential;
    private DRep drep;

    @Override
    public Array serialize(Era era) throws CborSerializationException {
        Objects.requireNonNull(this.stakeCredential);
        Objects.requireNonNull(this.drep);
        Array certArray = new Array();
        certArray.add((DataItem)new UnsignedInteger((long)this.type.getValue()));
        certArray.add((DataItem)this.stakeCredential.serialize());
        certArray.add(this.drep.serialize());
        return certArray;
    }

    public static VoteDelegCert deserialize(Array certArray) {
        List dataItemList = certArray.getDataItems();
        StakeCredential stakeCredential = StakeCredential.deserialize((Array)dataItemList.get(1));
        DRep drep = DRep.deserialize((DataItem)dataItemList.get(2));
        return new VoteDelegCert(stakeCredential, drep);
    }

    public static VoteDelegCertBuilder builder() {
        return new VoteDelegCertBuilder();
    }

    public CertificateType getType() {
        return this.type;
    }

    public StakeCredential getStakeCredential() {
        return this.stakeCredential;
    }

    public DRep getDrep() {
        return this.drep;
    }

    public void setStakeCredential(StakeCredential stakeCredential) {
        this.stakeCredential = stakeCredential;
    }

    public void setDrep(DRep drep) {
        this.drep = drep;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof VoteDelegCert)) {
            return false;
        }
        VoteDelegCert other = (VoteDelegCert)o;
        if (!other.canEqual(this)) {
            return false;
        }
        CertificateType this$type = this.getType();
        CertificateType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        StakeCredential this$stakeCredential = this.getStakeCredential();
        StakeCredential other$stakeCredential = other.getStakeCredential();
        if (this$stakeCredential == null ? other$stakeCredential != null : !((Object)this$stakeCredential).equals(other$stakeCredential)) {
            return false;
        }
        DRep this$drep = this.getDrep();
        DRep other$drep = other.getDrep();
        return !(this$drep == null ? other$drep != null : !((Object)this$drep).equals(other$drep));
    }

    protected boolean canEqual(Object other) {
        return other instanceof VoteDelegCert;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        CertificateType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        StakeCredential $stakeCredential = this.getStakeCredential();
        result = result * 59 + ($stakeCredential == null ? 43 : ((Object)$stakeCredential).hashCode());
        DRep $drep = this.getDrep();
        result = result * 59 + ($drep == null ? 43 : ((Object)$drep).hashCode());
        return result;
    }

    public String toString() {
        return "VoteDelegCert(type=" + this.getType() + ", stakeCredential=" + this.getStakeCredential() + ", drep=" + this.getDrep() + ")";
    }

    public VoteDelegCert(StakeCredential stakeCredential, DRep drep) {
        this.stakeCredential = stakeCredential;
        this.drep = drep;
    }

    public VoteDelegCert() {
    }

    public static class VoteDelegCertBuilder {
        private StakeCredential stakeCredential;
        private DRep drep;

        VoteDelegCertBuilder() {
        }

        public VoteDelegCertBuilder stakeCredential(StakeCredential stakeCredential) {
            this.stakeCredential = stakeCredential;
            return this;
        }

        public VoteDelegCertBuilder drep(DRep drep) {
            this.drep = drep;
            return this;
        }

        public VoteDelegCert build() {
            return new VoteDelegCert(this.stakeCredential, this.drep);
        }

        public String toString() {
            return "VoteDelegCert.VoteDelegCertBuilder(stakeCredential=" + this.stakeCredential + ", drep=" + this.drep + ")";
        }
    }
}

