/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.UnicodeString;
import com.bloxbean.cardano.client.common.cbor.CborSerializationUtil;
import java.util.Arrays;
import java.util.List;

public class Anchor {
    private String anchorUrl;
    private byte[] anchorDataHash;

    public DataItem serialize() {
        Array array = new Array();
        UnicodeString anchorUrlDI = new UnicodeString(this.anchorUrl);
        ByteString anchorDataHashDI = new ByteString(this.anchorDataHash);
        array.add((DataItem)anchorUrlDI);
        array.add((DataItem)anchorDataHashDI);
        return array;
    }

    public static Anchor deserialize(Array array) {
        if (array != null && array.getDataItems().size() != 2) {
            throw new IllegalArgumentException("Invalid anchor array. Expected 2 items. Found : " + array.getDataItems().size());
        }
        List diList = array.getDataItems();
        String anchorUrl = CborSerializationUtil.toUnicodeString((DataItem)((DataItem)diList.get(0)));
        byte[] anchorDataHash = CborSerializationUtil.toBytes((DataItem)((DataItem)diList.get(1)));
        return new Anchor(anchorUrl, anchorDataHash);
    }

    public static AnchorBuilder builder() {
        return new AnchorBuilder();
    }

    public String getAnchorUrl() {
        return this.anchorUrl;
    }

    public byte[] getAnchorDataHash() {
        return this.anchorDataHash;
    }

    public void setAnchorUrl(String anchorUrl) {
        this.anchorUrl = anchorUrl;
    }

    public void setAnchorDataHash(byte[] anchorDataHash) {
        this.anchorDataHash = anchorDataHash;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Anchor)) {
            return false;
        }
        Anchor other = (Anchor)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$anchorUrl = this.getAnchorUrl();
        String other$anchorUrl = other.getAnchorUrl();
        if (this$anchorUrl == null ? other$anchorUrl != null : !this$anchorUrl.equals(other$anchorUrl)) {
            return false;
        }
        return Arrays.equals(this.getAnchorDataHash(), other.getAnchorDataHash());
    }

    protected boolean canEqual(Object other) {
        return other instanceof Anchor;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $anchorUrl = this.getAnchorUrl();
        result = result * 59 + ($anchorUrl == null ? 43 : $anchorUrl.hashCode());
        result = result * 59 + Arrays.hashCode(this.getAnchorDataHash());
        return result;
    }

    public String toString() {
        return "Anchor(anchorUrl=" + this.getAnchorUrl() + ", anchorDataHash=" + Arrays.toString(this.getAnchorDataHash()) + ")";
    }

    public Anchor(String anchorUrl, byte[] anchorDataHash) {
        this.anchorUrl = anchorUrl;
        this.anchorDataHash = anchorDataHash;
    }

    public Anchor() {
    }

    public static class AnchorBuilder {
        private String anchorUrl;
        private byte[] anchorDataHash;

        AnchorBuilder() {
        }

        public AnchorBuilder anchorUrl(String anchorUrl) {
            this.anchorUrl = anchorUrl;
            return this;
        }

        public AnchorBuilder anchorDataHash(byte[] anchorDataHash) {
            this.anchorDataHash = anchorDataHash;
            return this;
        }

        public Anchor build() {
            return new Anchor(this.anchorUrl, this.anchorDataHash);
        }

        public String toString() {
            return "Anchor.AnchorBuilder(anchorUrl=" + this.anchorUrl + ", anchorDataHash=" + Arrays.toString(this.anchorDataHash) + ")";
        }
    }
}

