/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.ProtocolVersion;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import java.util.List;
import java.util.Objects;

public class HardForkInitiationAction
implements GovAction {
    private final GovActionType type = GovActionType.HARD_FORK_INITIATION_ACTION;
    private GovActionId prevGovActionId;
    private ProtocolVersion protocolVersion;

    public Array serialize(Era era) {
        Objects.requireNonNull(this.protocolVersion);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(1L));
        if (this.prevGovActionId != null) {
            array.add(this.prevGovActionId.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        array.add((DataItem)this.protocolVersion.serialize());
        return array;
    }

    public static HardForkInitiationAction deserialize(Array govActionArray) {
        List govActionDIList = govActionArray.getDataItems();
        DataItem actionIdDI = (DataItem)govActionDIList.get(1);
        GovActionId govActionId = GovAction.getGovActionId(actionIdDI);
        ProtocolVersion protocolVersion = ProtocolVersion.deserialize((Array)govActionDIList.get(2));
        return new HardForkInitiationAction(govActionId, protocolVersion);
    }

    public static HardForkInitiationActionBuilder builder() {
        return new HardForkInitiationActionBuilder();
    }

    @Override
    public GovActionType getType() {
        return this.type;
    }

    public GovActionId getPrevGovActionId() {
        return this.prevGovActionId;
    }

    public ProtocolVersion getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setPrevGovActionId(GovActionId prevGovActionId) {
        this.prevGovActionId = prevGovActionId;
    }

    public void setProtocolVersion(ProtocolVersion protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HardForkInitiationAction)) {
            return false;
        }
        HardForkInitiationAction other = (HardForkInitiationAction)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GovActionType this$type = this.getType();
        GovActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        GovActionId this$prevGovActionId = this.getPrevGovActionId();
        GovActionId other$prevGovActionId = other.getPrevGovActionId();
        if (this$prevGovActionId == null ? other$prevGovActionId != null : !((Object)this$prevGovActionId).equals(other$prevGovActionId)) {
            return false;
        }
        ProtocolVersion this$protocolVersion = this.getProtocolVersion();
        ProtocolVersion other$protocolVersion = other.getProtocolVersion();
        return !(this$protocolVersion == null ? other$protocolVersion != null : !((Object)this$protocolVersion).equals(other$protocolVersion));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HardForkInitiationAction;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GovActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        GovActionId $prevGovActionId = this.getPrevGovActionId();
        result = result * 59 + ($prevGovActionId == null ? 43 : ((Object)$prevGovActionId).hashCode());
        ProtocolVersion $protocolVersion = this.getProtocolVersion();
        result = result * 59 + ($protocolVersion == null ? 43 : ((Object)$protocolVersion).hashCode());
        return result;
    }

    public String toString() {
        return "HardForkInitiationAction(type=" + this.getType() + ", prevGovActionId=" + this.getPrevGovActionId() + ", protocolVersion=" + this.getProtocolVersion() + ")";
    }

    public HardForkInitiationAction(GovActionId prevGovActionId, ProtocolVersion protocolVersion) {
        this.prevGovActionId = prevGovActionId;
        this.protocolVersion = protocolVersion;
    }

    public HardForkInitiationAction() {
    }

    public static class HardForkInitiationActionBuilder {
        private GovActionId prevGovActionId;
        private ProtocolVersion protocolVersion;

        HardForkInitiationActionBuilder() {
        }

        public HardForkInitiationActionBuilder prevGovActionId(GovActionId prevGovActionId) {
            this.prevGovActionId = prevGovActionId;
            return this;
        }

        public HardForkInitiationActionBuilder protocolVersion(ProtocolVersion protocolVersion) {
            this.protocolVersion = protocolVersion;
            return this;
        }

        public HardForkInitiationAction build() {
            return new HardForkInitiationAction(this.prevGovActionId, this.protocolVersion);
        }

        public String toString() {
            return "HardForkInitiationAction.HardForkInitiationActionBuilder(prevGovActionId=" + this.prevGovActionId + ", protocolVersion=" + this.protocolVersion + ")";
        }
    }
}

