/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec.governance.actions;

import co.nstant.in.cbor.model.Array;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.SimpleValue;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.spec.Era;
import com.bloxbean.cardano.client.transaction.spec.governance.Constitution;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovAction;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionId;
import com.bloxbean.cardano.client.transaction.spec.governance.actions.GovActionType;
import java.util.List;
import java.util.Objects;

public class NewConstitution
implements GovAction {
    private final GovActionType type = GovActionType.NEW_CONSTITUTION;
    private GovActionId prevGovActionId;
    private Constitution constitution;

    public Array serialize(Era era) {
        Objects.requireNonNull(this.constitution);
        Array array = new Array();
        array.add((DataItem)new UnsignedInteger(5L));
        if (this.prevGovActionId != null) {
            array.add(this.prevGovActionId.serialize());
        } else {
            array.add((DataItem)SimpleValue.NULL);
        }
        array.add((DataItem)this.constitution.serialize());
        return array;
    }

    public static NewConstitution deserialize(Array govActionArray) {
        List govActionDIList = govActionArray.getDataItems();
        DataItem actionIdDI = (DataItem)govActionDIList.get(1);
        GovActionId govActionId = GovAction.getGovActionId(actionIdDI);
        Constitution constitution = Constitution.deserialize((Array)govActionDIList.get(2));
        return new NewConstitution(govActionId, constitution);
    }

    public static NewConstitutionBuilder builder() {
        return new NewConstitutionBuilder();
    }

    @Override
    public GovActionType getType() {
        return this.type;
    }

    public GovActionId getPrevGovActionId() {
        return this.prevGovActionId;
    }

    public Constitution getConstitution() {
        return this.constitution;
    }

    public void setPrevGovActionId(GovActionId prevGovActionId) {
        this.prevGovActionId = prevGovActionId;
    }

    public void setConstitution(Constitution constitution) {
        this.constitution = constitution;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof NewConstitution)) {
            return false;
        }
        NewConstitution other = (NewConstitution)o;
        if (!other.canEqual(this)) {
            return false;
        }
        GovActionType this$type = this.getType();
        GovActionType other$type = other.getType();
        if (this$type == null ? other$type != null : !((Object)((Object)this$type)).equals((Object)other$type)) {
            return false;
        }
        GovActionId this$prevGovActionId = this.getPrevGovActionId();
        GovActionId other$prevGovActionId = other.getPrevGovActionId();
        if (this$prevGovActionId == null ? other$prevGovActionId != null : !((Object)this$prevGovActionId).equals(other$prevGovActionId)) {
            return false;
        }
        Constitution this$constitution = this.getConstitution();
        Constitution other$constitution = other.getConstitution();
        return !(this$constitution == null ? other$constitution != null : !((Object)this$constitution).equals(other$constitution));
    }

    protected boolean canEqual(Object other) {
        return other instanceof NewConstitution;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        GovActionType $type = this.getType();
        result = result * 59 + ($type == null ? 43 : ((Object)((Object)$type)).hashCode());
        GovActionId $prevGovActionId = this.getPrevGovActionId();
        result = result * 59 + ($prevGovActionId == null ? 43 : ((Object)$prevGovActionId).hashCode());
        Constitution $constitution = this.getConstitution();
        result = result * 59 + ($constitution == null ? 43 : ((Object)$constitution).hashCode());
        return result;
    }

    public String toString() {
        return "NewConstitution(type=" + this.getType() + ", prevGovActionId=" + this.getPrevGovActionId() + ", constitution=" + this.getConstitution() + ")";
    }

    public NewConstitution(GovActionId prevGovActionId, Constitution constitution) {
        this.prevGovActionId = prevGovActionId;
        this.constitution = constitution;
    }

    public NewConstitution() {
    }

    public static class NewConstitutionBuilder {
        private GovActionId prevGovActionId;
        private Constitution constitution;

        NewConstitutionBuilder() {
        }

        public NewConstitutionBuilder prevGovActionId(GovActionId prevGovActionId) {
            this.prevGovActionId = prevGovActionId;
            return this;
        }

        public NewConstitutionBuilder constitution(Constitution constitution) {
            this.constitution = constitution;
            return this;
        }

        public NewConstitution build() {
            return new NewConstitution(this.prevGovActionId, this.constitution);
        }

        public String toString() {
            return "NewConstitution.NewConstitutionBuilder(prevGovActionId=" + this.prevGovActionId + ", constitution=" + this.constitution + ")";
        }
    }
}

