/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import com.bloxbean.cardano.client.crypto.SecretKey;
import com.bloxbean.cardano.client.exception.CborSerializationException;
import com.bloxbean.cardano.client.transaction.spec.script.NativeScript;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.util.ArrayList;
import java.util.List;

@JsonIgnoreProperties(ignoreUnknown=true)
public class Policy {
    private String name;
    private NativeScript policyScript;
    private List<SecretKey> policyKeys;

    public Policy(String name, NativeScript policyScript) {
        this.name = name;
        this.policyScript = policyScript;
    }

    public Policy(NativeScript policyScript) {
        this.policyScript = policyScript;
    }

    public Policy(NativeScript policyScript, List<SecretKey> policyKeys) {
        this.policyScript = policyScript;
        this.policyKeys = policyKeys;
    }

    public Policy addKey(SecretKey key) {
        if (this.policyKeys == null) {
            this.policyKeys = new ArrayList<SecretKey>();
        }
        this.policyKeys.add(key);
        return this;
    }

    public String getPolicyId() throws CborSerializationException {
        return this.policyScript.getPolicyId();
    }

    public String getName() {
        return this.name;
    }

    public NativeScript getPolicyScript() {
        return this.policyScript;
    }

    public List<SecretKey> getPolicyKeys() {
        return this.policyKeys;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setPolicyScript(NativeScript policyScript) {
        this.policyScript = policyScript;
    }

    public void setPolicyKeys(List<SecretKey> policyKeys) {
        this.policyKeys = policyKeys;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Policy)) {
            return false;
        }
        Policy other = (Policy)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        NativeScript this$policyScript = this.getPolicyScript();
        NativeScript other$policyScript = other.getPolicyScript();
        if (this$policyScript == null ? other$policyScript != null : !this$policyScript.equals(other$policyScript)) {
            return false;
        }
        List<SecretKey> this$policyKeys = this.getPolicyKeys();
        List<SecretKey> other$policyKeys = other.getPolicyKeys();
        return !(this$policyKeys == null ? other$policyKeys != null : !((Object)this$policyKeys).equals(other$policyKeys));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Policy;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        NativeScript $policyScript = this.getPolicyScript();
        result = result * 59 + ($policyScript == null ? 43 : $policyScript.hashCode());
        List<SecretKey> $policyKeys = this.getPolicyKeys();
        result = result * 59 + ($policyKeys == null ? 43 : ((Object)$policyKeys).hashCode());
        return result;
    }

    public String toString() {
        return "Policy(name=" + this.getName() + ", policyScript=" + String.valueOf(this.getPolicyScript()) + ", policyKeys=" + String.valueOf(this.getPolicyKeys()) + ")";
    }

    public Policy() {
    }

    public Policy(String name, NativeScript policyScript, List<SecretKey> policyKeys) {
        this.name = name;
        this.policyScript = policyScript;
        this.policyKeys = policyKeys;
    }
}

