/*
 * Decompiled with CFR 0.152.
 */
package com.bloxbean.cardano.client.transaction.spec;

import co.nstant.in.cbor.model.ByteString;
import co.nstant.in.cbor.model.DataItem;
import co.nstant.in.cbor.model.Map;
import co.nstant.in.cbor.model.UnsignedInteger;
import com.bloxbean.cardano.client.address.util.AddressUtil;
import com.bloxbean.cardano.client.exception.AddressExcepion;
import com.bloxbean.cardano.client.exception.CborDeserializationException;
import java.math.BigInteger;
import java.util.Objects;

public class Withdrawal {
    private String rewardAddress;
    private BigInteger coin;

    public static Withdrawal deserialize(Map withdrawalMap, DataItem addrKey) throws CborDeserializationException {
        String rewardAddress;
        Objects.requireNonNull(withdrawalMap);
        Objects.requireNonNull(addrKey);
        try {
            rewardAddress = AddressUtil.bytesToAddress((byte[])((ByteString)addrKey).getBytes());
        }
        catch (Exception e) {
            throw new CborDeserializationException("Bytes cannot be converted to bech32 address", e);
        }
        UnsignedInteger coinDI = (UnsignedInteger)withdrawalMap.get(addrKey);
        return new Withdrawal(rewardAddress, coinDI != null ? coinDI.getValue() : null);
    }

    public void serialize(Map withdrawalMap) throws AddressExcepion {
        Objects.requireNonNull(withdrawalMap);
        byte[] addressBytes = AddressUtil.addressToBytes((String)this.rewardAddress);
        withdrawalMap.put((DataItem)new ByteString(addressBytes), (DataItem)new UnsignedInteger(this.coin));
    }

    public static WithdrawalBuilder builder() {
        return new WithdrawalBuilder();
    }

    public String getRewardAddress() {
        return this.rewardAddress;
    }

    public BigInteger getCoin() {
        return this.coin;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Withdrawal)) {
            return false;
        }
        Withdrawal other = (Withdrawal)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$rewardAddress = this.getRewardAddress();
        String other$rewardAddress = other.getRewardAddress();
        if (this$rewardAddress == null ? other$rewardAddress != null : !this$rewardAddress.equals(other$rewardAddress)) {
            return false;
        }
        BigInteger this$coin = this.getCoin();
        BigInteger other$coin = other.getCoin();
        return !(this$coin == null ? other$coin != null : !((Object)this$coin).equals(other$coin));
    }

    protected boolean canEqual(Object other) {
        return other instanceof Withdrawal;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $rewardAddress = this.getRewardAddress();
        result = result * 59 + ($rewardAddress == null ? 43 : $rewardAddress.hashCode());
        BigInteger $coin = this.getCoin();
        result = result * 59 + ($coin == null ? 43 : ((Object)$coin).hashCode());
        return result;
    }

    public Withdrawal(String rewardAddress, BigInteger coin) {
        this.rewardAddress = rewardAddress;
        this.coin = coin;
    }

    public Withdrawal() {
    }

    public static class WithdrawalBuilder {
        private String rewardAddress;
        private BigInteger coin;

        WithdrawalBuilder() {
        }

        public WithdrawalBuilder rewardAddress(String rewardAddress) {
            this.rewardAddress = rewardAddress;
            return this;
        }

        public WithdrawalBuilder coin(BigInteger coin) {
            this.coin = coin;
            return this;
        }

        public Withdrawal build() {
            return new Withdrawal(this.rewardAddress, this.coin);
        }

        public String toString() {
            return "Withdrawal.WithdrawalBuilder(rewardAddress=" + this.rewardAddress + ", coin=" + String.valueOf(this.coin) + ")";
        }
    }
}

